/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

class ElementsRange {
    private final PsiElement myStart;
    private final PsiElement myEnd;

    ElementsRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            ElementsRange.$$$reportNull$$$0(0);
        }
        if (end == null) {
            ElementsRange.$$$reportNull$$$0(1);
        }
        this.myStart = start;
        this.myEnd = end;
    }

    ElementsRange(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ElementsRange.$$$reportNull$$$0(2);
        }
        this.myStart = elements[0];
        this.myEnd = elements[elements.length - 1];
    }

    public TextRange getTextRange() {
        if (this.myStart == this.myEnd) {
            return this.myStart.getTextRange();
        }
        return new TextRange(this.myStart.getTextRange().getStartOffset(), this.myEnd.getTextRange().getEndOffset());
    }

    public ElementsRange findCopyInFile(@NotNull PsiFile file) {
        if (file == null) {
            ElementsRange.$$$reportNull$$$0(3);
        }
        PsiElement copyStart = ElementsRange.findCopyInFile(file, this.myStart);
        PsiElement copyEnd = ElementsRange.findCopyInFile(file, this.myEnd);
        if (copyStart != null && copyEnd != null) {
            return new ElementsRange(copyStart, copyEnd);
        }
        return null;
    }

    private static PsiElement findCopyInFile(@NotNull PsiFile file, @NotNull PsiElement element) {
        if (file == null) {
            ElementsRange.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ElementsRange.$$$reportNull$$$0(5);
        }
        TextRange textRange = element.getTextRange();
        return CodeInsightUtil.findElementInRange((PsiFile)file, (int)textRange.getStartOffset(), (int)textRange.getEndOffset(), (Class)element.getClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/ElementsRange";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findCopyInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

