/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BooleanReturnModel {
    private final boolean myEarlyReturnValue;
    private final int myEarlyReturnValueCount;
    private final int myTerminalNonRemovableValueCount;
    private final boolean myHasReturnInLoopOrSwitch;

    BooleanReturnModel(boolean value, int count, int terminalNonRemovableValueCount, boolean hasReturnInLoopOrSwitch) {
        this.myEarlyReturnValue = value;
        this.myEarlyReturnValueCount = count;
        this.myTerminalNonRemovableValueCount = terminalNonRemovableValueCount;
        this.myHasReturnInLoopOrSwitch = hasReturnInLoopOrSwitch;
    }

    @Nullable
    InlineTransformer getTransformer(PsiReference ref) {
        PsiElement parent;
        if (!(ref instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiReferenceExpression)ref).getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        boolean wantedValue = true;
        PsiMethodCallExpression expression = call;
        while ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(((PsiPrefixExpression)parent).getOperationTokenType())) {
            wantedValue = !wantedValue;
            expression = (PsiPrefixExpression)parent;
        }
        if (parent instanceof PsiIfStatement) {
            boolean allowReplacement;
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement thenStatement = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getThenBranch());
            PsiStatement elseStatement = ControlFlowUtils.stripBraces((PsiStatement)ifStatement.getElseBranch());
            if (elseStatement == null && wantedValue == this.myEarlyReturnValue && (allowReplacement = this.myEarlyReturnValueCount == 1 && this.myTerminalNonRemovableValueCount == 0 ? this.isJumpOut(thenStatement) : this.isCopyableJumpOut(thenStatement))) {
                return this.getTransformer(thenStatement, null);
            }
            if (this.isJumpOut(thenStatement) && this.isJumpOut(elseStatement) && this.myTerminalNonRemovableValueCount == 0 && this.myEarlyReturnValueCount == 1) {
                PsiStatement earlyStatement = this.myEarlyReturnValue == wantedValue ? thenStatement : elseStatement;
                PsiStatement finalStatement = this.myEarlyReturnValue != wantedValue ? thenStatement : elseStatement;
                return this.getTransformer(earlyStatement, finalStatement);
            }
        }
        return null;
    }

    private boolean isJumpOut(PsiStatement statement) {
        return statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement || !this.myHasReturnInLoopOrSwitch && (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement);
    }

    private boolean isCopyableJumpOut(PsiStatement statement) {
        if (!this.myHasReturnInLoopOrSwitch && (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement)) {
            return true;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement thenReturn = (PsiReturnStatement)statement;
            return thenReturn.getReturnValue() == null || ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)thenReturn.getReturnValue());
        }
        return false;
    }

    @NotNull
    private InlineTransformer getTransformer(PsiStatement earlyStatement, PsiStatement finalStatement) {
        InlineTransformer inlineTransformer = (methodCopy, callSite, returnType) -> {
            PsiReturnStatement[] returns;
            PsiCodeBlock block = Objects.requireNonNull(methodCopy.getBody());
            for (PsiReturnStatement returnStatement : returns = PsiUtil.findReturnStatements((PsiMethod)methodCopy)) {
                Boolean value;
                PsiExpression returnValue = Objects.requireNonNull(returnStatement.getReturnValue());
                PsiLiteralExpression literal = ExpressionUtils.getLiteral((PsiExpression)returnValue);
                Boolean bl = value = literal == null ? null : (Boolean)ObjectUtils.tryCast((Object)literal.getValue(), Boolean.class);
                if (value == null) {
                    CommentTracker tracker = new CommentTracker();
                    String condition = this.myEarlyReturnValue ? tracker.text((PsiElement)returnValue) : BoolUtils.getNegatedExpressionText((PsiExpression)returnValue, (CommentTracker)tracker);
                    tracker.replaceAndRestoreComments((PsiElement)returnStatement, "if(" + condition + ") {" + earlyStatement.getText() + "}");
                    continue;
                }
                if (value == this.myEarlyReturnValue) {
                    new CommentTracker().replaceAndRestoreComments((PsiElement)returnStatement, (PsiElement)earlyStatement);
                    continue;
                }
                new CommentTracker().delete((PsiElement)returnStatement);
            }
            if (finalStatement != null) {
                block.addBefore((PsiElement)finalStatement, (PsiElement)block.getRBrace());
            }
            return null;
        };
        if (inlineTransformer == null) {
            BooleanReturnModel.$$$reportNull$$$0(0);
        }
        return inlineTransformer;
    }

    @Nullable
    static BooleanReturnModel from(@NotNull PsiCodeBlock body, PsiReturnStatement @NotNull [] returns) {
        if (body == null) {
            BooleanReturnModel.$$$reportNull$$$0(1);
        }
        if (returns == null) {
            BooleanReturnModel.$$$reportNull$$$0(2);
        }
        ArrayList<PsiExpression> terminal = new ArrayList<PsiExpression>();
        boolean earlyValue = false;
        int earlyCount = 0;
        boolean hasReturnInLoopOrSwitch = false;
        for (PsiReturnStatement returnStatement : returns) {
            PsiExpression returnValue;
            if (!hasReturnInLoopOrSwitch) {
                hasReturnInLoopOrSwitch = BooleanReturnModel.isInLoopOrSwitch(body, returnStatement);
            }
            if ((returnValue = returnStatement.getReturnValue()) == null || !PsiTypes.booleanType().equals((Object)returnValue.getType())) {
                return null;
            }
            if (ControlFlowUtils.blockCompletesWithStatement((PsiCodeBlock)body, (PsiStatement)returnStatement)) {
                terminal.add(returnValue);
                continue;
            }
            PsiLiteralExpression literal = ExpressionUtils.getLiteral((PsiExpression)returnValue);
            if (literal == null) {
                return null;
            }
            Boolean literalValue = (Boolean)ObjectUtils.tryCast((Object)literal.getValue(), Boolean.class);
            if (literalValue == null) {
                return null;
            }
            if (earlyCount == 0) {
                earlyValue = literalValue;
            } else if (earlyValue != literalValue) {
                return null;
            }
            ++earlyCount;
        }
        if (earlyCount == 0) {
            return null;
        }
        int terminalCount = 0;
        for (PsiExpression value : terminal) {
            PsiLiteralExpression literal = ExpressionUtils.getLiteral((PsiExpression)value);
            if (literal == null || !(literal.getValue() instanceof Boolean)) {
                ++terminalCount;
                continue;
            }
            if (!literal.getValue().equals(earlyValue)) continue;
            ++earlyCount;
        }
        return new BooleanReturnModel(earlyValue, earlyCount, terminalCount, hasReturnInLoopOrSwitch);
    }

    private static boolean isInLoopOrSwitch(@NotNull PsiCodeBlock body, @NotNull PsiReturnStatement returnStatement) {
        if (body == null) {
            BooleanReturnModel.$$$reportNull$$$0(3);
        }
        if (returnStatement == null) {
            BooleanReturnModel.$$$reportNull$$$0(4);
        }
        for (PsiElement parent = returnStatement.getParent(); parent != body; parent = parent.getParent()) {
            if (!(parent instanceof PsiLoopStatement) && !(parent instanceof PsiSwitchStatement)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/BooleanReturnModel";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returns";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransformer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/BooleanReturnModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInLoopOrSwitch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

