/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.inline.InlineParameterExpressionProcessor;
import com.intellij.refactoring.inline.InlineParameterHandler;
import com.intellij.refactoring.ui.RefactoringDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class InlineParameterDialog
extends RefactoringDialog {
    private JCheckBox myCreateLocalCheckbox;
    private final PsiCallExpression myMethodCall;
    private final PsiMethod myMethod;
    private final PsiParameter myParameter;
    private final PsiExpression myInitializer;

    public InlineParameterDialog(PsiCallExpression methodCall, PsiMethod method, PsiParameter psiParameter, PsiExpression initializer, boolean createLocal) {
        super(method.getProject(), true);
        this.myMethodCall = methodCall;
        this.myMethod = method;
        this.myParameter = psiParameter;
        this.myInitializer = initializer;
        this.init();
        this.myCreateLocalCheckbox.setSelected(createLocal);
        this.setTitle(InlineParameterHandler.getRefactoringName());
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        String message = JavaRefactoringBundle.message((String)"inline.parameter.confirmation", (Object[])new Object[]{this.myParameter.getName(), this.myInitializer.getText()});
        JLabel label = new JLabel(message, UIManager.getIcon("OptionPane.questionIcon"), 2);
        panel.add((Component)label, "North");
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myCreateLocalCheckbox = new JCheckBox(JavaRefactoringBundle.message((String)"inline.parameter.replace.with.local.checkbox", (Object[])new Object[0]));
        panel.add((Component)this.myCreateLocalCheckbox, "South");
        return panel;
    }

    protected String getHelpId() {
        return "refactoring.inlineVariable";
    }

    protected void doAction() {
        this.invokeRefactoring(new InlineParameterExpressionProcessor(this.myMethodCall, this.myMethod, this.myParameter, this.myInitializer, this.myCreateLocalCheckbox.isSelected()));
    }
}

