/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineToAnonymousClassHandler;
import com.intellij.refactoring.inline.InlineToAnonymousConstructorProcessor;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.SealedUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineToAnonymousClassProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InlineToAnonymousClassProcessor.class);
    private PsiClass myClass;
    private final PsiCall myCallToInline;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInComments;
    private final boolean mySearchInNonJavaFiles;

    public InlineToAnonymousClassProcessor(Project project, PsiClass psiClass, @Nullable PsiCall callToInline, boolean inlineThisOnly, boolean searchInComments, boolean searchInNonJavaFiles) {
        super(project);
        this.myClass = psiClass;
        this.myCallToInline = callToInline;
        this.myInlineThisOnly = inlineThisOnly;
        assert (!this.myInlineThisOnly || this.myCallToInline != null);
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(0);
        }
        return new InlineViewDescriptor((PsiElement)this.myClass);
    }

    public UsageInfo @NotNull [] findUsages() {
        if (this.myInlineThisOnly) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo((PsiElement)this.myCallToInline)};
            if (usageInfoArray == null) {
                InlineToAnonymousClassProcessor.$$$reportNull$$$0(1);
            }
            return usageInfoArray;
        }
        HashSet<Object> usages = new HashSet<Object>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)this.myClass, (SearchScope)this.myRefactoringScope).asIterable()) {
            usages.add(new UsageInfo(reference.getElement()));
        }
        String qName = this.myClass.getQualifiedName();
        if (qName != null) {
            SearchScope searchScope;
            List nonCodeUsages = Collections.synchronizedList(new ArrayList());
            if (this.mySearchInComments) {
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myClass, (SearchScope)this.myRefactoringScope, (String)qName, nonCodeUsages, (UsageInfoFactory)new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            if (this.mySearchInNonJavaFiles && (searchScope = this.myRefactoringScope) instanceof GlobalSearchScope) {
                GlobalSearchScope scope = (GlobalSearchScope)searchScope;
                TextOccurrencesUtil.addTextOccurrences((PsiElement)this.myClass, (String)qName, (GlobalSearchScope)scope, nonCodeUsages, (UsageInfoFactory)new NonCodeUsageInfoFactory((PsiElement)this.myClass, qName));
            }
            usages.addAll(nonCodeUsages);
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(3);
        }
        if (!this.myInlineThisOnly && !this.myClass.isWritable()) {
            List list = Collections.emptyList();
            if (list == null) {
                InlineToAnonymousClassProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection collection = super.getElementsToWrite(descriptor);
        if (collection == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(5);
        }
        return collection;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(6);
        }
        assert (elements.length == 1);
        this.myClass = (PsiClass)elements[0];
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(7);
        }
        if (super.isPreviewUsages(usages)) {
            return true;
        }
        for (UsageInfo usage : usages) {
            if (!InlineToAnonymousClassProcessor.isForcePreview(usage)) continue;
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"occurrences.found.in.comments.strings.and.non.java.files"));
            return true;
        }
        return false;
    }

    private static boolean isForcePreview(UsageInfo usage) {
        if (usage.isNonCodeUsage) {
            return true;
        }
        PsiElement element = usage.getElement();
        return element != null && !(element.getContainingFile() instanceof PsiJavaFile);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap<PsiElement, String> conflicts;
        if (refUsages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(8);
        }
        if (!(conflicts = this.getConflicts((UsageInfo[])refUsages.get())).isEmpty()) {
            return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
        }
        return super.preprocessUsages(refUsages);
    }

    public MultiMap<PsiElement, String> getConflicts(UsageInfo[] usages) {
        final MultiMap result = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector(){

            @Override
            protected void checkAddMember(@NotNull PsiMember member) {
                if (member == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)member, (boolean)false)) {
                    return;
                }
                PsiModifierList modifierList = member.getModifierList();
                if (member.getContainingClass() == InlineToAnonymousClassProcessor.this.myClass.getSuperClass() && modifierList != null && modifierList.hasModifierProperty("protected")) {
                    return;
                }
                super.checkAddMember(member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor$1", "checkAddMember"));
            }
        };
        this.addInaccessibleMemberConflicts(usages, collector, (MultiMap<PsiElement, String>)result);
        this.myClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitParameter(@NotNull PsiParameter parameter) {
                if (parameter == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitParameter(parameter);
                if (!InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)parameter.getType()))) {
                    return;
                }
                for (PsiReference psiReference : ReferencesSearch.search((PsiElement)parameter).asIterable()) {
                    PsiMethod method;
                    PsiElement resolvedMember;
                    PsiReferenceExpression referenceExpression;
                    PsiElement refElement = psiReference.getElement();
                    if (!(refElement instanceof PsiExpression) || (referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refElement, PsiReferenceExpression.class)) == null || referenceExpression.getQualifierExpression() != refElement || (resolvedMember = referenceExpression.resolve()) == null || !PsiTreeUtil.isAncestor((PsiElement)InlineToAnonymousClassProcessor.this.myClass, (PsiElement)resolvedMember, (boolean)false) || resolvedMember instanceof PsiMethod && InlineToAnonymousClassProcessor.this.myClass.findMethodsBySignature(method = (PsiMethod)resolvedMember, true).length > 1) continue;
                    result.putValue((Object)refElement, (Object)JavaRefactoringBundle.message((String)"inline.to.anonymous.no.method.calls", (Object[])new Object[0]));
                }
            }

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitNewExpression(expression);
                if (!InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)expression.getType()))) {
                    return;
                }
                result.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.to.anonymous.no.ctor.calls", (Object[])new Object[0]));
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                PsiMethod method;
                if (expression == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression != null && !InlineToAnonymousClassProcessor.this.myClass.isEquivalentTo((PsiElement)PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType()))) {
                    return;
                }
                PsiElement resolved = methodExpression.resolve();
                if (resolved instanceof PsiMethod && "getClass".equals((method = (PsiMethod)resolved).getName()) && method.getParameterList().isEmpty()) {
                    result.putValue((Object)methodExpression, (Object)JavaRefactoringBundle.message((String)"inline.to.anonymous.no.get.class.calls", (Object[])new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParameter";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result;
    }

    private void addInaccessibleMemberConflicts(UsageInfo[] usages, ReferencedElementsCollector collector, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        for (PsiElement element = this.myClass.getLBrace(); element != null; element = element.getNextSibling()) {
            element.accept((PsiElementVisitor)collector);
        }
        Map<PsiMember, Set<PsiMember>> containersToReferenced = InlineMethodProcessor.getInaccessible(collector.myReferencedMembers, usages, (PsiElement)this.myClass);
        String classDescription = RefactoringUIUtil.getDescription((PsiElement)this.myClass, (boolean)true);
        containersToReferenced.forEach((container, inaccessibles) -> {
            for (PsiMember inaccessible : inaccessibles) {
                String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)inaccessible, (boolean)true);
                String containerDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
                String message = RefactoringBundle.message((String)"0.which.is.used.in.1.not.accessible.from.call.site.s.in.2", (Object[])new Object[]{referencedDescription, classDescription, containerDescription});
                conflicts.putValue((Object)(usages.length == 1 ? inaccessible : container), (Object)StringUtil.capitalize((String)message));
            }
        });
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiClassType superType;
        if (usages == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(9);
        }
        LOG.assertTrue((superType = InlineToAnonymousClassProcessor.getSuperType(this.myClass)) != null);
        ArrayList<PsiImportStatement> elementsToDelete = new ArrayList<PsiImportStatement>();
        ArrayList<PsiNewExpression> newExpressions = new ArrayList<PsiNewExpression>();
        for (UsageInfo info : usages) {
            PsiElement psiElement;
            PsiElement element = info.getElement();
            if (element instanceof PsiNewExpression) {
                PsiNewExpression exp = (PsiNewExpression)element;
                newExpressions.add(exp);
                continue;
            }
            if (element != null && (psiElement = element.getParent()) instanceof PsiNewExpression) {
                PsiNewExpression exp = (PsiNewExpression)psiElement;
                newExpressions.add(exp);
                continue;
            }
            if (element instanceof PsiJavaCodeReferenceElement && (psiElement = element.getParent()) instanceof PsiReferenceList) {
                PsiClass parentClass;
                PsiReferenceList refList = (PsiReferenceList)psiElement;
                PsiElement psiElement2 = refList.getParent();
                if (!(psiElement2 instanceof PsiClass) || refList != (parentClass = (PsiClass)psiElement2).getPermitsList()) continue;
                SealedUtils.removeFromPermitsList((PsiClass)parentClass, (PsiClass)this.myClass);
                continue;
            }
            PsiImportStatement statement = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
            if (statement != null && !this.myInlineThisOnly) {
                elementsToDelete.add(statement);
                continue;
            }
            if (!(element instanceof PsiJavaCodeReferenceElement)) continue;
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)element;
            this.replaceWithSuperType(ref, superType);
        }
        newExpressions.sort(PsiUtil.BY_POSITION);
        for (PsiNewExpression psiNewExpression : newExpressions) {
            this.replaceNewOrType(psiNewExpression, superType);
        }
        for (PsiElement psiElement : elementsToDelete) {
            try {
                if (!psiElement.isValid()) continue;
                psiElement.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!this.myInlineThisOnly && this.myClass.getOriginalElement().isWritable()) {
            try {
                this.myClass.delete();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void replaceNewOrType(PsiNewExpression psiNewExpression, PsiClassType superType) {
        try {
            if (!psiNewExpression.isArrayCreation()) {
                new InlineToAnonymousConstructorProcessor(this.myClass, psiNewExpression, (PsiType)superType).run();
            } else {
                PsiClass target = superType.resolve();
                assert (target != null) : superType;
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
                PsiJavaCodeReferenceElement element = factory.createClassReferenceElement(target);
                PsiJavaCodeReferenceElement reference = psiNewExpression.getClassReference();
                assert (reference != null) : psiNewExpression;
                reference.replace((PsiElement)element);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void replaceWithSuperType(PsiJavaCodeReferenceElement ref, PsiClassType superType) {
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiTypeElement.class);
        if (typeElement == null) {
            return;
        }
        PsiClassType type = (PsiClassType)typeElement.getType();
        PsiClassType.ClassResolveResult classResolveResult = type.resolveGenerics();
        PsiClassType substType = (PsiClassType)classResolveResult.getSubstitutor().substitute((PsiType)superType);
        try {
            PsiElement psiElement;
            PsiJavaCodeReferenceElement replacement2 = JavaPsiFacade.getElementFactory((Project)this.myProject).createReferenceElementByType(substType);
            while (!this.myClass.isEquivalentTo(ref.resolve()) && (psiElement = ref.getQualifier()) instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement qRef;
                ref = qRef = (PsiJavaCodeReferenceElement)psiElement;
            }
            PsiElement replaced = ref.replace((PsiElement)replacement2);
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(replaced);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    public static PsiClassType getSuperType(PsiClass aClass) {
        PsiClassType[] classTypes;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            return null;
        }
        PsiClassType[] interfaceTypes = aClass.getImplementsListTypes();
        PsiClassType superType = interfaceTypes.length > 0 && !InlineToAnonymousClassHandler.isRedundantImplements(superClass, interfaceTypes[0]) ? interfaceTypes[0] : ((classTypes = aClass.getExtendsListTypes()).length > 0 ? classTypes[0] : factory.createType(superClass));
        return superType;
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"inline.to.anonymous.command.name", (Object[])new Object[]{this.myClass.getQualifiedName()});
        if (string == null) {
            InlineToAnonymousClassProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineToAnonymousClassProcessor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 10 -> new IllegalStateException(string);
        };
    }
}

