/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InlineToAnonymousConstructorProcessor {
    private static final Logger LOG = Logger.getInstance(InlineToAnonymousConstructorProcessor.class);
    private static final Key<PsiAssignmentExpression> ourAssignmentKey = Key.create((String)"assignment");
    private static final Key<PsiCallExpression> ourCallKey = Key.create((String)"call");
    public static final ElementPattern<PsiLiteralExpression> ourNullPattern = PlatformPatterns.psiElement(PsiLiteralExpression.class).withText("null");
    private static final ElementPattern<PsiExpressionStatement> ourAssignmentPattern = PsiJavaPatterns.psiExpressionStatement().withChild((ElementPattern)PlatformPatterns.psiElement(PsiAssignmentExpression.class).save(ourAssignmentKey));
    private static final ElementPattern<PsiExpressionStatement> ourSuperCallPattern = PsiJavaPatterns.psiExpressionStatement().withFirstChild((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiMethodCallExpression.class).save(ourCallKey)).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("super")));
    private static final ElementPattern<PsiExpressionStatement> ourThisCallPattern = PsiJavaPatterns.psiExpressionStatement().withFirstChild((ElementPattern)PlatformPatterns.psiElement(PsiMethodCallExpression.class).withFirstChild((ElementPattern)PlatformPatterns.psiElement().withText("this")));
    private final PsiClass myClass;
    private PsiNewExpression myNewExpression;
    private final PsiType mySuperType;
    private final Map<String, PsiExpression> myFieldInitializers = new HashMap<String, PsiExpression>();
    private final Map<PsiParameter, PsiLocalVariable> myLocalsForParameters = new HashMap<PsiParameter, PsiLocalVariable>();
    private PsiElement myNewStatement;
    private final PsiElementFactory myElementFactory;
    private PsiMethod myConstructor;
    private PsiExpression[] myConstructorArguments;
    private PsiParameterList myConstructorParameters;

    InlineToAnonymousConstructorProcessor(PsiClass aClass, PsiNewExpression psiNewExpression, PsiType superType) {
        this.myClass = aClass;
        this.myNewExpression = psiNewExpression;
        this.mySuperType = superType;
        this.myNewStatement = PsiTreeUtil.getParentOfType((PsiElement)this.myNewExpression, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)this.myClass.getProject());
    }

    public void run() {
        this.checkInlineChainingConstructor();
        JavaResolveResult classResolveResult = this.myNewExpression.getClassReference().advancedResolve(false);
        JavaResolveResult methodResolveResult = this.myNewExpression.resolveMethodGenerics();
        PsiElement element = methodResolveResult.getElement();
        this.myConstructor = element == null || element instanceof SyntheticElement ? null : (PsiMethod)element.getNavigationElement();
        this.myConstructorArguments = this.initConstructorArguments();
        PsiSubstitutor classResolveSubstitutor = classResolveResult.getSubstitutor();
        PsiType substType = classResolveSubstitutor.substitute(this.mySuperType);
        PsiTypeParameter[] typeParams = this.myClass.getTypeParameters();
        PsiType[] substitutedParameters = PsiType.createArray((int)typeParams.length);
        for (int i = 0; i < typeParams.length; ++i) {
            substitutedParameters[i] = classResolveSubstitutor.substitute(typeParams[i]);
        }
        PsiNewExpression superNewExpressionTemplate = (PsiNewExpression)this.myElementFactory.createExpressionFromText("new " + substType.getCanonicalText() + "() {}", (PsiElement)this.myNewExpression.getContainingFile());
        PsiClassInitializer initializerBlock = this.myElementFactory.createClassInitializer();
        PsiLocalVariable outerClassLocal = null;
        if (this.myNewExpression.getQualifier() != null && this.myClass.getContainingClass() != null) {
            outerClassLocal = this.generateOuterClassLocal();
        }
        if (this.myConstructor != null) {
            this.myConstructorParameters = this.myConstructor.getParameterList();
            PsiExpressionList argumentList = superNewExpressionTemplate.getArgumentList();
            assert (argumentList != null);
            if (this.myNewStatement != null) {
                this.generateLocalsForArguments();
            }
            this.analyzeConstructor(initializerBlock.getBody());
            this.addSuperConstructorArguments(argumentList);
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myClass.getNavigationElement(), (boolean)true);
        PsiClass classCopy = (PsiClass)this.myClass.getNavigationElement().copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myClass);
        PsiAnonymousClass anonymousClass = superNewExpressionTemplate.getAnonymousClass();
        assert (anonymousClass != null);
        int fieldCount = this.myClass.getFields().length;
        int processedFields = 0;
        PsiElement token = anonymousClass.getRBrace();
        if (!initializerBlock.getBody().isEmpty() && fieldCount == 0) {
            InlineToAnonymousConstructorProcessor.insertInitializerBefore(initializerBlock, (PsiClass)anonymousClass, token);
        }
        for (PsiElement child : classCopy.getChildren()) {
            PsiMethod method;
            if (child instanceof PsiMethod && !(method = (PsiMethod)child).isConstructor() || child instanceof PsiClassInitializer || child instanceof PsiClass) {
                if (!this.myFieldInitializers.isEmpty() || !this.myLocalsForParameters.isEmpty() || classResolveSubstitutor != PsiSubstitutor.EMPTY || outerClassLocal != null) {
                    this.replaceReferences((PsiMember)child, substitutedParameters, outerClassLocal);
                }
                anonymousClass.addBefore(child, token);
                continue;
            }
            if (!(child instanceof PsiField)) continue;
            PsiField field = (PsiField)child;
            this.replaceReferences((PsiMember)field, substitutedParameters, outerClassLocal);
            PsiExpression initializer = this.myFieldInitializers.get(field.getName());
            field = (PsiField)anonymousClass.addBefore((PsiElement)field, token);
            if (initializer != null) {
                field.setInitializer(initializer);
            }
            if (++processedFields != fieldCount || initializerBlock.getBody().isEmpty()) continue;
            InlineToAnonymousConstructorProcessor.insertInitializerBefore(initializerBlock, (PsiClass)anonymousClass, token);
        }
        if (PsiTreeUtil.getChildrenOfType((PsiElement)anonymousClass, PsiMember.class) == null) {
            anonymousClass.deleteChildRange(anonymousClass.getLBrace(), anonymousClass.getRBrace());
        }
        PsiNewExpression superNewExpression = (PsiNewExpression)this.myNewExpression.replace((PsiElement)superNewExpressionTemplate);
        PsiAnonymousClass newExpressionAnonymousClass = (superNewExpression = (PsiNewExpression)ChangeContextUtil.decodeContextInfo((PsiElement)superNewExpression, (PsiClass)superNewExpression.getAnonymousClass(), null)).getAnonymousClass();
        if (newExpressionAnonymousClass != null && AnonymousCanBeLambdaInspection.isLambdaForm((PsiAnonymousClass)newExpressionAnonymousClass, (boolean)false, Collections.emptySet())) {
            PsiExpression lambda = AnonymousCanBeLambdaInspection.replaceAnonymousWithLambda((PsiElement)superNewExpression, (PsiType)newExpressionAnonymousClass.getBaseClassType());
            JavaCodeStyleManager.getInstance((Project)newExpressionAnonymousClass.getProject()).shortenClassReferences(superNewExpression.replace((PsiElement)lambda));
        } else {
            JavaCodeStyleManager.getInstance((Project)superNewExpression.getProject()).shortenClassReferences((PsiElement)superNewExpression);
        }
    }

    private static void insertInitializerBefore(PsiClassInitializer initializerBlock, PsiClass anonymousClass, PsiElement token) {
        anonymousClass.addBefore(CodeEditUtil.createLineFeed((PsiManager)token.getManager()), token);
        anonymousClass.addBefore((PsiElement)initializerBlock, token);
        anonymousClass.addBefore(CodeEditUtil.createLineFeed((PsiManager)token.getManager()), token);
    }

    private void checkInlineChainingConstructor() {
        PsiMethod constructor;
        while ((constructor = this.myNewExpression.resolveConstructor()) != null && InlineUtil.isChainingConstructor(constructor)) {
            InlineMethodProcessor.inlineConstructorCall((PsiCall)this.myNewExpression);
        }
    }

    private void analyzeConstructor(PsiCodeBlock initializerBlock) {
        PsiCodeBlock body = this.myConstructor.getBody();
        assert (body != null);
        for (PsiElement child : body.getChildren()) {
            if (child instanceof PsiStatement) {
                PsiStatement stmt = (PsiStatement)child;
                ProcessingContext context = new ProcessingContext();
                if (ourAssignmentPattern.accepts((Object)stmt, context)) {
                    PsiAssignmentExpression expression = (PsiAssignmentExpression)context.get(ourAssignmentKey);
                    if (!this.processAssignmentInConstructor(expression)) continue;
                    initializerBlock.addBefore(this.replaceParameterReferences((PsiElement)stmt, null, false), (PsiElement)initializerBlock.getRBrace());
                    continue;
                }
                if (ourSuperCallPattern.accepts((Object)stmt) || ourThisCallPattern.accepts((Object)stmt)) continue;
                this.replaceParameterReferences((PsiElement)stmt, new ArrayList(), false);
                initializerBlock.addBefore((PsiElement)stmt, (PsiElement)initializerBlock.getRBrace());
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            if (child.getPrevSibling() instanceof PsiWhiteSpace) {
                initializerBlock.addBefore(child.getPrevSibling(), (PsiElement)initializerBlock.getRBrace());
            }
            initializerBlock.addBefore(child, (PsiElement)initializerBlock.getRBrace());
        }
    }

    private boolean processAssignmentInConstructor(PsiAssignmentExpression expression) {
        PsiExpression psiExpression = expression.getLExpression();
        if (psiExpression instanceof PsiReferenceExpression) {
            PsiReferenceExpression lExpr = (PsiReferenceExpression)psiExpression;
            PsiExpression rExpr = expression.getRExpression();
            if (rExpr == null) {
                return false;
            }
            PsiElement psiElement = lExpr.resolve();
            if (psiElement instanceof PsiField) {
                PsiField field = (PsiField)psiElement;
                if (this.myClass.getManager().areElementsEquivalent((PsiElement)field.getContainingClass(), (PsiElement)this.myClass)) {
                    PsiExpression initializer;
                    ArrayList localVarRefs = new ArrayList();
                    try {
                        initializer = (PsiExpression)this.replaceParameterReferences(rExpr.copy(), localVarRefs, false);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                        return false;
                    }
                    if (!localVarRefs.isEmpty()) {
                        return true;
                    }
                    this.myFieldInitializers.put(field.getName(), initializer);
                }
            } else if (psiElement instanceof PsiVariable) {
                return true;
            }
        }
        return false;
    }

    public static boolean isConstant(PsiExpression expr) {
        Object constantValue = JavaPsiFacade.getInstance((Project)expr.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr);
        return constantValue != null || ourNullPattern.accepts((Object)expr);
    }

    private PsiLocalVariable generateOuterClassLocal() {
        PsiClass outerClass = this.myClass.getContainingClass();
        assert (outerClass != null);
        return this.generateLocal(StringUtil.decapitalize((String)StringUtil.notNullize((String)outerClass.getName())), (PsiType)this.myElementFactory.createType(outerClass), this.myNewExpression.getQualifier());
    }

    private PsiLocalVariable generateLocal(String baseName, @NotNull PsiType type, PsiExpression initializer) {
        String localName;
        if (type == null) {
            InlineToAnonymousConstructorProcessor.$$$reportNull$$$0(0);
        }
        Project project = this.myClass.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        Object baseNameForIndex = baseName;
        int index = 0;
        while (this.myClass.findFieldByName(localName = codeStyleManager.suggestUniqueVariableName((String)baseNameForIndex, (PsiElement)this.myNewExpression, true), false) != null) {
            baseNameForIndex = baseName + ++index;
        }
        try {
            PsiElement parent;
            PsiDeclarationStatement declaration = this.myElementFactory.createVariableDeclarationStatement(localName, type, initializer);
            PsiLocalVariable variable = (PsiLocalVariable)declaration.getDeclaredElements()[0];
            if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.EFFECTIVELY_FINAL, (PsiElement)this.myNewExpression) || JavaCodeStyleSettings.getInstance((PsiFile)initializer.getContainingFile()).GENERATE_FINAL_LOCALS) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)variable, (String)"final", (boolean)true);
            }
            if ((parent = this.myNewStatement.getParent()) instanceof PsiCodeBlock) {
                variable = (PsiLocalVariable)((PsiDeclarationStatement)parent.addBefore((PsiElement)declaration, this.myNewStatement)).getDeclaredElements()[0];
            } else {
                PsiElement psiElement = this.myNewStatement;
                if (psiElement instanceof PsiLambdaExpression) {
                    PsiLambdaExpression expression = (PsiLambdaExpression)psiElement;
                    Object marker = new Object();
                    PsiTreeUtil.mark((PsiElement)this.myNewExpression, (Object)marker);
                    PsiCodeBlock block = CommonJavaRefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)expression);
                    this.myNewStatement = block.getStatements()[0];
                    this.myNewExpression = (PsiNewExpression)PsiTreeUtil.releaseMark((PsiElement)this.myNewStatement, (Object)marker);
                    variable = (PsiLocalVariable)((PsiDeclarationStatement)block.addBefore((PsiElement)declaration, this.myNewStatement)).getDeclaredElements()[0];
                    this.myConstructorArguments = this.initConstructorArguments();
                } else {
                    int offsetInStatement = this.myNewExpression.getTextRange().getStartOffset() - this.myNewStatement.getTextRange().getStartOffset();
                    PsiBlockStatement blockStatement = (PsiBlockStatement)this.myElementFactory.createStatementFromText("{}", null);
                    PsiCodeBlock block = blockStatement.getCodeBlock();
                    block.add((PsiElement)declaration);
                    block.add(this.myNewStatement);
                    block = ((PsiBlockStatement)this.myNewStatement.replace((PsiElement)blockStatement)).getCodeBlock();
                    variable = (PsiLocalVariable)((PsiDeclarationStatement)block.getStatements()[0]).getDeclaredElements()[0];
                    this.myNewStatement = block.getStatements()[1];
                    this.myNewExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myNewStatement.findElementAt(offsetInStatement), PsiNewExpression.class);
                    this.myConstructorArguments = this.initConstructorArguments();
                }
            }
            return variable;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiExpression[] initConstructorArguments() {
        return CommonJavaRefactoringUtil.getNonVarargArguments((PsiCall)this.myNewExpression);
    }

    private void generateLocalsForArguments() {
        for (int i = 0; i < this.myConstructorArguments.length; ++i) {
            PsiExpression expr = this.myConstructorArguments[i];
            PsiParameter parameter = this.myConstructorParameters.getParameters()[i];
            if (InlineToAnonymousConstructorProcessor.isConstant(expr)) continue;
            this.myLocalsForParameters.put(parameter, this.generateLocal(parameter.getName(), parameter.getType(), expr));
        }
    }

    private void addSuperConstructorArguments(PsiExpressionList argumentList) {
        PsiCodeBlock body = this.myConstructor.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 0) {
            return;
        }
        ProcessingContext context = new ProcessingContext();
        if (!ourSuperCallPattern.accepts((Object)statements[0], context)) {
            return;
        }
        PsiExpressionList superArguments = ((PsiCallExpression)context.get(ourCallKey)).getArgumentList();
        if (superArguments != null) {
            for (PsiExpression argument : superArguments.getExpressions()) {
                PsiElement superArgument = this.replaceParameterReferences(argument.copy(), new ArrayList(), true);
                argumentList.add(superArgument);
            }
        }
    }

    private PsiElement replaceParameterReferences(PsiElement argument, final @Nullable List<? super PsiReferenceExpression> localVarRefs, final boolean replaceFieldsWithInitializers) {
        PsiReferenceExpression ref;
        Object object;
        if (argument instanceof PsiReferenceExpression && (object = (ref = (PsiReferenceExpression)argument).resolve()) instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)object;
            if (this.myLocalsForParameters.containsKey(parameter)) {
                return argument.replace((PsiElement)this.getParameterReference(parameter));
            }
            int index = this.myConstructorParameters.getParameterIndex(parameter);
            return argument.replace((PsiElement)this.myConstructorArguments[index]);
        }
        final ArrayList parameterReferences = new ArrayList();
        final HashMap elementsToReplace = new HashMap();
        argument.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiParameter parameter;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                PsiElement psiElement = expression.resolve();
                if (psiElement instanceof PsiParameter && (parameter = (PsiParameter)psiElement).getDeclarationScope() == InlineToAnonymousConstructorProcessor.this.myConstructor) {
                    parameterReferences.add(Pair.create((Object)expression, (Object)parameter));
                } else if ((psiElement instanceof PsiField || psiElement instanceof PsiMethod) && ((PsiMember)psiElement).getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass.getSuperClass()) {
                    PsiMember member = (PsiMember)psiElement;
                    if (member.hasModifierProperty("static") && expression.getQualifierExpression() == null) {
                        String qualifiedText = InlineToAnonymousConstructorProcessor.this.myClass.getSuperClass().getQualifiedName() + "." + member.getName();
                        try {
                            PsiExpression replacement2 = InlineToAnonymousConstructorProcessor.this.myElementFactory.createExpressionFromText(qualifiedText, (PsiElement)InlineToAnonymousConstructorProcessor.this.myClass);
                            elementsToReplace.put(expression, replacement2);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                } else if (psiElement instanceof PsiVariable) {
                    PsiExpression initializer;
                    PsiField field;
                    if (localVarRefs != null) {
                        localVarRefs.add(expression);
                    }
                    if (replaceFieldsWithInitializers && psiElement instanceof PsiField && (field = (PsiField)psiElement).getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass && (initializer = field.getInitializer()) != null && InlineToAnonymousConstructorProcessor.isConstant(initializer)) {
                        elementsToReplace.put(expression, initializer);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/inline/InlineToAnonymousConstructorProcessor$1", "visitReferenceExpression"));
            }
        });
        for (Pair pair : parameterReferences) {
            PsiReferenceExpression ref2 = (PsiReferenceExpression)pair.first;
            PsiParameter param = (PsiParameter)pair.second;
            if (this.myLocalsForParameters.containsKey(param)) {
                ref2.replace((PsiElement)this.getParameterReference(param));
                continue;
            }
            int index = this.myConstructorParameters.getParameterIndex(param);
            if (ref2 == argument) {
                argument = argument.replace((PsiElement)this.myConstructorArguments[index]);
                continue;
            }
            ref2.replace((PsiElement)this.myConstructorArguments[index]);
        }
        return CommonJavaRefactoringUtil.replaceElementsWithMap((PsiElement)argument, elementsToReplace);
    }

    private PsiExpression getParameterReference(PsiParameter parameter) {
        PsiLocalVariable variable = this.myLocalsForParameters.get(parameter);
        return this.myElementFactory.createExpressionFromText(variable.getName(), (PsiElement)this.myClass);
    }

    private void replaceReferences(final PsiMember method, final PsiType[] substitutedParameters, final PsiLocalVariable outerClassLocal) {
        final HashMap elementsToReplace = new HashMap();
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                PsiElement element = expression.resolve();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    try {
                        if (InlineToAnonymousConstructorProcessor.this.myClass.getContainingClass() != null && field.getContainingClass() == InlineToAnonymousConstructorProcessor.this.myClass.getContainingClass() && outerClassLocal != null) {
                            PsiReferenceExpression expr = (PsiReferenceExpression)expression.copy();
                            PsiExpression qualifier = InlineToAnonymousConstructorProcessor.this.myElementFactory.createExpressionFromText(outerClassLocal.getName(), (PsiElement)field.getContainingClass());
                            expr.setQualifierExpression(qualifier);
                            elementsToReplace.put(expression, expr);
                        }
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            public void visitTypeParameter(@NotNull PsiTypeParameter classParameter) {
                if (classParameter == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitTypeParameter(classParameter);
                PsiReferenceList list = classParameter.getExtendsList();
                for (PsiJavaCodeReferenceElement reference : list.getReferenceElements()) {
                    PsiElement psiElement = reference.resolve();
                    if (!(psiElement instanceof PsiTypeParameter)) continue;
                    PsiTypeParameter parameter = (PsiTypeParameter)psiElement;
                    this.checkReplaceTypeParameter((PsiElement)reference, parameter);
                }
            }

            public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
                PsiClassType classType;
                if (typeElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.visitTypeElement(typeElement);
                PsiType psiType = typeElement.getType();
                if (psiType instanceof PsiClassType && (psiType = (classType = (PsiClassType)psiType).resolve()) instanceof PsiTypeParameter) {
                    PsiTypeParameter typeParameter = (PsiTypeParameter)psiType;
                    this.checkReplaceTypeParameter((PsiElement)typeElement, typeParameter);
                }
            }

            private void checkReplaceTypeParameter(PsiElement element, PsiTypeParameter target) {
                PsiClass containingClass = method.getContainingClass();
                PsiTypeParameter[] psiTypeParameters = containingClass.getTypeParameters();
                for (int i = 0; i < psiTypeParameters.length; ++i) {
                    if (psiTypeParameters[i] != target) continue;
                    PsiType substType = substitutedParameters[i];
                    if (substType == null) {
                        substType = PsiType.getJavaLangObject((PsiManager)element.getManager(), (GlobalSearchScope)ProjectScope.getAllScope((Project)element.getProject()));
                    }
                    if (element instanceof PsiJavaCodeReferenceElement) {
                        LOG.assertTrue(substType instanceof PsiClassType);
                        elementsToReplace.put(element, InlineToAnonymousConstructorProcessor.this.myElementFactory.createReferenceElementByType((PsiClassType)substType));
                        continue;
                    }
                    elementsToReplace.put(element, InlineToAnonymousConstructorProcessor.this.myElementFactory.createTypeElement(substType));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classParameter";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/inline/InlineToAnonymousConstructorProcessor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeParameter";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CommonJavaRefactoringUtil.replaceElementsWithMap((PsiElement)method, elementsToReplace);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/refactoring/inline/InlineToAnonymousConstructorProcessor", "generateLocal"));
    }
}

