/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.InplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.IntroduceFieldDialog;
import com.intellij.refactoring.introduceField.JavaIntroduceFieldHandlerBase;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.NotInConstructorCallFilter;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceFieldHandler
extends BaseExpressionToFieldHandler
implements JavaIntroduceFieldHandlerBase {
    private InplaceIntroduceFieldPopup myInplaceIntroduceFieldPopup;

    public IntroduceFieldHandler() {
        super(false);
    }

    @Override
    protected String getRefactoringName() {
        return IntroduceFieldHandler.getRefactoringNameText();
    }

    @Override
    protected boolean validClass(PsiClass parentClass, PsiExpression selectedExpr, Editor editor) {
        return IntroduceFieldHandler.canIntroduceField(parentClass, selectedExpr.getType(), editor);
    }

    static boolean canIntroduceField(@NotNull PsiClass parentClass, @Nullable PsiType type, Editor editor) {
        if (parentClass == null) {
            IntroduceFieldHandler.$$$reportNull$$$0(0);
        }
        if (parentClass.isInterface()) {
            String message = JavaRefactoringBundle.message((String)"cannot.introduce.field.in.interface", (Object[])new Object[0]);
            IntroduceFieldHandler.showErrorMessage(parentClass.getProject(), editor, message);
            return false;
        }
        if (PsiTypes.nullType().equals(type) || type instanceof PsiLambdaParameterType || type instanceof PsiLambdaExpressionType || type instanceof PsiMethodReferenceType) {
            String message = JavaRefactoringBundle.message((String)"variable.type.unknown", (Object[])new Object[0]);
            IntroduceFieldHandler.showErrorMessage(parentClass.getProject(), editor, message);
            return false;
        }
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (aClass != null && PsiUtil.isLocalClass((PsiClass)aClass) && !PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)parentClass, (boolean)false)) {
            String message = JavaRefactoringBundle.message((String)"0.is.not.visible.to.members.of.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)parentClass, (boolean)false)});
            IntroduceFieldHandler.showErrorMessage(aClass.getProject(), editor, StringUtil.capitalize((String)message));
            return false;
        }
        return true;
    }

    private static void showErrorMessage(@NotNull Project project, Editor editor, @NlsContexts.DialogMessage String message) {
        if (project == null) {
            IntroduceFieldHandler.$$$reportNull$$$0(1);
        }
        message = RefactoringBundle.getCannotRefactorMessage((String)message);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceFieldHandler.getRefactoringNameText(), (String)"refactoring.introduceField");
    }

    @Override
    protected String getHelpID() {
        return "refactoring.introduceField";
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceFieldHandler.$$$reportNull$$$0(2);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        ElementToWorkOn.processElementToWorkOn((Editor)editor, (PsiFile)file, (String)IntroduceFieldHandler.getRefactoringNameText(), (String)"refactoring.introduceField", (Project)project, this.getElementProcessor(project, editor));
    }

    @Override
    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(Project project, Editor editor, PsiClass parentClass, PsiExpression expr, PsiType type, PsiExpression[] occurrences, PsiElement anchorElement2, PsiElement anchorElementIfAll) {
        boolean allowInitInMethodIfAll;
        AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
        ElementToWorkOn elementToWorkOn = ElementToWorkOn.adjustElements((PsiExpression)expr, (PsiElement)anchorElement2);
        PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
        expr = elementToWorkOn.getExpression();
        String enteredName = null;
        boolean replaceAll = false;
        if (activeIntroducer != null) {
            activeIntroducer.stopIntroduce(editor);
            expr = (PsiExpression)activeIntroducer.getExpr();
            localVariable = (PsiLocalVariable)activeIntroducer.getLocalVariable();
            occurrences = (PsiExpression[])activeIntroducer.getOccurrences();
            enteredName = activeIntroducer.getInputName();
            replaceAll = activeIntroducer.isReplaceAllOccurrences();
            type = ((AbstractJavaInplaceIntroducer)activeIntroducer).getType();
            IntroduceFieldDialog.ourLastInitializerPlace = ((InplaceIntroduceFieldPopup)activeIntroducer).getInitializerPlace();
        }
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(expr != null ? expr : anchorElement2), PsiMethod.class);
        PsiModifierListOwner staticParentElement = PsiUtil.getEnclosingStaticElement((PsiElement)IntroduceFieldHandler.getElement(expr, anchorElement2), (PsiClass)parentClass);
        boolean declareStatic = staticParentElement != null || parentClass != null && parentClass.isRecord();
        boolean isInSuperOrThis = false;
        if (!declareStatic) {
            for (int i = 0; !declareStatic && i < occurrences.length; ++i) {
                declareStatic = isInSuperOrThis = IntroduceFieldHandler.isInSuperOrThis(occurrences[i]);
            }
        }
        if (isInSuperOrThis && PsiUtil.isAvailable((JavaFeature)JavaFeature.STATIC_INTERFACE_CALLS, (PsiElement)(expr != null ? expr : anchorElement2))) {
            isInSuperOrThis = false;
        }
        int occurrencesNumber = occurrences.length;
        boolean currentMethodConstructor = containingMethod != null && containingMethod.isConstructor();
        boolean allowInitInMethod = !(currentMethodConstructor && isInSuperOrThis || !(anchorElement2 instanceof PsiLocalVariable) && !(anchorElement2 instanceof PsiStatement));
        boolean bl = allowInitInMethodIfAll = (!currentMethodConstructor || !isInSuperOrThis) && anchorElementIfAll instanceof PsiStatement;
        if (editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (expr == null || expr.isPhysical()) && activeIntroducer == null) {
            this.myInplaceIntroduceFieldPopup = new InplaceIntroduceFieldPopup(localVariable, parentClass, declareStatic, currentMethodConstructor, occurrences, expr, new TypeSelectorManagerImpl(project, type, containingMethod, expr, occurrences), editor, allowInitInMethod, allowInitInMethodIfAll, anchorElement2, anchorElementIfAll, project);
            if (this.myInplaceIntroduceFieldPopup.startInplaceIntroduceTemplate()) {
                return null;
            }
        }
        IntroduceFieldDialog dialog = new IntroduceFieldDialog(project, parentClass, expr, localVariable, currentMethodConstructor, localVariable != null, declareStatic, occurrences, allowInitInMethod, allowInitInMethodIfAll, (TypeSelectorManager)new TypeSelectorManagerImpl(project, type, containingMethod, expr, occurrences), enteredName);
        dialog.setReplaceAllOccurrences(replaceAll);
        if (!dialog.showAndGet()) {
            if (occurrencesNumber > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return null;
        }
        if (!dialog.isDeleteVariable()) {
            localVariable = null;
        }
        return new BaseExpressionToFieldHandler.Settings(dialog.getEnteredName(), expr, occurrences, dialog.isReplaceAllOccurrences(), declareStatic, dialog.isDeclareFinal(), dialog.getInitializerPlace(), dialog.getFieldVisibility(), localVariable, dialog.getFieldType(), localVariable != null, (BaseExpressionToFieldHandler.TargetDestination)null, false, false);
    }

    @Override
    protected boolean accept(ElementToWorkOn elementToWorkOn) {
        return true;
    }

    private static PsiElement getElement(PsiExpression expr, PsiElement anchorElement2) {
        PsiElement element = null;
        if (expr != null && (element = (PsiElement)expr.getUserData(ElementToWorkOn.PARENT)) == null) {
            element = expr;
        }
        if (element == null) {
            element = anchorElement2;
        }
        return element;
    }

    public AbstractInplaceIntroducer getInplaceIntroducer() {
        return this.myInplaceIntroduceFieldPopup;
    }

    static boolean isInSuperOrThis(PsiExpression occurrence) {
        return !NotInConstructorCallFilter.INSTANCE.isOK(occurrence);
    }

    @Override
    protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
        NotInConstructorCallFilter occurrenceFilter = IntroduceFieldHandler.isInSuperOrThis(selectedExpr) ? null : NotInConstructorCallFilter.INSTANCE;
        return new ExpressionOccurrenceManager(selectedExpr, (PsiElement)parentClass, occurrenceFilter, true);
    }

    @Override
    protected boolean invokeImpl(final Project project, PsiLocalVariable localVariable, final Editor editor) {
        PsiElement parent = localVariable.getParent();
        if (!(parent instanceof PsiDeclarationStatement)) {
            IntroduceFieldHandler.showErrorMessage(project, editor, JavaRefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name", (Object[])new Object[0]));
            return false;
        }
        LocalToFieldHandler localToFieldHandler = new LocalToFieldHandler(project, false){

            @Override
            protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass aClass, PsiLocalVariable local, PsiExpression[] occurrences, boolean isStatic) {
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)local, PsiStatement.class);
                PsiType type = PsiTypesUtil.removeExternalAnnotations((PsiType)local.getType());
                return IntroduceFieldHandler.this.showRefactoringDialog(project, editor, aClass, local.getInitializer(), type, occurrences, (PsiElement)local, (PsiElement)statement);
            }

            @Override
            protected int getChosenClassIndex(List<PsiClass> classes) {
                return IntroduceFieldHandler.this.getChosenClassIndex(classes);
            }
        };
        return localToFieldHandler.convertLocalToField(localVariable, editor);
    }

    protected int getChosenClassIndex(List<PsiClass> classes) {
        return classes.size() - 1;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringNameText() {
        return RefactoringBundle.message((String)"introduce.field.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceField/IntroduceFieldHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canIntroduceField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

