/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class IntroduceVariableTargetBlockChooser {
    private static final Logger LOG = Logger.getInstance(IntroduceVariableTargetBlockChooser.class);

    IntroduceVariableTargetBlockChooser() {
    }

    static void chooseTargetAndPerform(Editor editor, PsiElement anchor, PsiExpression expr, Consumer<? super PsiElement> callback) {
        List<PsiElement> containers = IntroduceVariableTargetBlockChooser.getContainers(anchor, expr);
        if (containers.size() == 1) {
            callback.accept((PsiElement)anchor);
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, containers, (Pass)Pass.create(callback), element -> {
                PsiElement container = IntroduceVariableTargetBlockChooser.takeNextContainer(containers, element);
                if (container instanceof PsiLambdaExpression) {
                    PsiType type = ((PsiLambdaExpression)container).getFunctionalInterfaceType();
                    return (String)(type != null ? type.getPresentableText() + ": " : "") + PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)container));
                }
                return JavaBundle.message((String)"target.code.block.presentable.text", (Object[])new Object[0]);
            }, (String)JavaBundle.message((String)"popup.title.select.target.code.block", (Object[])new Object[0]), element -> {
                PsiElement result = IntroduceVariableTargetBlockChooser.takeNextContainer(containers, element);
                return result instanceof PsiLambdaExpression ? Objects.requireNonNull(((PsiLambdaExpression)result).getBody()).getTextRange() : result.getTextRange();
            });
        }
    }

    @NotNull
    private static PsiElement takeNextContainer(List<? extends PsiElement> containers, PsiElement element) {
        int i = containers.indexOf(element) + 1;
        if (i < containers.size()) {
            PsiElement psiElement = containers.get(i);
            if (psiElement == null) {
                IntroduceVariableTargetBlockChooser.$$$reportNull$$$0(0);
            }
            return psiElement;
        }
        PsiElement lastItem = (PsiElement)ContainerUtil.getLastItem(containers);
        LOG.assertTrue(lastItem instanceof PsiLambdaExpression);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)lastItem, (Class[])new Class[]{PsiStatement.class, PsiField.class, PsiLambdaExpression.class});
        if (parent instanceof PsiLambdaExpression) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                IntroduceVariableTargetBlockChooser.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        PsiElement psiElement = parent != null ? parent.getParent() : lastItem.getParent();
        if (psiElement == null) {
            IntroduceVariableTargetBlockChooser.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    static List<PsiElement> getContainers(PsiElement anchor, PsiExpression expr) {
        ArrayList<PsiElement> containers = new ArrayList<PsiElement>();
        containers.add(anchor);
        PsiLambdaExpression container = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class});
        if (container == null) {
            return containers;
        }
        Set dependencies = PsiTreeUtil.collectElementsOfType((PsiElement)expr, (Class[])new Class[]{PsiReferenceExpression.class}).stream().map(ref -> ref.resolve()).filter(PsiParameter.class::isInstance).collect(Collectors.toSet());
        while (container != null && !ContainerUtil.intersects(dependencies, Arrays.asList(container.getParameterList().getParameters()))) {
            containers.add((PsiElement)container);
            container = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)container, PsiLambdaExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class});
        }
        return containers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceVariable/IntroduceVariableTargetBlockChooser", "takeNextContainer"));
    }
}

