/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.SelfUsageInfo;
import com.intellij.refactoring.util.VariableData;
import com.intellij.util.CommonJavaRefactoringUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MakeStaticUtil {
    public static InternalUsageInfo[] findClassRefsInMember(PsiTypeParameterListOwner member, boolean includeSelf) {
        PsiClass containingClass = member.getContainingClass();
        ArrayList classRefs = new ArrayList();
        PsiTreeUtil.processElements((PsiElement)member, e -> {
            MakeStaticUtil.addClassRefs(member, classRefs, containingClass, e, includeSelf);
            return true;
        });
        return classRefs.toArray(new InternalUsageInfo[0]);
    }

    public static boolean isParameterNeeded(PsiTypeParameterListOwner member) {
        return MakeStaticUtil.findClassRefsInMember(member, false).length > 0;
    }

    private static void addClassRefs(PsiTypeParameterListOwner originalMember, ArrayList<? super InternalUsageInfo> classRefs, PsiClass containingClass, PsiElement element, boolean includeSelf) {
        PsiClass hisClass;
        PsiElement refElement;
        PsiJavaCodeReferenceElement classReference;
        if (element instanceof PsiReferenceExpression) {
            PsiMember member;
            PsiElement psiElement;
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            if (!ref.isQualified() && (psiElement = ref.resolve()) instanceof PsiMember && !(member = (PsiMember)psiElement).hasModifierProperty("static")) {
                if (originalMember.getManager().areElementsEquivalent((PsiElement)member, (PsiElement)originalMember)) {
                    if (includeSelf) {
                        classRefs.add(new SelfUsageInfo(element, (PsiElement)originalMember));
                    }
                } else {
                    PsiClass memberContainingClass = MakeStaticUtil.findContainingClass(ref, member);
                    if (!(originalMember instanceof PsiClass && MakeStaticUtil.isPartOf(memberContainingClass, (PsiClass)originalMember) || !MakeStaticUtil.isPartOf(memberContainingClass, containingClass))) {
                        classRefs.add(new InternalUsageInfo(element, (PsiElement)member));
                    }
                }
            }
        } else if (element instanceof PsiThisExpression && !(element.getParent() instanceof PsiReceiverParameter)) {
            PsiElement refElement2;
            PsiJavaCodeReferenceElement qualifier = ((PsiThisExpression)element).getQualifier();
            PsiElement psiElement = refElement2 = qualifier != null ? qualifier.resolve() : PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (refElement2 instanceof PsiClass && !refElement2.equals((Object)originalMember) && MakeStaticUtil.isPartOf((PsiClass)refElement2, containingClass)) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).isReferenceTo((PsiElement)originalMember)) {
                    if (includeSelf) {
                        classRefs.add(new SelfUsageInfo(parent, (PsiElement)originalMember));
                    }
                } else {
                    classRefs.add(new InternalUsageInfo(element, refElement2));
                }
            }
        } else if (element instanceof PsiSuperExpression) {
            PsiElement refElement3;
            PsiJavaCodeReferenceElement qualifier = ((PsiSuperExpression)element).getQualifier();
            PsiElement psiElement = refElement3 = qualifier != null ? qualifier.resolve() : PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (refElement3 instanceof PsiClass && MakeStaticUtil.isPartOf((PsiClass)refElement3, containingClass) && (!(originalMember instanceof PsiClass) || !MakeStaticUtil.isPartOf((PsiClass)refElement3, (PsiClass)originalMember))) {
                classRefs.add(new InternalUsageInfo(element, refElement3));
            }
        } else if (element instanceof PsiNewExpression && (classReference = ((PsiNewExpression)element).getClassReference()) != null && (refElement = classReference.resolve()) instanceof PsiClass && (hisClass = ((PsiClass)refElement).getContainingClass()) != originalMember && MakeStaticUtil.isPartOf(hisClass, containingClass) && !((PsiClass)refElement).hasModifierProperty("static")) {
            classRefs.add(new InternalUsageInfo(element, refElement));
        }
    }

    @Nullable
    private static PsiClass findContainingClass(@NotNull PsiReferenceExpression ref, @NotNull PsiMember member) {
        if (ref == null) {
            MakeStaticUtil.$$$reportNull$$$0(0);
        }
        if (member == null) {
            MakeStaticUtil.$$$reportNull$$$0(1);
        }
        PsiClass memberClass = member.getContainingClass();
        PsiClass containingClass = PsiUtil.getContainingClass((PsiElement)ref);
        while (containingClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
            if (!member.hasModifierProperty("static") && containingClass.hasModifierProperty("static")) {
                return null;
            }
            containingClass = PsiUtil.getContainingClass((PsiElement)containingClass);
        }
        return containingClass;
    }

    private static boolean isPartOf(PsiClass elementClass, PsiClass containingClass) {
        while (elementClass != null) {
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)elementClass, (boolean)true)) {
                return true;
            }
            if (elementClass.hasModifierProperty("static")) {
                return false;
            }
            elementClass = elementClass.getContainingClass();
        }
        return false;
    }

    public static boolean buildVariableData(PsiTypeParameterListOwner member, ArrayList<? super VariableData> result) {
        InternalUsageInfo[] classRefsInMethod = MakeStaticUtil.findClassRefsInMember(member, false);
        return MakeStaticUtil.collectVariableData((PsiMember)member, classRefsInMethod, result);
    }

    public static boolean collectVariableData(PsiMember member, InternalUsageInfo[] internalUsages, ArrayList<? super VariableData> variableDatum) {
        HashSet<PsiField> reported = new HashSet<PsiField>();
        HashSet<PsiField> accessedForWriting = new HashSet<PsiField>();
        boolean needClassParameter = false;
        for (InternalUsageInfo usage : internalUsages) {
            PsiElement referencedElement = usage.getReferencedElement();
            if (usage.isWriting()) {
                accessedForWriting.add((PsiField)referencedElement);
                needClassParameter = true;
                continue;
            }
            if (referencedElement instanceof PsiField) {
                PsiField field = (PsiField)referencedElement;
                reported.add(field);
                continue;
            }
            needClassParameter = true;
        }
        ArrayList<PsiField> psiFields = new ArrayList<PsiField>(reported);
        psiFields.sort(Comparator.comparing(PsiField::getName));
        for (PsiField field : psiFields) {
            if (accessedForWriting.contains(field)) continue;
            VariableData data = new VariableData((PsiVariable)field);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)member.getProject());
            String name = field.getName();
            name = codeStyleManager.variableNameToPropertyName(name, VariableKind.FIELD);
            name = codeStyleManager.propertyNameToVariableName(name, VariableKind.PARAMETER);
            data.name = name = CommonJavaRefactoringUtil.suggestUniqueVariableName((String)name, (PsiElement)member, (PsiField)field);
            data.passAsParameter = true;
            variableDatum.add((VariableData)data);
        }
        return needClassParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ref";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "member";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/makeStatic/MakeStaticUtil";
        objectArray[2] = "findContainingClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

