/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.migration.EditMigrationDialog;
import com.intellij.refactoring.migration.MigrationDialog;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapSet;
import com.intellij.refactoring.migration.MigrationProcessor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrationManager {
    private final Project myProject;
    private final MigrationMapSet myMigrationMapSet = new MigrationMapSet();
    private static final Logger LOG = Logger.getInstance(MigrationManager.class);

    public MigrationManager(Project project) {
        this.myProject = project;
    }

    public void showMigrationDialog(MigrationMap map) {
        MigrationDialog migrationDialog = new MigrationDialog(this.myProject, map, this.myMigrationMapSet);
        if (!migrationDialog.showAndGet()) {
            return;
        }
        GlobalSearchScope migrationScope = migrationDialog.getMigrationScope();
        new MigrationProcessor(this.myProject, map, migrationScope).run();
    }

    public void createNewMigration() {
        MigrationMap newMap = new MigrationMap();
        EditMigrationDialog editMigrationDialog = new EditMigrationDialog(this.myProject, newMap, this.myMigrationMapSet, "");
        if (!editMigrationDialog.showAndGet()) {
            return;
        }
        MigrationManager.updateMapFromDialog(newMap, editMigrationDialog);
        this.myMigrationMapSet.addMap(newMap);
        try {
            this.myMigrationMapSet.saveMaps();
        }
        catch (IOException e) {
            LOG.error("Couldn't save migration maps.", (Throwable)e);
        }
    }

    public static void updateMapFromDialog(MigrationMap map, EditMigrationDialog dialog) {
        map.setName(dialog.getName());
        map.setDescription(dialog.getDescription());
        map.setFileName(FileUtil.sanitizeFileName((String)map.getName()));
    }

    @Nullable
    public MigrationMap findMigrationMap(@NotNull String name) {
        if (name == null) {
            MigrationManager.$$$reportNull$$$0(0);
        }
        return this.myMigrationMapSet.findMigrationMap(name);
    }

    public MigrationMapSet getMigrationsMap() {
        return this.myMigrationMapSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/refactoring/migration/MigrationManager", "findMigrationMap"));
    }
}

