/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.PredefinedMigrationProvider;
import com.intellij.util.text.UniqueNameGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MigrationMapSet {
    private static final Logger LOG = Logger.getInstance(MigrationMapSet.class);
    private ArrayList<MigrationMap> myMaps;
    @NonNls
    private static final String MIGRATION_MAP = "migrationMap";
    @NonNls
    private static final String ENTRY = "entry";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String OLD_NAME = "oldName";
    @NonNls
    private static final String NEW_NAME = "newName";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String ORDER = "order";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String TYPE = "type";
    @NonNls
    private static final String PACKAGE_TYPE = "package";
    @NonNls
    private static final String CLASS_TYPE = "class";
    @NonNls
    private static final String RECURSIVE = "recursive";

    public synchronized void addMap(MigrationMap map) {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        this.myMaps.add(map);
    }

    @Nullable
    public synchronized MigrationMap findMigrationMap(@NotNull String name) {
        if (name == null) {
            MigrationMapSet.$$$reportNull$$$0(0);
        }
        if (this.myMaps == null) {
            this.loadMaps();
        }
        for (MigrationMap map : this.myMaps) {
            if (!name.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public synchronized void removeMap(MigrationMap map) {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        this.myMaps.remove(map);
    }

    public static boolean isPredefined(String name) {
        for (PredefinedMigrationProvider provider : PredefinedMigrationProvider.EP_NAME.getExtensionList()) {
            URL migrationMap = provider.getMigrationMap();
            String fileName = FileUtilRt.getNameWithoutExtension((String)new File(migrationMap.getFile()).getName());
            if (!fileName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized MigrationMap[] getMaps() {
        if (this.myMaps == null) {
            this.loadMaps();
        }
        MigrationMap[] ret = new MigrationMap[this.myMaps.size()];
        for (int i = 0; i < this.myMaps.size(); ++i) {
            ret[i] = this.myMaps.get(i);
        }
        return ret;
    }

    @Nullable
    private static File getMapDirectory() {
        Path dir = PathManager.getConfigDir().resolve("migration");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("cannot create directory: " + String.valueOf(dir), (Throwable)e);
            return null;
        }
        return dir.toFile();
    }

    private static void copyPredefinedMaps(File dir) {
        for (PredefinedMigrationProvider provider : PredefinedMigrationProvider.EP_NAME.getExtensionList()) {
            URL migrationMap = provider.getMigrationMap();
            String fileName = new File(migrationMap.getFile()).getName();
            MigrationMapSet.copyMap(dir, migrationMap, fileName);
        }
    }

    private static void copyMap(File dir, URL url, String fileName) {
        File targetFile = new File(dir, fileName);
        if (targetFile.isFile()) {
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(targetFile);
             InputStream inputStream = url.openStream();){
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static File[] getMapFiles(File dir) {
        if (dir == null) {
            return new File[0];
        }
        File[] ret = dir.listFiles(FileFilters.filesWithExtension((String)"xml"));
        if (ret == null) {
            LOG.error("cannot read directory: " + dir.getAbsolutePath());
            return new File[0];
        }
        return ret;
    }

    private synchronized void loadMaps() {
        File[] files;
        this.myMaps = new ArrayList();
        File dir = MigrationMapSet.getMapDirectory();
        MigrationMapSet.copyPredefinedMaps(dir);
        for (File file : files = MigrationMapSet.getMapFiles(dir)) {
            try {
                MigrationMap map = MigrationMapSet.readMap(file);
                if (map == null) continue;
                map.setFileName(FileUtilRt.getNameWithoutExtension((String)file.getName()));
                this.myMaps.add(map);
            }
            catch (InvalidDataException | JDOMException e) {
                LOG.error("Invalid data in file: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        this.myMaps.sort((o1, o2) -> Integer.compare(o2.getOrder(), o1.getOrder()));
    }

    private static MigrationMap readMap(File file) throws JDOMException, InvalidDataException, IOException {
        if (!file.exists()) {
            return null;
        }
        Element root = JDOMUtil.load((File)file);
        if (!MIGRATION_MAP.equals(root.getName())) {
            throw new InvalidDataException();
        }
        String fileName = file.getName();
        MigrationMap map = new MigrationMap();
        for (Element node : root.getChildren()) {
            String orderValue;
            if (NAME.equals(node.getName())) {
                @NlsSafe String name = node.getAttributeValue(VALUE);
                map.setName(name);
                for (PredefinedMigrationProvider provider : PredefinedMigrationProvider.EP_NAME.getExtensionList()) {
                    if (!new File(provider.getMigrationMap().getFile()).getName().equals(fileName)) continue;
                    map.setDescription(provider.getDescription());
                    break;
                }
            }
            if (map.getDescription() == null && DESCRIPTION.equals(node.getName())) {
                @NlsSafe String description = node.getAttributeValue(VALUE);
                map.setDescription(description);
            }
            if (ORDER.equals(node.getName()) && (orderValue = node.getAttributeValue(VALUE)) != null && !orderValue.isBlank()) {
                map.setOrder(Integer.parseInt(orderValue));
            }
            if (!ENTRY.equals(node.getName())) continue;
            MigrationMapEntry entry = new MigrationMapEntry();
            String oldName = node.getAttributeValue(OLD_NAME);
            if (oldName == null) {
                throw new InvalidDataException();
            }
            entry.setOldName(oldName);
            String newName = node.getAttributeValue(NEW_NAME);
            if (newName == null) {
                throw new InvalidDataException();
            }
            entry.setNewName(newName);
            String typeStr = node.getAttributeValue(TYPE);
            if (typeStr == null) {
                throw new InvalidDataException();
            }
            entry.setType(1);
            if (typeStr.equals(PACKAGE_TYPE)) {
                entry.setType(0);
                @NonNls String isRecursiveStr = node.getAttributeValue(RECURSIVE);
                if (isRecursiveStr != null && isRecursiveStr.equals("true")) {
                    entry.setRecursive(true);
                } else {
                    entry.setRecursive(false);
                }
            }
            map.addEntry(entry);
        }
        return map;
    }

    public synchronized void saveMaps() throws IOException {
        File dir = MigrationMapSet.getMapDirectory();
        if (dir == null) {
            return;
        }
        File[] files = MigrationMapSet.getMapFiles(dir);
        @NonNls String[] filePaths = new String[this.myMaps.size()];
        Document[] documents = new Document[this.myMaps.size()];
        UniqueNameGenerator namesProvider = new UniqueNameGenerator();
        for (int i = 0; i < this.myMaps.size(); ++i) {
            MigrationMap map = this.myMaps.get(i);
            filePaths[i] = String.valueOf(dir) + File.separator + namesProvider.generateUniqueName(map.getFileName()) + ".xml";
            documents[i] = MigrationMapSet.saveMap(map);
        }
        JDOMUtil.updateFileSet((File[])files, (String[])filePaths, (Document[])documents, (String)CodeStyle.getDefaultSettings().getLineSeparator());
    }

    private static Document saveMap(MigrationMap map) {
        Element root = new Element(MIGRATION_MAP);
        Element nameElement = new Element(NAME);
        nameElement.setAttribute(VALUE, map.getName());
        root.addContent(nameElement);
        Element orderElement = new Element(ORDER);
        orderElement.setAttribute(VALUE, String.valueOf(map.getOrder()));
        root.addContent(orderElement);
        Element descriptionElement = new Element(DESCRIPTION);
        descriptionElement.setAttribute(VALUE, map.getDescription());
        root.addContent(descriptionElement);
        for (int i = 0; i < map.getEntryCount(); ++i) {
            MigrationMapEntry entry = map.getEntryAt(i);
            Element element = new Element(ENTRY);
            element.setAttribute(OLD_NAME, entry.getOldName());
            element.setAttribute(NEW_NAME, entry.getNewName());
            if (entry.getType() == 0) {
                element.setAttribute(TYPE, PACKAGE_TYPE);
                element.setAttribute(RECURSIVE, Boolean.valueOf(entry.isRecursive()).toString());
            } else {
                element.setAttribute(TYPE, CLASS_TYPE);
            }
            root.addContent(element);
        }
        return new Document(root);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/refactoring/migration/MigrationMapSet", "findMigrationMap"));
    }
}

