/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.MigrationUsagesViewDescriptor;
import com.intellij.refactoring.migration.MigrationUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.generate.UastCodeGenerationPluginKt;

public class MigrationProcessor
extends BaseRefactoringProcessor {
    private final MigrationMap myMigrationMap;
    private PsiMigration myPsiMigration;
    private final GlobalSearchScope mySearchScope;
    private ArrayList<SmartPsiElementPointer<PsiElement>> myRefsToShorten;

    public MigrationProcessor(Project project, MigrationMap migrationMap) {
        this(project, migrationMap, GlobalSearchScope.projectScope((Project)project));
    }

    public MigrationProcessor(Project project, MigrationMap migrationMap, GlobalSearchScope scope) {
        super(project);
        this.myMigrationMap = migrationMap;
        this.mySearchScope = scope;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MigrationProcessor.$$$reportNull$$$0(0);
        }
        return new MigrationUsagesViewDescriptor(this.myMigrationMap, false);
    }

    private PsiMigration startMigration(Project project) {
        PsiMigration migration = PsiMigrationManager.getInstance((Project)project).startMigration();
        this.findOrCreateEntries(project, migration);
        return migration;
    }

    private void findOrCreateEntries(Project project, PsiMigration migration) {
        for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
            MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
            if (entry.getType() == 0) {
                MigrationUtil.findOrCreatePackage(project, migration, entry.getOldName());
                continue;
            }
            MigrationUtil.findOrCreateClass(project, migration, entry.getOldName());
        }
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MigrationProcessor.$$$reportNull$$$0(1);
        }
        this.myPsiMigration = this.startMigration(this.myProject);
    }

    protected void doRun() {
        this.myPsiMigration = this.startMigration(this.myProject);
        super.doRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<MigrationUsageInfo> usagesVector = new ArrayList<MigrationUsageInfo>();
        try {
            if (this.myMigrationMap == null) {
                UsageInfo[] usageInfoArray = UsageInfo.EMPTY_ARRAY;
                if (usageInfoArray == null) {
                    MigrationProcessor.$$$reportNull$$$0(2);
                }
                return usageInfoArray;
            }
            for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
                UsageInfo[] usages = entry.getType() == 0 ? MigrationUtil.findPackageUsages(this.myProject, this.myPsiMigration, entry.getOldName(), this.mySearchScope) : MigrationUtil.findClassUsages(this.myProject, this.myPsiMigration, entry.getOldName(), this.mySearchScope);
                for (UsageInfo usage : usages) {
                    usagesVector.add(new MigrationUsageInfo(usage, entry));
                }
            }
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(this::finishFindMigration), this.myProject.getDisposed());
        }
        UsageInfo[] usageInfoArray = usagesVector.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MigrationProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    private void finishFindMigration() {
        if (this.myPsiMigration != null) {
            this.myPsiMigration.finish();
            this.myPsiMigration = null;
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MigrationProcessor.$$$reportNull$$$0(4);
        }
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"migration.no.usages.found.in.the.project", (Object[])new Object[0]), (String)MigrationProcessor.getRefactoringName());
            return false;
        }
        this.setPreviewUsages(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MigrationProcessor.$$$reportNull$$$0(5);
        }
        this.finishFindMigration();
        PsiMigration psiMigration = PsiMigrationManager.getInstance((Project)this.myProject).startMigration();
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        this.myRefsToShorten = new ArrayList();
        try {
            boolean sameShortNames = false;
            for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
                String newName = entry.getNewName();
                PsiPackage element = entry.getType() == 0 ? MigrationUtil.findOrCreatePackage(this.myProject, psiMigration, newName) : MigrationUtil.findOrCreateClass(this.myProject, psiMigration, newName)[0];
                MigrationUtil.doMigration((PsiElement)element, newName, usages, this.myRefsToShorten);
                if (sameShortNames || !Comparing.strEqual((String)StringUtil.getShortName((String)entry.getOldName()), (String)StringUtil.getShortName((String)entry.getNewName()))) continue;
                sameShortNames = true;
            }
            if (!sameShortNames) {
                this.myRefsToShorten.clear();
            }
        }
        finally {
            a.finish();
            psiMigration.finish();
        }
    }

    protected void performPsiSpoilingRefactoring() {
        for (SmartPsiElementPointer<PsiElement> pointer : this.myRefsToShorten) {
            UElement uElement;
            PsiElement element = pointer.getElement();
            if (element == null || !((uElement = UastContextKt.toUElement((PsiElement)element)) instanceof UReferenceExpression)) continue;
            UastCodeGenerationPluginKt.shortenReference((UReferenceExpression)((UReferenceExpression)uElement));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = MigrationProcessor.getRefactoringName();
        if (string == null) {
            MigrationProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"migration.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/migration/MigrationProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/migration/MigrationProcessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }

    protected static class MigrationUsageInfo
    extends UsageInfo {
        public MigrationMapEntry mapEntry;

        MigrationUsageInfo(UsageInfo info, MigrationMapEntry mapEntry) {
            super(info.getElement(), info.getRangeInElement().getStartOffset(), info.getRangeInElement().getEndOffset());
            this.mapEntry = mapEntry;
        }
    }
}

