/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.CommonBundle;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesToNewDirectoryDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMoveClassesOrPackagesHandler
extends MoveHandlerDelegate {
    public static boolean isPackageOrDirectory(PsiElement element) {
        if (element instanceof PsiPackage) {
            return true;
        }
        return element instanceof PsiDirectory && JavaDirectoryService.getInstance().getPackageInSources((PsiDirectory)element) != null;
    }

    public static boolean isReferenceInAnonymousClass(@Nullable PsiReference reference) {
        return reference instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiAnonymousClass;
    }

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        for (PsiElement element : elements) {
            if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(element) || !JavaMoveClassesOrPackagesHandler.invalid4Move(element)) continue;
            return false;
        }
        if (JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            return false;
        }
        return targetContainer == null || super.canMove(elements, targetContainer, reference);
    }

    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            JavaMoveClassesOrPackagesHandler.$$$reportNull$$$0(0);
        }
        int classCount = 0;
        int directoryCount = 0;
        for (PsiElement element : elements) {
            if (element instanceof PsiClass) {
                ++classCount;
                continue;
            }
            if (!(element instanceof PsiDirectory) && !(element instanceof PsiPackage)) continue;
            ++directoryCount;
        }
        if (directoryCount == 0) {
            return classCount == 1 ? JavaRefactoringBundle.message((String)"move.class", (Object[])new Object[0]) : JavaRefactoringBundle.message((String)"move.classes", (Object[])new Object[0]);
        }
        if (classCount == 0) {
            return directoryCount == 1 ? JavaRefactoringBundle.message((String)"move.package.or.directory", (Object[])new Object[0]) : JavaRefactoringBundle.message((String)"move.packages.or.directories", (Object[])new Object[0]);
        }
        return JavaRefactoringBundle.message((String)"move.classes.and.packages", (Object[])new Object[0]);
    }

    public static boolean invalid4Move(PsiElement element) {
        PsiFile parentFile;
        if (element instanceof PsiClassOwner) {
            PsiClass[] classes = ((PsiClassOwner)element).getClasses();
            if (classes.length == 0 && !PackageUtil.isPackageInfoFile((PsiElement)element)) {
                return true;
            }
            for (PsiClass aClass : classes) {
                if (!(aClass instanceof PsiSyntheticClass)) continue;
                return true;
            }
            parentFile = (PsiFile)element;
        } else {
            if (element instanceof PsiSyntheticClass) {
                return true;
            }
            if (!(element instanceof PsiClass)) {
                return true;
            }
            if (element instanceof PsiAnonymousClass) {
                return true;
            }
            if (((PsiClass)element).getContainingClass() != null) {
                return true;
            }
            parentFile = element.getContainingFile();
        }
        return parentFile instanceof PsiJavaFile && JavaProjectRootsUtil.isOutsideJavaSourceRoot((PsiFile)parentFile);
    }

    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(psiElement)) {
            return true;
        }
        boolean areAllClasses = true;
        for (PsiElement source : sources) {
            areAllClasses &= !JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(source) && !JavaMoveClassesOrPackagesHandler.invalid4Move(source);
        }
        return areAllClasses && psiElement instanceof PsiClass;
    }

    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        return MoveClassesOrPackagesImpl.adjustForMove(project, sourceElements, targetElement);
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        if (JavaMoveClassesOrPackagesHandler.canMoveOrRearrangePackages(elements)) {
            PsiDirectory[] directories = new PsiDirectory[elements.length];
            System.arraycopy(elements, 0, directories, 0, directories.length);
            if (directories.length > 1 || targetContainer != null) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project, targetContainer, callback, directories);
                return;
            }
            int ret = Messages.showYesNoCancelDialog((Project)project, (String)JavaBundle.message((String)"where.do.you.want.to.move.directory.prompt", (Object[])new Object[]{"../" + SymbolPresentationUtil.getFilePathPresentation((PsiFileSystemItem)directories[0])}), (String)JavaBundle.message((String)"dialog.title.move.directory", (Object[])new Object[0]), (String)JavaBundle.message((String)"button.to.another.directory", (Object[])new Object[0]), (String)JavaBundle.message((String)"button.to.another.source.root", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (ret == 0) {
                JavaMoveClassesOrPackagesHandler.moveAsDirectory(project, null, callback, directories);
            } else if (ret == 1) {
                MoveClassesOrPackagesImpl.doRearrangePackage(project, directories);
            }
            return;
        }
        this.moveAsPackage(project, elements, targetContainer, callback);
    }

    private void moveAsPackage(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        PsiElement[] adjustedElements = MoveClassesOrPackagesImpl.adjustForMove(project, elements, targetContainer);
        if (adjustedElements == null) {
            return;
        }
        if (targetContainer instanceof PsiDirectory && CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(adjustedElements), (boolean)true) && !JavaMoveClassesOrPackagesHandler.packageHasMultipleDirectoriesInModule(project, (PsiDirectory)targetContainer)) {
            DialogWrapper dialogue = this.createMoveClassesOrPackagesToNewDirectoryDialog((PsiDirectory)targetContainer, adjustedElements, callback);
            if (Boolean.getBoolean("ide.performance.skip.refactoring.dialogs")) {
                dialogue.performOKAction();
            } else {
                dialogue.show();
            }
            return;
        }
        this.doMoveWithMoveClassesDialog(project, adjustedElements, targetContainer, callback);
    }

    protected void doMoveWithMoveClassesDialog(Project project, PsiElement[] adjustedElements, PsiElement initialTargetElement, MoveCallback moveCallback) {
        MoveClassesOrPackagesImpl.doMove(project, adjustedElements, initialTargetElement, moveCallback);
    }

    @NotNull
    protected DialogWrapper createMoveClassesOrPackagesToNewDirectoryDialog(@NotNull PsiDirectory directory, PsiElement[] elementsToMove, MoveCallback moveCallback) {
        if (directory == null) {
            JavaMoveClassesOrPackagesHandler.$$$reportNull$$$0(1);
        }
        return new MoveClassesOrPackagesToNewDirectoryDialog(directory, elementsToMove, moveCallback);
    }

    private static void moveAsDirectory(Project project, PsiElement targetContainer, final MoveCallback callback, final PsiDirectory[] directories) {
        if (targetContainer instanceof PsiDirectory) {
            final String propertyName = "Drag.Drop.Confirmation";
            final PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            if (propertiesComponent.getBoolean(propertyName, true) && !((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)JavaRefactoringBundle.message((String)"dialog.title.confirm.move", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"dialog.message.moving.directories.to", (Object[])new Object[]{((PsiDirectory)targetContainer).getName()})).yesText(RefactoringBundle.message((String)"refactor.button"))).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(){

                public void rememberChoice(boolean isSelected, int exitCode) {
                    propertiesComponent.setValue(propertyName, !isSelected, true);
                }
            })).ask(project)) {
                return;
            }
            JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
            MoveDirectoryWithClassesProcessor processor = new MoveDirectoryWithClassesProcessor(project, directories, (PsiDirectory)targetContainer, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, true, callback);
            processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
            processor.run();
        } else {
            boolean containsJava = JavaMoveClassesOrPackagesHandler.hasJavaFiles(directories);
            if (!containsJava) {
                MoveFilesOrDirectoriesUtil.doMove((Project)project, (PsiElement[])directories, (PsiElement[])new PsiElement[]{targetContainer}, (MoveCallback)callback);
                return;
            }
            MoveClassesOrPackagesToNewDirectoryDialog dlg = new MoveClassesOrPackagesToNewDirectoryDialog(directories[0], (PsiElement[])directories, false, callback){

                @Override
                protected BaseRefactoringProcessor createRefactoringProcessor(Project project, final @NotNull PsiDirectory targetDirectory, @NotNull PsiPackage aPackage, boolean searchInComments, boolean searchForTextOccurences) {
                    MoveDestination destination;
                    if (targetDirectory == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (aPackage == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((destination = this.createDestination(aPackage, targetDirectory)) == null) {
                        return null;
                    }
                    try {
                        for (PsiDirectory dir : directories) {
                            MoveFilesOrDirectoriesUtil.checkIfMoveIntoSelf((PsiElement)dir, (PsiElement)((PsiElement)WriteAction.compute(() -> destination.getTargetDirectory(dir))));
                        }
                    }
                    catch (IncorrectOperationException e) {
                        Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)JavaRefactoringBundle.message((String)"cannot.move", (Object[])new Object[0]));
                        return null;
                    }
                    return new MoveDirectoryWithClassesProcessor(this, project, directories, null, searchInComments, searchForTextOccurences, true, callback){

                        @NotNull
                        public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                            PsiDirectory targetDirectory2 = destination.getTargetDirectory(dir);
                            return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(targetDirectory2);
                        }

                        protected String getTargetName() {
                            return targetDirectory.getName();
                        }
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "targetDirectory";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "aPackage";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveClassesOrPackagesHandler$2";
                    objectArray[2] = "createRefactoringProcessor";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            dlg.show();
        }
    }

    public static boolean hasJavaFiles(PsiDirectory ... directories) {
        for (PsiDirectory directory : directories) {
            boolean[] containsJava = new boolean[]{false};
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)directory.getVirtualFile(), file -> {
                if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaFileType.INSTANCE)) {
                    containsJava[0] = true;
                    return false;
                }
                return true;
            });
            if (!containsJava[0]) continue;
            return true;
        }
        return false;
    }

    public PsiElement adjustTargetForMove(DataContext dataContext, PsiElement targetContainer) {
        PsiDirectory[] directories;
        Module module;
        if (targetContainer instanceof PsiPackage && (module = (Module)LangDataKeys.TARGET_MODULE.getData(dataContext)) != null && (directories = ((PsiPackage)targetContainer).getDirectories(GlobalSearchScope.moduleScope((Module)module))).length == 1) {
            return directories[0];
        }
        return super.adjustTargetForMove(dataContext, targetContainer);
    }

    public static boolean packageHasMultipleDirectoriesInModule(Project project, PsiDirectory targetElement) {
        Module module;
        PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(targetElement);
        return psiPackage != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)targetElement.getVirtualFile(), (Project)project)) != null && psiPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module)).length > 1;
    }

    private static boolean canMoveOrRearrangePackages(PsiElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        Project project = elements[0].getProject();
        if (JavaProjectRootsUtil.getSuitableDestinationSourceRoots((Project)project).size() == 1) {
            return false;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiDirectory)) {
                return false;
            }
            PsiDirectory directory = (PsiDirectory)element;
            if (RefactoringUtil.isSourceRoot(directory)) {
                return false;
            }
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                return false;
            }
            if (aPackage.getQualifiedName().isEmpty()) {
                return false;
            }
            VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getSourceRootForFile(directory.getVirtualFile());
            if (sourceRootForFile != null) continue;
            return false;
        }
        return true;
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (JavaMoveClassesOrPackagesHandler.isPackageOrDirectory(element)) {
            return false;
        }
        if (JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            return false;
        }
        if (!JavaMoveClassesOrPackagesHandler.invalid4Move(element)) {
            PsiElement initialTargetElement = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
            PsiElement[] adjustedElements = this.adjustForMove(project, new PsiElement[]{element}, initialTargetElement);
            if (adjustedElements == null) {
                return true;
            }
            this.doMoveWithMoveClassesDialog(project, adjustedElements, initialTargetElement, null);
            return true;
        }
        return false;
    }

    public boolean isMoveRedundant(PsiElement source, PsiElement target) {
        PsiPackage aPackage;
        if (target instanceof PsiDirectory && source instanceof PsiClass) {
            try {
                JavaDirectoryServiceImpl.checkCreateClassOrInterface((PsiDirectory)((PsiDirectory)target), (String)((PsiClass)source).getName());
            }
            catch (IncorrectOperationException e) {
                return true;
            }
        }
        if (target instanceof PsiPackage && source instanceof PsiClass) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)source.getProject());
            return ((PsiPackage)target).findClassByShortName(Objects.requireNonNull(((PsiClass)source).getName()), globalSearchScope).length > 0;
        }
        if (target instanceof PsiDirectory && source instanceof PsiDirectory && (aPackage = JavaDirectoryService.getInstance().getPackage((PsiDirectory)source)) != null && !MoveClassesOrPackagesImpl.checkNesting(target.getProject(), aPackage, target, false)) {
            return true;
        }
        return super.isMoveRedundant(source, target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/JavaMoveClassesOrPackagesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createMoveClassesOrPackagesToNewDirectoryDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

