/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.psi.ArrayIterable;

public final class SearchUtils {
    private SearchUtils() {
    }

    public static Iterable<PsiReference> findAllReferences(PsiElement element, SearchScope scope) {
        return new ArrayIterable<PsiReference>((PsiReference[])ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true).toArray((Object[])PsiReference.EMPTY_ARRAY));
    }

    public static Iterable<PsiReference> findAllReferences(PsiElement element) {
        return SearchUtils.findAllReferences(element, PsiSearchHelper.getInstance((Project)element.getProject()).getUseScope(element));
    }

    public static Iterable<PsiMethod> findOverridingMethods(PsiMethod method) {
        return new ArrayIterable<PsiMethod>((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY));
    }

    public static Iterable<PsiClass> findClassInheritors(PsiClass aClass, boolean deep) {
        return new ArrayIterable<PsiClass>((PsiClass[])ClassInheritorsSearch.search((PsiClass)aClass, (boolean)deep).toArray((Object[])PsiClass.EMPTY_ARRAY));
    }
}

