/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AutomaticVariableRenamer
extends AutomaticRenamer {
    private final Set<PsiNamedElement> myToUnpluralize = new HashSet<PsiNamedElement>();

    public AutomaticVariableRenamer(PsiClass aClass, String newClassName, Collection<? extends UsageInfo> usages) {
        String oldClassName = aClass.getName();
        HashSet<PsiFile> files = new HashSet<PsiFile>();
        for (UsageInfo usageInfo : usages) {
            PsiElement element = usageInfo.getElement();
            if (!(element instanceof PsiJavaCodeReferenceElement)) continue;
            files.add(element.getContainingFile());
            PsiDeclarationStatement statement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDeclarationStatement.class);
            if (statement != null) {
                for (PsiElement declaredElement : statement.getDeclaredElements()) {
                    if (!(declaredElement instanceof PsiVariable)) continue;
                    this.checkRenameVariable(element, (PsiVariable)declaredElement, oldClassName, newClassName);
                }
                continue;
            }
            PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiVariable.class);
            if (variable == null) continue;
            this.checkRenameVariable(element, variable, oldClassName, newClassName);
            if (!(variable instanceof PsiField)) continue;
            for (PsiField field : AutomaticVariableRenamer.getFieldsInSameDeclaration((PsiField)variable)) {
                this.checkRenameVariable(element, (PsiVariable)field, oldClassName, newClassName);
            }
        }
        if (files.size() < 5 && oldClassName != null) {
            for (PsiFile psiFile : files) {
                for (PsiLambdaExpression expression : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)psiFile)).filter(PsiLambdaExpression.class)) {
                    PsiParameter[] parameters;
                    for (PsiParameter parameter : parameters = expression.getParameterList().getParameters()) {
                        String parameterName;
                        if (!aClass.equals((Object)PsiUtil.resolveClassInType((PsiType)parameter.getType())) || !StringUtil.containsIgnoreCase((String)(parameterName = parameter.getName()), (String)oldClassName)) continue;
                        this.myElements.add(parameter);
                    }
                }
            }
        }
        this.suggestAllNames(oldClassName, newClassName);
    }

    private static List<PsiField> getFieldsInSameDeclaration(PsiField variable) {
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        ASTNode node = variable.getNode();
        if (node != null) {
            ASTNode nextField;
            ASTNode comma;
            while ((comma = TreeUtil.skipElements((ASTNode)node.getTreeNext(), (TokenSet)StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = TreeUtil.skipElements((ASTNode)comma.getTreeNext(), (TokenSet)StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && nextField.getElementType() == JavaElementType.FIELD) {
                result.add((PsiField)nextField.getPsi());
                node = nextField;
            }
        }
        return result;
    }

    private void checkRenameVariable(PsiElement element, PsiVariable variable, String oldClassName, String newClassName) {
        block8: {
            PsiTypeElement[] typeParameterElements;
            PsiJavaCodeReferenceElement ref;
            block7: {
                PsiTypeElement typeElement = variable.getTypeElement();
                if (typeElement == null) {
                    return;
                }
                ref = typeElement.getInnermostComponentReferenceElement();
                if (ref == null) {
                    return;
                }
                String variableName = variable.getName();
                if (variableName == null) {
                    return;
                }
                if (variableName.equalsIgnoreCase(newClassName)) {
                    return;
                }
                if (!StringUtil.containsIgnoreCase((String)variableName, (String)oldClassName)) {
                    return;
                }
                if (!ref.equals((Object)element)) break block7;
                this.myElements.add(variable);
                if (!(variable.getType() instanceof PsiArrayType)) break block8;
                this.myToUnpluralize.add((PsiNamedElement)variable);
                break block8;
            }
            PsiClassType collectionType = JavaPsiFacade.getElementFactory((Project)variable.getProject()).createTypeByFQClassName("java.util.Collection", variable.getResolveScope());
            if (!collectionType.isAssignableFrom(variable.getType())) {
                return;
            }
            for (PsiTypeElement typeParameterElement : typeParameterElements = ref.getParameterList().getTypeParameterElements()) {
                PsiJavaCodeReferenceElement parameterRef = typeParameterElement.getInnermostComponentReferenceElement();
                if (parameterRef == null || !parameterRef.equals((Object)element)) continue;
                this.myElements.add(variable);
                this.myToUnpluralize.add((PsiNamedElement)variable);
                break;
            }
        }
    }

    public String getDialogTitle() {
        return JavaRefactoringBundle.message((String)"rename.variables.title", (Object[])new Object[0]);
    }

    public String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"title.rename.variables.with.the.following.names.to", (Object[])new Object[0]);
    }

    public String entityName() {
        return JavaRefactoringBundle.message((String)"entity.name.variable", (Object[])new Object[0]);
    }

    public String nameToCanonicalName(@NotNull String name, PsiNamedElement psiVariable) {
        if (name == null) {
            AutomaticVariableRenamer.$$$reportNull$$$0(0);
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
        String propertyName = codeStyleManager.variableNameToPropertyName(name, codeStyleManager.getVariableKind((PsiVariable)psiVariable));
        if (this.myToUnpluralize.contains(psiVariable)) {
            String singular = StringUtil.unpluralize((String)propertyName);
            if (singular != null) {
                return singular;
            }
            this.myToUnpluralize.remove(psiVariable);
        }
        return propertyName;
    }

    public String canonicalNameToName(String canonicalName, PsiNamedElement psiVariable) {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)psiVariable.getProject());
        String variableName = codeStyleManager.propertyNameToVariableName(canonicalName, codeStyleManager.getVariableKind((PsiVariable)psiVariable));
        if (this.myToUnpluralize.contains(psiVariable)) {
            return StringUtil.pluralize((String)variableName);
        }
        return variableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/refactoring/rename/naming/AutomaticVariableRenamer", "nameToCanonicalName"));
    }
}

