/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.SealedUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteExtendsClassUsageInfo
extends SafeDeleteReferenceUsageInfo {
    private static final Logger LOG = Logger.getInstance(SafeDeleteExtendsClassUsageInfo.class);
    private final PsiClass myExtendingClass;
    private final PsiSubstitutor mySubstitutor;

    public SafeDeleteExtendsClassUsageInfo(PsiJavaCodeReferenceElement reference, PsiClass refClass, PsiClass extendingClass) {
        super((PsiElement)reference, (PsiElement)refClass, true);
        this.myExtendingClass = extendingClass;
        this.mySubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)refClass, (PsiClass)this.myExtendingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        LOG.assertTrue(this.mySubstitutor != null);
    }

    public PsiClass getReferencedElement() {
        return (PsiClass)super.getReferencedElement();
    }

    public void deleteElement() throws IncorrectOperationException {
        PsiElement parent = this.getElement().getParent();
        LOG.assertTrue(parent instanceof PsiReferenceList);
        PsiClass refClass = this.getReferencedElement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)refClass.getProject());
        boolean targetTypeParameter = this.myExtendingClass instanceof PsiTypeParameter;
        this.copyExtendsList(refClass, refClass.getExtendsList(), refClass.isInterface() == this.myExtendingClass.isInterface() || targetTypeParameter, elementFactory);
        this.copyExtendsList(refClass, refClass.getImplementsList(), targetTypeParameter, elementFactory);
        this.getElement().delete();
        if (!refClass.hasModifierProperty("sealed")) {
            return;
        }
        SealedUtils.removeFromPermitsList((PsiClass)refClass, (PsiClass)this.myExtendingClass);
        PsiModifierList modifiers = this.myExtendingClass.getModifierList();
        if (modifiers == null || !modifiers.hasModifierProperty("non-sealed")) {
            return;
        }
        if (!SealedUtils.hasSealedParent((PsiClass)this.myExtendingClass)) {
            modifiers.setModifierProperty("non-sealed", false);
        }
    }

    private void copyExtendsList(@NotNull PsiClass classToRemove, @Nullable PsiReferenceList sourceExtendsList, boolean targetExtends, PsiElementFactory elementFactory) {
        if (classToRemove == null) {
            SafeDeleteExtendsClassUsageInfo.$$$reportNull$$$0(0);
        }
        if (sourceExtendsList != null) {
            PsiClassType[] referenceTypes = sourceExtendsList.getReferencedTypes();
            PsiReferenceList targetExtendsList = targetExtends ? this.myExtendingClass.getExtendsList() : this.myExtendingClass.getImplementsList();
            Object[] existingRefTypes = targetExtendsList.getReferencedTypes();
            for (PsiClassType referenceType : referenceTypes) {
                if (ArrayUtilRt.find((Object[])existingRefTypes, (Object)referenceType) > -1) continue;
                PsiClassType classType = (PsiClassType)this.mySubstitutor.substitute((PsiType)referenceType);
                PsiElement extendsRef = targetExtendsList.add((PsiElement)elementFactory.createReferenceElementByType(classType));
                PsiClass classToExtend = classType.resolve();
                if (classToExtend != null && classToExtend.hasModifierProperty("sealed")) {
                    String extendingClassName = Objects.requireNonNull(this.myExtendingClass.getQualifiedName());
                    if (classToExtend.getPermitsList() == null) {
                        if (classToExtend.getContainingFile() != this.myExtendingClass.getContainingFile()) {
                            ArrayList<String> missingInheritors = new ArrayList<String>(SealedUtils.findSameFileInheritors((PsiClass)classToExtend, (PsiClass[])new PsiClass[]{classToRemove}));
                            missingInheritors.add(extendingClassName);
                            SealedUtils.fillPermitsList((PsiClass)classToExtend, missingInheritors);
                        }
                    } else {
                        SealedUtils.fillPermitsList((PsiClass)classToExtend, Collections.singleton(extendingClassName));
                    }
                }
                CodeStyleManager.getInstance((Project)this.myExtendingClass.getProject()).reformat(extendsRef);
            }
        }
    }

    public boolean isSafeDelete() {
        if (this.getElement() == null) {
            return false;
        }
        PsiClass classToRemove = this.getReferencedElement();
        if (classToRemove.getExtendsListTypes().length > 0) {
            PsiReferenceList listToAddExtends;
            PsiReferenceList psiReferenceList = listToAddExtends = classToRemove.isInterface() == this.myExtendingClass.isInterface() ? this.myExtendingClass.getExtendsList() : this.myExtendingClass.getImplementsList();
            if (listToAddExtends == null) {
                return false;
            }
        }
        if (classToRemove.getImplementsListTypes().length > 0 && this.myExtendingClass.getImplementsList() == null) {
            return false;
        }
        PsiResolveHelper resolveHelper = PsiResolveHelper.getInstance((Project)this.getProject());
        return StreamEx.of((Object[])classToRemove.getInterfaces()).prepend((Object)classToRemove.getSuperClass()).nonNull().allMatch(grandParent -> resolveHelper.isAccessible((PsiMember)grandParent, (PsiElement)this.myExtendingClass, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classToRemove", "com/intellij/refactoring/safeDelete/usageInfo/SafeDeleteExtendsClassUsageInfo", "copyExtendsList"));
    }
}

