/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;

public class SafeDeleteFieldWriteReference
extends SafeDeleteReferenceUsageInfo {
    public SafeDeleteFieldWriteReference(PsiAssignmentExpression expr, PsiMember referencedElement) {
        super((PsiElement)expr, (PsiElement)referencedElement, SafeDeleteFieldWriteReference.safeRemoveRHS(expr));
    }

    private static boolean safeRemoveRHS(PsiAssignmentExpression expression) {
        PsiExpressionStatement statement;
        PsiExpression rExpression = expression.getRExpression();
        PsiElement parent = expression.getParent();
        return RefactoringUtil.verifySafeCopyExpression((PsiElement)rExpression) == 0 && parent instanceof PsiExpressionStatement && (statement = (PsiExpressionStatement)parent).getExpression() == expression;
    }

    public void deleteElement() {
        PsiElement element = this.getElement();
        if (element != null) {
            element.getParent().delete();
        }
    }
}

