/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import org.jetbrains.annotations.NotNull;

public final class JavaRefactoringElementDescriptionProvider
implements ElementDescriptionProvider {
    public String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        if (element == null) {
            JavaRefactoringElementDescriptionProvider.$$$reportNull$$$0(0);
        }
        if (location == null) {
            JavaRefactoringElementDescriptionProvider.$$$reportNull$$$0(1);
        }
        if (!(location instanceof RefactoringDescriptionLocation)) {
            return null;
        }
        RefactoringDescriptionLocation rdLocation = (RefactoringDescriptionLocation)location;
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            int options2 = 1;
            if (rdLocation.includeParent()) {
                options2 |= 0x1000;
            }
            String formattedVariable = PsiFormatUtil.formatVariable((PsiVariable)field, (int)options2, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            return JavaRefactoringBundle.message((String)(element instanceof PsiEnumConstant ? "enum.constant.description" : "field.description"), (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)formattedVariable)});
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            int options3 = 257;
            if (rdLocation.includeParent()) {
                options3 |= 0x1000;
            }
            String descriptiveName = CommonRefactoringUtil.htmlEmphasize((String)PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options3, (int)2));
            return method.isConstructor() ? JavaRefactoringBundle.message((String)"constructor.description", (Object[])new Object[]{descriptiveName}) : JavaRefactoringBundle.message((String)"method.description", (Object[])new Object[]{descriptiveName});
        }
        if (element instanceof PsiClassInitializer) {
            PsiClassInitializer initializer = (PsiClassInitializer)element;
            boolean isStatic = initializer.hasModifierProperty("static");
            if (!rdLocation.includeParent()) {
                return JavaRefactoringBundle.message((String)"class.initializer.description", (Object[])new Object[]{isStatic ? 0 : 1});
            }
            String description = this.getElementDescription((PsiElement)initializer.getContainingClass(), (ElementDescriptionLocation)RefactoringDescriptionLocation.WITHOUT_PARENT);
            return isStatic ? JavaRefactoringBundle.message((String)"static.initializer.description", (Object[])new Object[]{description}) : JavaRefactoringBundle.message((String)"instance.initializer.description", (Object[])new Object[]{description});
        }
        if (element instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)element;
            if (parameter.getDeclarationScope() instanceof PsiForeachStatement) {
                return JavaRefactoringBundle.message((String)"local.variable.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)parameter.getName())});
            }
            if (parameter instanceof PsiPatternVariable) {
                return JavaRefactoringBundle.message((String)"pattern.variable.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)parameter.getName())});
            }
            return JavaRefactoringBundle.message((String)"parameter.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)parameter.getName())});
        }
        if (element instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)element;
            return JavaRefactoringBundle.message((String)"local.variable.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)variable.getName())});
        }
        if (element instanceof PsiPackage) {
            PsiPackage aPackage = (PsiPackage)element;
            return JavaRefactoringBundle.message((String)"package.description", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)aPackage.getName())});
        }
        if (element instanceof PsiClass) {
            int local;
            PsiClass aClass = (PsiClass)element;
            if (aClass instanceof PsiEnumConstantInitializer) {
                String description = this.getElementDescription(aClass.getParent(), location);
                return JavaRefactoringBundle.message((String)"class.body.description", (Object[])new Object[]{description});
            }
            if (aClass instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
                String descriptiveName = CommonRefactoringUtil.htmlEmphasize((String)anonymousClass.getBaseClassReference().getText());
                return JavaRefactoringBundle.message((String)"anonymous.class.description", (Object[])new Object[]{descriptiveName});
            }
            String descriptiveName = CommonRefactoringUtil.htmlEmphasize((String)DescriptiveNameUtil.getDescriptiveName((PsiElement)aClass));
            int n = local = aClass.getParent() instanceof PsiDeclarationStatement ? 1 : 0;
            if (aClass.isInterface()) {
                return JavaRefactoringBundle.message((String)"interface.description", (Object[])new Object[]{descriptiveName, local});
            }
            if (aClass.isEnum()) {
                return JavaRefactoringBundle.message((String)"enum.description", (Object[])new Object[]{descriptiveName, local});
            }
            if (aClass.isRecord()) {
                return JavaRefactoringBundle.message((String)"record.description", (Object[])new Object[]{descriptiveName, local});
            }
            return JavaRefactoringBundle.message((String)"class.description", (Object[])new Object[]{descriptiveName, local});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "location";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/util/JavaRefactoringElementDescriptionProvider";
        objectArray[2] = "getElementDescription";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

