/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RefactoringConflictsUtilImpl
implements RefactoringConflictsUtil {
    private RefactoringConflictsUtilImpl() {
    }

    public void analyzeHierarchyConflictsAfterMethodModifierChange(@NotNull PsiMethod method, @NotNull @PsiModifier.ModifierConstant String modifier, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (method == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(0);
        }
        if (modifier == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(1);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(2);
        }
        JavaChangeSignatureUsageProcessor.ConflictSearcher.searchForHierarchyConflicts(method, conflicts, modifier);
    }

    public void analyzeAccessibilityConflictsAfterMemberMove(@NotNull PsiClass targetClass, @Nullable String newVisibility, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (targetClass == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(3);
        }
        if (membersToMove == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(4);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(5);
        }
        this.analyzeAccessibilityConflictsAfterMemberMove(membersToMove, targetClass, newVisibility, (PsiElement)targetClass, null, (Condition<? super PsiReference>)Conditions.alwaysTrue(), conflicts);
    }

    public void analyzeAccessibilityConflictsAfterMemberMove(@NotNull Set<? extends PsiMember> membersToMove, @Nullable PsiClass targetClass, @Nullable String newVisibility, @NotNull PsiElement context, @Nullable Set<? extends PsiMethod> abstractMethods, @NotNull Condition<? super PsiReference> ignorePredicate, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (membersToMove == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(6);
        }
        if (context == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(7);
        }
        if (ignorePredicate == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(8);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(9);
        }
        if ("EscalateVisible".equals(newVisibility)) {
            newVisibility = "public";
        }
        for (PsiMember psiMember : membersToMove) {
            RefactoringConflictsUtilImpl.analyzeUsedElementsAfterMove(psiMember, (PsiElement)psiMember, membersToMove, abstractMethods, targetClass, context, conflicts);
            RefactoringConflictsUtilImpl.checkAccessibilityConflictsAfterMove(psiMember, newVisibility, targetClass, membersToMove, conflicts, ignorePredicate);
        }
    }

    public static void checkAccessibilityConflictsAfterMove(@NotNull PsiMember member, @PsiModifier.ModifierConstant @Nullable String newVisibility, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, @NotNull Condition<? super PsiReference> ignorePredicate) {
        PsiModifierList modifierListCopy;
        if (member == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(10);
        }
        if (membersToMove == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(11);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(12);
        }
        if (ignorePredicate == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(13);
        }
        if ((modifierListCopy = member.getModifierList()) != null) {
            modifierListCopy = (PsiModifierList)modifierListCopy.copy();
            PsiClass containingClass = member.getContainingClass();
            if (containingClass != null && containingClass.isInterface()) {
                VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)"public");
            }
        }
        if (newVisibility != null && modifierListCopy != null) {
            try {
                VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)newVisibility);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        RefactoringConflictsUtilImpl.checkAccessibilityConflictsAfterMove(member, modifierListCopy, targetClass, membersToMove, conflicts, ignorePredicate);
    }

    private static void checkAccessibilityConflictsAfterMove(@NotNull PsiMember member, @Nullable PsiModifierList modifierListCopy, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, @NotNull Condition<? super PsiReference> ignorePredicate) {
        if (member == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(14);
        }
        if (membersToMove == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(15);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(16);
        }
        if (ignorePredicate == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(17);
        }
        for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member).asIterable()) {
            if (!ignorePredicate.value((Object)psiReference)) continue;
            RefactoringConflictsUtilImpl.checkAccessibilityConflictsAfterMove(psiReference, member, modifierListCopy, targetClass, membersToMove, conflicts);
        }
    }

    public static void checkAccessibilityConflictsAfterMove(@NotNull PsiReference reference, @NotNull PsiMember member, @Nullable PsiModifierList modifierListCopy, @Nullable PsiClass targetClass, @NotNull Set<? extends PsiMember> membersToMove, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        PsiElement ref;
        if (reference == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(18);
        }
        if (member == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(19);
        }
        if (membersToMove == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(20);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(21);
        }
        if (!RefactoringHierarchyUtil.willBeInTargetClass(ref = reference.getElement(), membersToMove, targetClass, true)) {
            JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)member.getProject());
            if (targetClass != null && !manager.getResolveHelper().isAccessible((PsiMember)targetClass, targetClass.getModifierList(), ref, null, null)) {
                String message = JavaRefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)targetClass, (boolean)true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)targetClass), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(ref), (boolean)true)});
                conflicts.putValue((Object)targetClass, (Object)StringUtil.capitalize((String)message));
            } else if (!JavaResolveUtil.isAccessible((PsiMember)member, (PsiClass)targetClass, (PsiModifierList)modifierListCopy, (PsiElement)ref, null, null)) {
                String message = JavaRefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), VisibilityUtil.toPresentableText((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierListCopy)), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(ref), (boolean)true)});
                conflicts.putValue((Object)ref, (Object)StringUtil.capitalize((String)message));
            }
        }
    }

    public static void analyzeUsedElementsAfterMove(PsiMember member, PsiElement scope, @NotNull Set<? extends PsiMember> membersToMove, @Nullable Set<? extends PsiMethod> abstractMethods, @Nullable PsiClass targetClass, @NotNull PsiElement context, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (membersToMove == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(22);
        }
        if (context == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(23);
        }
        RefactoringConflictsUtilImpl.checkUsedElements(member, scope, membersToMove, abstractMethods, targetClass, null, context, conflicts);
    }

    private static void checkUsedElements(PsiMember member, PsiElement scope, @NotNull Set<? extends PsiMember> membersToMove, @Nullable Set<? extends PsiMethod> abstractMethods, @Nullable PsiClass targetClass, PsiClass accessClass, @NotNull PsiElement context, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        PsiJavaCodeReferenceElement refExpr;
        PsiElement refElement;
        if (membersToMove == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(24);
        }
        if (context == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(25);
        }
        HashSet<? extends PsiMember> moving = new HashSet<PsiMember>(membersToMove);
        if (abstractMethods != null) {
            moving.addAll(abstractMethods);
        }
        if (scope instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr2 = (PsiReferenceExpression)scope;
            refElement = refExpr2.resolve();
            if (refElement instanceof PsiMember) {
                PsiClass qualifierAccessClass;
                PsiExpression qualifier = refExpr2.getQualifierExpression();
                Object object = qualifier != null && !(qualifier instanceof PsiSuperExpression) ? PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement() : (qualifierAccessClass = accessClass != null && PsiTreeUtil.isAncestor((PsiElement)((PsiMember)refElement).getContainingClass(), (PsiElement)accessClass, (boolean)true) ? null : accessClass);
                if (!(RefactoringHierarchyUtil.willBeInTargetClass(refElement, moving, targetClass, false) || qualifierAccessClass != null && RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)qualifierAccessClass, moving, targetClass, false))) {
                    RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)refElement, context, qualifierAccessClass, member, conflicts);
                }
            }
        } else if (scope instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)scope;
            PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
            if (anonymousClass != null) {
                if (!RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)anonymousClass, moving, targetClass, false)) {
                    RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)anonymousClass, context, (PsiClass)anonymousClass, member, conflicts);
                }
            } else {
                PsiMethod refElement2 = newExpression.resolveConstructor();
                if (refElement2 != null && !RefactoringHierarchyUtil.willBeInTargetClass((PsiElement)refElement2, moving, targetClass, false)) {
                    RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)refElement2, context, accessClass, member, conflicts);
                }
            }
        } else if (scope instanceof PsiJavaCodeReferenceElement && (refElement = (refExpr = (PsiJavaCodeReferenceElement)scope).resolve()) instanceof PsiMember && !RefactoringHierarchyUtil.willBeInTargetClass(refElement, moving, targetClass, false)) {
            RefactoringConflictsUtilImpl.analyzeAccessibilityAfterMove((PsiMember)refElement, context, accessClass, member, conflicts);
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiWhiteSpace || child instanceof PsiComment) continue;
            RefactoringConflictsUtilImpl.checkUsedElements(member, child, membersToMove, abstractMethods, targetClass, child instanceof PsiClass ? (PsiClass)child : accessClass, context, conflicts);
        }
    }

    public static void analyzeAccessibilityAfterMove(PsiMember refMember, @NotNull PsiElement newContext, @Nullable PsiClass accessClass, PsiMember member, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        PsiResolveHelper helper;
        if (newContext == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(26);
        }
        if (!(helper = JavaPsiFacade.getInstance((Project)newContext.getProject()).getResolveHelper()).isAccessible(refMember, refMember.getModifierList(), newContext, accessClass, newContext)) {
            String message = JavaRefactoringBundle.message((String)"0.is.1.and.will.not.be.accessible.from.2.in.the.target.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)refMember, (boolean)true), VisibilityUtil.getVisibilityStringToDisplay((PsiMember)refMember), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflicts.putValue((Object)refMember, (Object)StringUtil.capitalize((String)message));
        } else if (newContext instanceof PsiClass) {
            PsiField fieldInSubClass;
            PsiClass aClass = (PsiClass)newContext;
            if (refMember instanceof PsiField && refMember.getContainingClass() == member.getContainingClass() && (fieldInSubClass = aClass.findFieldByName(refMember.getName(), false)) != null && !refMember.hasModifierProperty("static") && fieldInSubClass != refMember && !member.hasModifierProperty("static")) {
                String message = JavaRefactoringBundle.message((String)"dialog.message.0.would.hide.which.1.used.by.moved.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)fieldInSubClass, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)refMember, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                conflicts.putValue((Object)refMember, (Object)StringUtil.capitalize((String)message));
            }
        }
    }

    public void analyzeModuleConflicts(final @NotNull Project project, final @Nullable Collection<? extends PsiElement> scopes, UsageInfo[] usages, @NotNull VirtualFile vFile, final @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (project == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(27);
        }
        if (vFile == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(28);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(29);
        }
        if (scopes == null) {
            return;
        }
        for (PsiElement psiElement : scopes) {
            if (!(psiElement instanceof PsiPackage)) continue;
            return;
        }
        final Module targetModule = ModuleUtilCore.findModuleForFile((VirtualFile)vFile, (Project)project);
        if (targetModule == null || ModuleType.isInternal((Module)targetModule)) {
            return;
        }
        final GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)targetModule);
        final HashSet reported = new HashSet();
        final Consumer<PsiJavaCodeReferenceElement> processor = new Consumer<PsiJavaCodeReferenceElement>(this){

            @Override
            public void accept(PsiJavaCodeReferenceElement reference) {
                PsiElement resolved = reference.resolve();
                if (!(resolved == null || reported.contains(resolved) || CommonRefactoringUtil.isAncestor((PsiElement)resolved, (Collection)scopes) || resolved instanceof LightElement || !resolved.isPhysical() || this.haveElementInScope(resolved))) {
                    if (resolved instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)resolved;
                        for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
                            if (!this.haveElementInScope((PsiElement)superMethod)) continue;
                            return;
                        }
                    }
                    String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)reference), (boolean)true);
                    String message = RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.in.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)resolved, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)targetModule.getName())});
                    conflicts.putValue((Object)reference, (Object)StringUtil.capitalize((String)message));
                    reported.add(resolved);
                }
            }

            private boolean haveElementInScope(PsiElement resolved) {
                if (PsiSearchScopeUtil.isInScope((GlobalSearchScope)globalSearchScope, (PsiElement)resolved)) {
                    return true;
                }
                if (!resolved.getManager().isInProject(resolved)) {
                    PsiClass classFromTarget;
                    String fqn;
                    PsiMember member;
                    PsiClass containingClass;
                    if (resolved instanceof PsiMember && (containingClass = (member = (PsiMember)resolved).getContainingClass()) != null && (fqn = containingClass.getQualifiedName()) != null && (classFromTarget = JavaPsiFacade.getInstance((Project)project).findClass(fqn, globalSearchScope)) != null) {
                        if (resolved instanceof PsiMethod) {
                            PsiMethod method = (PsiMethod)resolved;
                            return classFromTarget.findMethodsBySignature(method, true).length > 0;
                        }
                        if (resolved instanceof PsiField) {
                            PsiField field = (PsiField)resolved;
                            return classFromTarget.findFieldByName(field.getName(), false) != null;
                        }
                        if (resolved instanceof PsiClass) {
                            PsiClass aClass = (PsiClass)resolved;
                            return classFromTarget.findInnerClassByName(aClass.getName(), false) != null;
                        }
                    }
                    if (resolved instanceof PsiClass) {
                        PsiClass aClass = (PsiClass)resolved;
                        String fqn2 = aClass.getQualifiedName();
                        return fqn2 != null && JavaPsiFacade.getInstance((Project)project).findClass(fqn2, globalSearchScope) != null;
                    }
                }
                return false;
            }
        };
        for (PsiElement psiElement : scopes) {
            JavaRecursiveElementWalkingVisitor visitor2;
            if (psiElement instanceof PsiCompiledElement) {
                JavaRecursiveElementVisitor visitor22 = new JavaRecursiveElementVisitor(this){

                    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                        if (reference == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        super.visitReferenceElement(reference);
                        processor.accept(reference);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/util/RefactoringConflictsUtilImpl$2", "visitReferenceElement"));
                    }
                };
            } else {
                visitor2 = new JavaRecursiveElementWalkingVisitor(this){

                    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                        if (reference == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        super.visitReferenceElement(reference);
                        processor.accept(reference);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/util/RefactoringConflictsUtilImpl$3", "visitReferenceElement"));
                    }
                };
            }
            ProgressManager.progress((String)JavaRefactoringBundle.message((String)"processing.progress.text", (Object[])new Object[]{SymbolPresentationUtil.getSymbolPresentableText((PsiElement)psiElement)}));
            psiElement.accept((PsiElementVisitor)visitor2);
        }
        boolean isInTestSources = ModuleRootManager.getInstance((Module)targetModule).getFileIndex().isInTestSourceContent(vFile);
        block2: for (UsageInfo usage : usages) {
            Module module;
            PsiElement referencedElement;
            PsiElement element = usage.getElement();
            if (usage instanceof MoveRenameUsageInfo) {
                MoveRenameUsageInfo info = (MoveRenameUsageInfo)usage;
                v0 = info.getReferencedElement();
            } else {
                v0 = referencedElement = usage.getElement();
            }
            assert (referencedElement != null) : usage;
            PsiFile movedFile = referencedElement.getContainingFile();
            if (!(movedFile instanceof PsiJavaFile) || element == null || PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class, (boolean)false) != null) continue;
            for (PsiElement psiElement : scopes) {
                if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
                continue block2;
            }
            GlobalSearchScope resolveScope1 = element.getResolveScope();
            if (resolveScope1.isSearchInModuleContent(targetModule, isInTestSources)) continue;
            PsiFile psiFile = element.getContainingFile();
            PsiFile container = psiFile instanceof PsiJavaFile ? ConflictsUtil.getContainer(element) : psiFile;
            String scopeDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
            VirtualFile usageVFile = psiFile.getVirtualFile();
            if (usageVFile == null || (module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(usageVFile)) == null) continue;
            String message = module == targetModule && isInTestSources ? RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.production.of.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())}) : RefactoringBundle.message((String)"0.referenced.in.1.will.not.be.accessible.from.module.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true), scopeDescription, CommonRefactoringUtil.htmlEmphasize((String)module.getName())});
            conflicts.putValue((Object)element, (Object)StringUtil.capitalize((String)message));
        }
    }

    public void analyzeMethodConflictsAfterParameterDelete(@NotNull PsiMethod method, @NotNull PsiParameter parameter, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (method == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(30);
        }
        if (parameter == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(31);
        }
        if (conflicts == null) {
            RefactoringConflictsUtilImpl.$$$reportNull$$$0(32);
        }
        JavaSafeDeleteProcessor.collectMethodConflicts(conflicts, method, parameter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 16: 
            case 21: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 15: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersToMove";
                break;
            }
            case 7: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignorePredicate";
                break;
            }
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/RefactoringConflictsUtilImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeHierarchyConflictsAfterMethodModifierChange";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeAccessibilityConflictsAfterMemberMove";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAccessibilityConflictsAfterMove";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeUsedElementsAfterMove";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUsedElements";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeAccessibilityAfterMove";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeModuleConflicts";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeMethodConflictsAfterParameterDelete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

