/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberModel {
    private final MemberType myMemberType;
    private final TextRange myTextRange;

    private MemberModel(@NotNull TextRange textRange, @NotNull MemberType memberType) {
        if (textRange == null) {
            MemberModel.$$$reportNull$$$0(0);
        }
        if (memberType == null) {
            MemberModel.$$$reportNull$$$0(1);
        }
        this.myTextRange = textRange;
        this.myMemberType = memberType;
    }

    @NotNull
    public MemberType memberType() {
        MemberType memberType = this.myMemberType;
        if (memberType == null) {
            MemberModel.$$$reportNull$$$0(2);
        }
        return memberType;
    }

    @NotNull
    public TextRange textRange() {
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            MemberModel.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @Nullable
    public static MemberModel create(@NotNull PsiErrorElement errorElement) {
        if (errorElement == null) {
            MemberModel.$$$reportNull$$$0(4);
        }
        if (MemberModel.inClass(errorElement) || MemberModel.hasClassesWithUnclosedBraces(errorElement.getContainingFile())) {
            return null;
        }
        ArrayList<PsiElement> children = new ArrayList<PsiElement>();
        PsiElement prevSibling = errorElement.getPrevSibling();
        while (MemberModel.isMemberPart(prevSibling)) {
            if (prevSibling instanceof PsiErrorElement) {
                StreamEx.ofReversed((Object[])prevSibling.getChildren()).forEach(c -> children.add((PsiElement)c));
            } else {
                children.add(prevSibling);
                if (prevSibling instanceof PsiField || prevSibling instanceof PsiMethod) break;
            }
            prevSibling = prevSibling.getPrevSibling();
        }
        Collections.reverse(children);
        Collections.addAll(children, errorElement.getChildren());
        return new MemberParser(ContainerUtil.filter(children, c -> !MemberModel.isWsOrComment(c))).parse();
    }

    private static boolean inClass(@NotNull PsiErrorElement psiErrorElement) {
        PsiClass psiClass;
        if (psiErrorElement == null) {
            MemberModel.$$$reportNull$$$0(5);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiErrorElement, PsiClass.class)) == null) {
            return false;
        }
        PsiElement lBrace = psiClass.getLBrace();
        if (lBrace == null) {
            return true;
        }
        PsiElement rBrace = psiClass.getRBrace();
        if (rBrace == null) {
            return true;
        }
        TextRange errorRange = psiErrorElement.getTextRange();
        return lBrace.getTextOffset() <= errorRange.getStartOffset() && rBrace.getTextOffset() + 1 >= errorRange.getEndOffset();
    }

    private static boolean hasClassesWithUnclosedBraces(@Nullable PsiFile psiFile) {
        PsiJavaFile javaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)psiFile, PsiJavaFile.class);
        return javaFile == null || ContainerUtil.exists((Object[])javaFile.getClasses(), c -> c.getRBrace() == null);
    }

    private static boolean isWsOrComment(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            MemberModel.$$$reportNull$$$0(6);
        }
        return psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment;
    }

    private static boolean isMemberPart(@Nullable PsiElement prevSibling) {
        if (prevSibling == null || prevSibling instanceof PsiPackageStatement || prevSibling instanceof PsiImportList) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)ObjectUtils.tryCast((Object)prevSibling, PsiJavaToken.class);
        if (token == null) {
            return true;
        }
        IElementType tokenType = token.getTokenType();
        return tokenType != JavaTokenType.RBRACE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/MemberModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiErrorElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/MemberModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "memberType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWsOrComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    public static enum MemberType {
        METHOD{

            @Override
            @NotNull
            public PsiMember create(@NotNull PsiElementFactory factory, @NotNull String text, @Nullable PsiElement context) {
                if (factory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiMethod psiMethod = factory.createMethodFromText(text, context);
                if (psiMethod == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiMethod;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/MemberModel$MemberType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/MemberModel$MemberType$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
        ,
        FIELD{

            @Override
            @NotNull
            public PsiMember create(@NotNull PsiElementFactory factory, @NotNull String text, @Nullable PsiElement context) {
                if (factory == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    2.$$$reportNull$$$0(1);
                }
                PsiField psiField = factory.createFieldFromText(text, context);
                if (psiField == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiField;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/MemberModel$MemberType$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/MemberModel$MemberType$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };


        @NotNull
        public abstract PsiMember create(@NotNull PsiElementFactory var1, @NotNull String var2, @Nullable PsiElement var3);
    }

    private static class MemberParser {
        private final List<PsiElement> myChildren;
        private int pos;

        private MemberParser(@NotNull List<PsiElement> children) {
            if (children == null) {
                MemberParser.$$$reportNull$$$0(0);
            }
            this.myChildren = children;
        }

        private MemberModel parse() {
            PsiJavaToken endElement;
            PsiElement startElement = this.nextChild();
            PsiElement element = this.parseModifiers(startElement);
            if (element == null) {
                return null;
            }
            PsiJavaToken token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.parseModifiers(this.parseTypeParams(element)), PsiJavaToken.class);
            if (token == null) {
                MemberType memberType = MemberParser.parseMemberType(element);
                return memberType == null ? null : new MemberModel(MemberParser.textRange(startElement, element), memberType);
            }
            boolean hasTypeParams = token != element;
            if ((token = this.parseType(token)) == null) {
                return null;
            }
            if ((token = MemberParser.parseIdentifier(token)) == null) {
                return null;
            }
            token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.nextChild(), PsiJavaToken.class);
            if (token == null) {
                return null;
            }
            if (!hasTypeParams && (endElement = this.parseField(token)) != null) {
                return new MemberModel(MemberParser.textRange(startElement, (PsiElement)endElement), MemberType.FIELD);
            }
            endElement = this.parseMethod(token);
            if (endElement != null) {
                return new MemberModel(MemberParser.textRange(startElement, (PsiElement)endElement), MemberType.METHOD);
            }
            return null;
        }

        @Nullable
        private PsiJavaToken parseMethod(@NotNull PsiJavaToken token) {
            if (token == null) {
                MemberParser.$$$reportNull$$$0(1);
            }
            if ((token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.parseModifiers(this.parseParams(token)), PsiJavaToken.class)) == null) {
                return null;
            }
            if ((token = this.parseArrayType(token)) == null) {
                return null;
            }
            if ((token = this.parseThrowsClause(token)) == null) {
                return null;
            }
            IElementType tokenType = token.getTokenType();
            if (tokenType == JavaTokenType.SEMICOLON) {
                return token;
            }
            if (tokenType != JavaTokenType.LBRACE) {
                return null;
            }
            return this.findClosingBracket((PsiElement)token, JavaTokenType.LBRACE, JavaTokenType.RBRACE);
        }

        @Nullable
        private PsiJavaToken parseThrowsClause(@Nullable PsiJavaToken token) {
            if (!(token instanceof PsiKeyword) || !"throws".equals(token.getText())) {
                return token;
            }
            token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.nextChild(), PsiIdentifier.class);
            if (token == null) {
                return null;
            }
            token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.parseQualifiedType(this.nextChild()), PsiJavaToken.class);
            while (token != null && token.getTokenType() == JavaTokenType.COMMA) {
                token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.nextChild(), PsiIdentifier.class);
                if (token == null) {
                    return null;
                }
                token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.parseQualifiedType(this.nextChild()), PsiJavaToken.class);
            }
            return token;
        }

        @Nullable
        private PsiElement parseParams(@NotNull PsiJavaToken child) {
            if (child == null) {
                MemberParser.$$$reportNull$$$0(2);
            }
            if (child.getTokenType() != JavaTokenType.LPARENTH) {
                return null;
            }
            PsiJavaToken closingBracket = this.findClosingBracket((PsiElement)child, JavaTokenType.LPARENTH, JavaTokenType.RPARENTH);
            if (closingBracket == null) {
                return null;
            }
            return this.nextChild();
        }

        @Nullable
        private PsiElement parseModifiers(@Nullable PsiElement child) {
            return child instanceof PsiModifierList ? this.nextChild() : child;
        }

        @Nullable
        private PsiElement parseTypeParams(@Nullable PsiElement element) {
            return element instanceof PsiTypeParameterList ? this.nextChild() : element;
        }

        @Nullable
        private PsiJavaToken parseType(@NotNull PsiJavaToken child) {
            IElementType tokenType;
            boolean isPrimitiveType;
            if (child == null) {
                MemberParser.$$$reportNull$$$0(3);
            }
            if (!(isPrimitiveType = ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType = child.getTokenType())) && tokenType != JavaTokenType.IDENTIFIER) {
                return null;
            }
            PsiElement element = this.nextChild();
            element = !isPrimitiveType ? this.parseQualifiedType(element) : this.parseModifiers(element);
            return this.parseArrayType((PsiJavaToken)ObjectUtils.tryCast((Object)element, PsiJavaToken.class));
        }

        @Nullable
        private PsiElement parseQualifiedType(@Nullable PsiElement element) {
            element = this.parseTypeParams(this.parseModifiers(element));
            PsiJavaToken javaToken = (PsiJavaToken)ObjectUtils.tryCast((Object)element, PsiJavaToken.class);
            while (javaToken != null && javaToken.getTokenType() == JavaTokenType.DOT) {
                element = this.nextChild();
                if (!((element = this.parseModifiers(element)) instanceof PsiIdentifier)) {
                    return null;
                }
                element = this.nextChild();
                element = this.parseTypeParams(this.parseModifiers(element));
                javaToken = (PsiJavaToken)ObjectUtils.tryCast((Object)element, PsiJavaToken.class);
            }
            return element;
        }

        @Nullable
        private PsiJavaToken nextJavaToken() {
            PsiElement child;
            while ((child = this.nextChild()) != null && !(child instanceof PsiJavaToken)) {
            }
            return (PsiJavaToken)child;
        }

        @Nullable
        private PsiElement nextChild() {
            if (this.pos >= this.myChildren.size()) {
                return null;
            }
            PsiElement child = this.myChildren.get(this.pos);
            ++this.pos;
            return child;
        }

        @Nullable
        private PsiJavaToken findClosingBracket(@NotNull PsiElement child, @NotNull IElementType openBracket, @NotNull IElementType closeBracket) {
            if (child == null) {
                MemberParser.$$$reportNull$$$0(4);
            }
            if (openBracket == null) {
                MemberParser.$$$reportNull$$$0(5);
            }
            if (closeBracket == null) {
                MemberParser.$$$reportNull$$$0(6);
            }
            int depth = 0;
            do {
                PsiJavaToken token;
                if ((token = (PsiJavaToken)ObjectUtils.tryCast((Object)child, PsiJavaToken.class)) == null) continue;
                IElementType tokenType = token.getTokenType();
                if (tokenType == openBracket) {
                    ++depth;
                } else if (tokenType == closeBracket) {
                    --depth;
                }
                if (depth == 0) break;
            } while ((child = this.nextChild()) != null);
            return (PsiJavaToken)ObjectUtils.tryCast((Object)child, PsiJavaToken.class);
        }

        @Nullable
        private PsiJavaToken parseField(@NotNull PsiJavaToken token) {
            if (token == null) {
                MemberParser.$$$reportNull$$$0(7);
            }
            if ((token = this.parseArrayType(token)) == null) {
                return null;
            }
            IElementType tokenType = token.getTokenType();
            if (tokenType == JavaTokenType.SEMICOLON) {
                return token;
            }
            if (tokenType != JavaTokenType.EQ) {
                return null;
            }
            while (tokenType != JavaTokenType.SEMICOLON) {
                if (tokenType == JavaTokenType.LBRACE && (token = this.findClosingBracket((PsiElement)token, JavaTokenType.LBRACE, JavaTokenType.RBRACE)) == null) {
                    return null;
                }
                token = this.nextJavaToken();
                if (token == null) break;
                tokenType = token.getTokenType();
            }
            return token;
        }

        @Nullable
        private PsiJavaToken parseArrayType(@Nullable PsiJavaToken token) {
            while (token != null && token.getTokenType() == JavaTokenType.LBRACKET) {
                token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.nextChild(), PsiJavaToken.class);
                if (token == null || token.getTokenType() != JavaTokenType.RBRACKET) {
                    return null;
                }
                token = (PsiJavaToken)ObjectUtils.tryCast((Object)this.parseModifiers(this.nextChild()), PsiJavaToken.class);
            }
            return token;
        }

        @Nullable
        private static MemberType parseMemberType(@NotNull PsiElement element) {
            if (element == null) {
                MemberParser.$$$reportNull$$$0(8);
            }
            if (element instanceof PsiMethod) {
                return MemberType.METHOD;
            }
            return element instanceof PsiField ? MemberType.FIELD : null;
        }

        @NotNull
        private static TextRange textRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (startElement == null) {
                MemberParser.$$$reportNull$$$0(9);
            }
            if (endElement == null) {
                MemberParser.$$$reportNull$$$0(10);
            }
            int start = startElement.getTextRange().getStartOffset();
            int end = endElement.getTextRange().getEndOffset();
            return new TextRange(start, end);
        }

        @Nullable
        private static PsiJavaToken parseIdentifier(@NotNull PsiJavaToken child) {
            IElementType tokenType;
            if (child == null) {
                MemberParser.$$$reportNull$$$0(11);
            }
            return (tokenType = child.getTokenType()) == JavaTokenType.IDENTIFIER ? child : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "openBracket";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeBracket";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/MemberModel$MemberParser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseParams";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseType";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findClosingBracket";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseField";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseMemberType";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "textRange";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parseIdentifier";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

