/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.Collection;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class AddMissingDeconstructionComponentsFix
extends PsiUpdateModCommandAction<PsiDeconstructionList> {
    @NotNull
    private final Collection<Pattern> myMissingPatterns;

    public AddMissingDeconstructionComponentsFix(@NotNull PsiDeconstructionList deconstructionList, @NotNull Collection<Pattern> missingPatterns) {
        if (deconstructionList == null) {
            AddMissingDeconstructionComponentsFix.$$$reportNull$$$0(0);
        }
        if (missingPatterns == null) {
            AddMissingDeconstructionComponentsFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)deconstructionList);
        this.myMissingPatterns = missingPatterns;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.missing.nested.patterns.fix.text", this.myMissingPatterns.size());
        if (string == null) {
            AddMissingDeconstructionComponentsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiDeconstructionList deconstructionList, @NotNull ModPsiUpdater updater) {
        PsiElement psiElement;
        if (context == null) {
            AddMissingDeconstructionComponentsFix.$$$reportNull$$$0(3);
        }
        if (deconstructionList == null) {
            AddMissingDeconstructionComponentsFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            AddMissingDeconstructionComponentsFix.$$$reportNull$$$0(5);
        }
        if ((psiElement = deconstructionList.getParent()) instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)psiElement;
            boolean isEmptyList = deconstructionList.getDeconstructionComponents().length == 0;
            String deconstructionListText = deconstructionList.getText();
            String prefix = deconstructionListText.substring(0, deconstructionListText.length() - 1) + (isEmptyList ? "" : ",");
            String newDeconstructionListText = StreamEx.of(this.myMissingPatterns).map(Pattern::toString).joining((CharSequence)",", (CharSequence)prefix, (CharSequence)")");
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)context.project());
            String text = "o instanceof " + deconstructionPattern.getTypeElement().getText() + newDeconstructionListText;
            PsiInstanceOfExpression instanceOf = (PsiInstanceOfExpression)factory.createExpressionFromText(text, null);
            PsiDeconstructionPattern newPattern = (PsiDeconstructionPattern)instanceOf.getPattern();
            assert (newPattern != null);
            deconstructionPattern.replace((PsiElement)newPattern);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deconstructionList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingPatterns";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingDeconstructionComponentsFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingDeconstructionComponentsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public record Pattern(@NotNull String type, @NotNull String name) {
        @NotNull
        private final String type;
        @NotNull
        private final String name;

        public Pattern(@NotNull String type, @NotNull String name) {
            if (type == null) {
                Pattern.$$$reportNull$$$0(0);
            }
            if (name == null) {
                Pattern.$$$reportNull$$$0(1);
            }
        }

        @Override
        public String toString() {
            return this.type + " " + this.name;
        }

        public static Pattern create(@NotNull PsiRecordComponent recordComponent, @NotNull PsiElement context) {
            PsiClassType classType;
            if (recordComponent == null) {
                Pattern.$$$reportNull$$$0(2);
            }
            if (context == null) {
                Pattern.$$$reportNull$$$0(3);
            }
            JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)context.getProject());
            String name = manager.suggestUniqueVariableName(recordComponent.getName(), context, true);
            PsiType type = recordComponent.getType();
            if (type instanceof PsiClassType && (classType = (PsiClassType)type).resolve() instanceof PsiTypeParameter) {
                return new Pattern("var", name);
            }
            return new Pattern(type.getCanonicalText(), name);
        }

        @NotNull
        public String type() {
            String string = this.type;
            if (string == null) {
                Pattern.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String name() {
            String string = this.name;
            if (string == null) {
                Pattern.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordComponent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingDeconstructionComponentsFix$Pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddMissingDeconstructionComponentsFix$Pattern";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

