/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddTypeArgumentsFix
extends MethodArgumentFix {
    private static final Logger LOG = Logger.getInstance(AddTypeArgumentsFix.class);
    public static final ArgumentFixerActionFactory REGISTRAR = new MyFixerActionFactory();

    private AddTypeArgumentsFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory factory) {
        if (list == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(0);
        }
        if (toType == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(2);
        }
        super(list, i, toType, factory);
    }

    @Override
    @NotNull
    public String getText(@NotNull PsiExpressionList list) {
        if (list == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(3);
        }
        if (list.getExpressionCount() == 1) {
            String string = QuickFixBundle.message("add.type.arguments.single.argument.text", new Object[0]);
            if (string == null) {
                AddTypeArgumentsFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = QuickFixBundle.message("add.type.arguments.text", this.myIndex + 1);
        if (string == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static PsiExpression addTypeArguments(@NotNull PsiExpression expression, @Nullable PsiType toType) {
        if (expression == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(6);
        }
        return AddTypeArgumentsFix.addTypeArguments(expression, toType, true);
    }

    @Nullable
    public static PsiExpression addTypeArguments(@NotNull PsiExpression expression, @Nullable PsiType toType, boolean withShortening) {
        if (expression == null) {
            AddTypeArgumentsFix.$$$reportNull$$$0(7);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.GENERICS, (PsiElement)expression)) {
            return null;
        }
        PsiExpression orig = expression;
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression;
            PsiReferenceParameterList list = methodCall.getMethodExpression().getParameterList();
            if (list == null || list.getTypeArguments().length > 0) {
                return null;
            }
            JavaResolveResult resolveResult = methodCall.resolveMethodGenerics();
            PsiElement element = resolveResult.getElement();
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiType returnType = method.getReturnType();
                if (returnType == null) {
                    return null;
                }
                PsiTypeParameter[] typeParameters = method.getTypeParameters();
                if (typeParameters.length > 0) {
                    PsiMethodCallExpression result;
                    PsiType[] mappings = PsiType.createArray((int)typeParameters.length);
                    PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
                    LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)expression);
                    for (int i = 0; i < typeParameters.length; ++i) {
                        PsiType substitution;
                        PsiTypeParameter typeParameter = typeParameters[i];
                        if (toType == null) {
                            substitution = resolveResult.getSubstitutor().substitute(typeParameter);
                            if (!PsiTypesUtil.isDenotableType((PsiType)substitution, (PsiElement)expression)) {
                                return null;
                            }
                        } else {
                            substitution = helper.getSubstitutionForTypeParameter(typeParameter, returnType, toType, false, level);
                        }
                        if (substitution == null || PsiTypes.nullType().equals(substitution)) {
                            return null;
                        }
                        mappings[i] = GenericsUtil.eliminateWildcards((PsiType)substitution, (boolean)false);
                    }
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
                    PsiMethodCallExpression copy = (PsiMethodCallExpression)expression.copy();
                    PsiReferenceExpression methodExpression = copy.getMethodExpression();
                    PsiReferenceParameterList parameterList = methodExpression.getParameterList();
                    LOG.assertTrue(parameterList != null);
                    for (PsiType mapping : mappings) {
                        parameterList.add((PsiElement)factory.createTypeElement(mapping));
                    }
                    if (methodExpression.getQualifierExpression() == null) {
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass == null) {
                            return null;
                        }
                        Object qualifierExpression = method.hasModifierProperty("static") ? factory.createReferenceExpression(containingClass) : RefactoringChangeUtil.createThisExpression((PsiManager)method.getManager(), null);
                        methodExpression.setQualifierExpression((PsiExpression)qualifierExpression);
                    }
                    Object object = result = withShortening ? (PsiExpression)JavaCodeStyleManager.getInstance((Project)copy.getProject()).shortenClassReferences((PsiElement)copy) : copy;
                    if (orig != expression) {
                        PsiExpression parenthesized = (PsiExpression)orig.copy();
                        Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)parenthesized)).replace((PsiElement)result);
                        return parenthesized;
                    }
                    return result;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTypeArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        private MyFixerActionFactory() {
        }

        @Override
        public IntentionAction createFix(PsiExpressionList list, int i, PsiType toType) {
            return new AddTypeArgumentsFix(list, i, toType, this).asIntention();
        }

        @Override
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            return AddTypeArgumentsFix.addTypeArguments(expression, toType);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(0);
            }
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyFixerActionFactory.$$$reportNull$$$0(2);
            }
            return !(exprType instanceof PsiPrimitiveType) && !(parameterType instanceof PsiPrimitiveType) || TypeConversionUtil.boxingConversionApplicable((PsiType)exprType, (PsiType)parameterType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exprType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeArgumentsFix$MyFixerActionFactory";
            objectArray[2] = "areTypesConvertible";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

