/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeCastFix
extends PsiUpdateModCommandAction<PsiExpression> {
    private final PsiType myType;
    @IntentionName
    private final String myName;

    public AddTypeCastFix(@NotNull PsiType type, @NotNull PsiExpression expression) {
        if (type == null) {
            AddTypeCastFix.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            AddTypeCastFix.$$$reportNull$$$0(1);
        }
        this(type, expression, null);
    }

    public AddTypeCastFix(@NotNull PsiType type, @NotNull PsiExpression expression, @Nls @Nullable String role) {
        boolean literalConversion;
        if (type == null) {
            AddTypeCastFix.$$$reportNull$$$0(2);
        }
        if (expression == null) {
            AddTypeCastFix.$$$reportNull$$$0(3);
        }
        super((PsiElement)expression);
        boolean bl = literalConversion = AddTypeCastFix.tryConvertNumericLiteral((PsiElement)expression, type) != null;
        if (role == null) {
            role = QuickFixBundle.message(literalConversion ? "fix.expression.role.literal" : "fix.expression.role.expression", new Object[0]);
        }
        this.myType = type;
        this.myName = QuickFixBundle.message(literalConversion ? "add.typecast.convert.text" : "add.typecast.cast.text", type.isValid() ? type.getCanonicalText() : "", role);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.typecast.family", new Object[0]);
        if (string == null) {
            AddTypeCastFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpression expr) {
        if (context == null) {
            AddTypeCastFix.$$$reportNull$$$0(5);
        }
        if (expr == null) {
            AddTypeCastFix.$$$reportNull$$$0(6);
        }
        if (!this.myType.isValid() || PsiTypes.voidType().equals((Object)this.myType) || !PsiTypesUtil.isDenotableType((PsiType)this.myType, (PsiElement)expr) || !PsiTypesUtil.allTypeParametersResolved((PsiElement)expr, (PsiType)this.myType)) {
            return null;
        }
        return Presentation.of((String)this.myName).withPriority(PriorityAction.Priority.HIGH).withFixAllOption((ModCommandAction)this);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiExpression expression, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            AddTypeCastFix.$$$reportNull$$$0(7);
        }
        if (expression == null) {
            AddTypeCastFix.$$$reportNull$$$0(8);
        }
        if (updater == null) {
            AddTypeCastFix.$$$reportNull$$$0(9);
        }
        AddTypeCastFix.addTypeCast(context.project(), expression, this.myType);
    }

    public static void addTypeCast(Project project, PsiExpression originalExpression, PsiType type) {
        PsiExpression typeCast = AddTypeCastFix.createCastExpression(originalExpression, type);
        originalExpression.replace((PsiElement)Objects.requireNonNull(typeCast));
    }

    static String tryConvertNumericLiteral(PsiElement expr, @NotNull PsiType type) {
        String string;
        if (type == null) {
            AddTypeCastFix.$$$reportNull$$$0(10);
        }
        if (expr instanceof PsiLiteralExpression) {
            PsiLiteralExpression literal = (PsiLiteralExpression)expr;
            string = PsiLiteralUtil.tryConvertNumericLiteral((PsiLiteralExpression)literal, (PsiType)type);
        } else {
            string = null;
        }
        return string;
    }

    static PsiExpression createCastExpression(PsiExpression original, PsiType type) {
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)original);
        if (expression == null) {
            return null;
        }
        if (type.equals(PsiTypes.nullType())) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)original.getProject());
        String newLiteral = AddTypeCastFix.tryConvertNumericLiteral((PsiElement)expression, type);
        if (newLiteral != null) {
            return factory.createExpressionFromText(newLiteral, null);
        }
        if (type instanceof PsiEllipsisType) {
            PsiEllipsisType ellipsisType = (PsiEllipsisType)type;
            type = ellipsisType.toArrayType();
        }
        String text = "(" + type.getCanonicalText(false) + ")value";
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)factory.createExpressionFromText(text, (PsiElement)original);
        PsiExpression operand = typeCast.getOperand();
        assert (operand != null);
        if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression.copy();
            PsiExpression thenExpression = conditional.getThenExpression();
            PsiExpression elseExpression = conditional.getElseExpression();
            if (thenExpression != null && elseExpression != null) {
                boolean replaceElse;
                boolean replaceThen = !TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type, (PsiExpression)thenExpression);
                boolean bl = replaceElse = !TypeConversionUtil.areTypesAssignmentCompatible((PsiType)type, (PsiExpression)elseExpression);
                if (replaceThen != replaceElse) {
                    if (replaceThen) {
                        operand.replace((PsiElement)thenExpression);
                        thenExpression.replace((PsiElement)typeCast);
                    } else {
                        operand.replace((PsiElement)elseExpression);
                        elseExpression.replace((PsiElement)typeCast);
                    }
                    return conditional;
                }
            }
        }
        operand.replace((PsiElement)expression);
        return typeCast;
    }

    public static void registerFix(QuickFixActionRegistrar registrar, PsiExpression qualifier, PsiJavaCodeReferenceElement ref, TextRange fixRange) {
        String referenceName = ref.getReferenceName();
        if (referenceName == null) {
            return;
        }
        if (qualifier instanceof PsiReferenceExpression) {
            MethodCandidateInfo candidateInfo;
            JavaResolveResult result;
            PsiMethodCallExpression callExpression;
            PsiParameter parameter;
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement resolve = referenceExpression.resolve();
            if (resolve == null) {
                return;
            }
            if (resolve instanceof PsiParameter && (parameter = (PsiParameter)resolve).getTypeElement() == null && (callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)resolve, PsiMethodCallExpression.class)) != null && (result = callExpression.resolveMethodGenerics()) instanceof MethodCandidateInfo && (candidateInfo = (MethodCandidateInfo)result).getInferenceErrorMessage() != null) {
                return;
            }
        }
        PsiElement gParent = ref.getParent();
        List<PsiType> conjuncts = GuessManager.getInstance(qualifier.getProject()).getControlFlowExpressionTypeConjuncts(qualifier);
        for (PsiType conjunct : conjuncts) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)conjunct);
            if (psiClass == null || (gParent instanceof PsiMethodCallExpression ? psiClass.findMethodsByName(referenceName).length == 0 : psiClass.findFieldByName(referenceName, true) == null)) continue;
            registrar.register(fixRange, new AddTypeCastFix(conjunct, qualifier, QuickFixBundle.message("fix.expression.role.qualifier", new Object[0])).asIntention(), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryConvertNumericLiteral";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

