/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.infos.CandidateInfo;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class ConstructorParametersFixer {
    public static void registerFixActions(@NotNull PsiConstructorCall constructorCall, @NotNull Consumer<? super CommonIntentionAction> info) {
        PsiEnumConstant enumConstant;
        PsiClass containingClass;
        if (constructorCall == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(1);
        }
        if (constructorCall instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)constructorCall;
            PsiJavaCodeReferenceElement ctrRef = newExpression.getClassOrAnonymousClassReference();
            if (ctrRef == null) {
                return;
            }
            JavaResolveResult resolved = ctrRef.advancedResolve(false);
            PsiClass aClass = (PsiClass)resolved.getElement();
            PsiSubstitutor substitutor = resolved.getSubstitutor();
            if (aClass == null) {
                return;
            }
            ConstructorParametersFixer.registerFixActions(aClass, substitutor, constructorCall, info);
        } else if (constructorCall instanceof PsiEnumConstant && (containingClass = (enumConstant = (PsiEnumConstant)constructorCall).getContainingClass()) != null) {
            ConstructorParametersFixer.registerFixActions(containingClass, PsiSubstitutor.EMPTY, constructorCall, info);
        }
    }

    private static void registerFixActions(@NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull PsiConstructorCall constructorCall, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (aClass == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(3);
        }
        if (constructorCall == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(4);
        }
        if (info == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(5);
        }
        PsiMethod[] methods = aClass.getConstructors();
        CandidateInfo[] candidates = new CandidateInfo[methods.length];
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = new CandidateInfo((PsiElement)methods[i], substitutor);
        }
        CastMethodArgumentFix.REGISTRAR.registerCastActions(candidates, (PsiCall)constructorCall, info);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(candidates, (PsiCall)constructorCall, info);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(candidates, (PsiCall)constructorCall, info);
        WrapWithAdapterMethodCallFix.registerCastActions(candidates, (PsiCall)constructorCall, info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "constructorCall";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "substitutor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConstructorParametersFixer";
        objectArray[2] = "registerFixActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

