/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapObjectWithOptionalOfNullableFix
extends MethodArgumentFix {
    public static final ArgumentFixerActionFactory REGISTAR = new MyFixerActionFactory();

    protected WrapObjectWithOptionalOfNullableFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        if (list == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(0);
        }
        if (toType == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(1);
        }
        if (fixerActionFactory == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(2);
        }
        super(list, i, toType, fixerActionFactory);
    }

    @Override
    @NotNull
    public String getText(@NotNull PsiExpressionList list) {
        if (list == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(3);
        }
        if (list.getExpressionCount() == 1) {
            String string = QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
            if (string == null) {
                WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = QuickFixBundle.message("wrap.with.optional.parameter.text", this.myIndex + 1);
        if (string == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpressionList list) {
        if (context == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(6);
        }
        if (list == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(7);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.STREAM_OPTIONAL, (PsiElement)context.file())) {
            return null;
        }
        Presentation presentation = super.getPresentation(context, list);
        return presentation == null ? null : presentation.withPriority(PriorityAction.Priority.HIGH);
    }

    public static IntentionAction createFix(@Nullable PsiType type, @NotNull PsiExpression expression) {
        if (expression == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(8);
        }
        return new MyFix(expression, type).asIntention();
    }

    private static boolean areConvertible(@Nullable PsiType exprType, @Nullable PsiType parameterType) {
        if (!(exprType != null && exprType.isValid() && parameterType instanceof PsiClassType && parameterType.isValid())) {
            return false;
        }
        PsiClassType.ClassResolveResult resolve = ((PsiClassType)parameterType).resolveGenerics();
        PsiClass resolvedClass = resolve.getElement();
        if (resolvedClass == null || !"java.util.Optional".equals(resolvedClass.getQualifiedName())) {
            return false;
        }
        Collection values = resolve.getSubstitutor().getSubstitutionMap().values();
        if (values.isEmpty()) {
            return true;
        }
        if (values.size() > 1) {
            return false;
        }
        PsiType optionalTypeParameter = (PsiType)ContainerUtil.getFirstItem(values);
        if (optionalTypeParameter == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable((PsiType)optionalTypeParameter, (PsiType)exprType);
    }

    @NotNull
    private static PsiExpression getModifiedExpression(PsiExpression expression) {
        Project project = expression.getProject();
        Nullability nullability = NullabilityUtil.getExpressionNullability(expression, true);
        String methodName = nullability == Nullability.NOT_NULL ? "of" : "ofNullable";
        String newExpressionText = "java.util.Optional." + methodName + "(" + expression.getText() + ")";
        PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newExpressionText, (PsiElement)expression);
        if (psiExpression == null) {
            WrapObjectWithOptionalOfNullableFix.$$$reportNull$$$0(9);
        }
        return psiExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixerActionFactory";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9 -> new IllegalStateException(string);
        };
    }

    private static class MyFix
    extends PsiUpdateModCommandAction<PsiExpression> {
        private final PsiType myType;

        protected MyFix(@NotNull PsiExpression element, @Nullable PsiType type) {
            if (element == null) {
                MyFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.myType = type;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
            if (string == null) {
                MyFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiExpression expression, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                MyFix.$$$reportNull$$$0(2);
            }
            if (expression == null) {
                MyFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                MyFix.$$$reportNull$$$0(4);
            }
            expression.replace((PsiElement)WrapObjectWithOptionalOfNullableFix.getModifiedExpression(expression));
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpression expression) {
            if (context == null) {
                MyFix.$$$reportNull$$$0(5);
            }
            if (expression == null) {
                MyFix.$$$reportNull$$$0(6);
            }
            if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.STREAM_OPTIONAL, (PsiElement)expression) || !WrapObjectWithOptionalOfNullableFix.areConvertible(expression.getType(), this.myType)) {
                return null;
            }
            return Presentation.of((String)this.getFamilyName()).withPriority(PriorityAction.Priority.HIGH);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyFix";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            return WrapObjectWithOptionalOfNullableFix.getModifiedExpression(expression);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(0);
            }
            if (parameterType == null) {
                MyFixerActionFactory.$$$reportNull$$$0(1);
            }
            if (context == null) {
                MyFixerActionFactory.$$$reportNull$$$0(2);
            }
            return parameterType.isConvertibleFrom(exprType) || WrapObjectWithOptionalOfNullableFix.areConvertible(exprType, parameterType);
        }

        @Override
        public IntentionAction createFix(PsiExpressionList list, int i, PsiType toType) {
            return new WrapObjectWithOptionalOfNullableFix(list, i, toType, this).asIntention();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "exprType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/WrapObjectWithOptionalOfNullableFix$MyFixerActionFactory";
            objectArray[2] = "areTypesConvertible";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

