/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.java.codeserver.core.JavaPsiAnnotationUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationPsiFix
extends LocalQuickFixOnPsiElement
implements LocalQuickFix {
    protected final String myAnnotation;
    final String[] myAnnotationsToRemove;
    @FileModifier.SafeFieldForPreview
    final PsiNameValuePair[] myPairs;
    @IntentionName
    protected final String myText;
    private final ExternalAnnotationsManager.AnnotationPlace myAnnotationPlace;
    private final boolean myAvailableInBatchMode;

    @Deprecated
    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(0);
        }
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(1);
        }
        if (annotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(2);
        }
        this(fqn, modifierListOwner, PsiNameValuePair.EMPTY_ARRAY, annotationsToRemove);
    }

    @Deprecated
    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, PsiNameValuePair @NotNull [] values, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(3);
        }
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(4);
        }
        if (values == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(5);
        }
        if (annotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(6);
        }
        this(fqn, modifierListOwner, values, AddAnnotationPsiFix.choosePlace(fqn, modifierListOwner), annotationsToRemove);
    }

    @Deprecated
    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, PsiNameValuePair @NotNull [] values, @NotNull ExternalAnnotationsManager.AnnotationPlace place, String ... annotationsToRemove) {
        if (fqn == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(7);
        }
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(8);
        }
        if (place == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(9);
        }
        if (values == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(10);
        }
        if (annotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(11);
        }
        super((PsiElement)modifierListOwner);
        this.myAnnotation = fqn;
        ObjectUtils.assertAllElementsNotNull((Object[])values);
        this.myPairs = values;
        ObjectUtils.assertAllElementsNotNull((Object[])annotationsToRemove);
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myText = AddAnnotationPsiFix.calcText(modifierListOwner, this.myAnnotation);
        this.myAnnotationPlace = place;
        this.myAvailableInBatchMode = place == ExternalAnnotationsManager.AnnotationPlace.IN_CODE || place == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL && ExternalAnnotationsManager.getInstance((Project)modifierListOwner.getProject()).hasConfiguredAnnotationRoot(modifierListOwner);
    }

    @IntentionName
    public static String calcText(PsiModifierListOwner modifierListOwner, @Nullable String annotation) {
        String name;
        String shortName;
        String string = shortName = annotation == null ? null : annotation.substring(annotation.lastIndexOf(46) + 1);
        if (modifierListOwner instanceof PsiNamedElement && (name = PsiFormatUtil.formatSimple((PsiNamedElement)((PsiNamedElement)modifierListOwner))) != null) {
            JavaElementKind type = JavaElementKind.fromElement((PsiElement)modifierListOwner).lessDescriptive();
            return AddAnnotationPsiFix.calcText(shortName, type, name);
        }
        if (shortName == null) {
            return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate", (Object[])new Object[0]);
        }
        return JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.as", (Object[])new Object[]{shortName});
    }

    @Nls
    @NotNull
    public static String calcText(@Nullable String shortName, @NotNull JavaElementKind type, @NotNull String name) {
        if (type == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(12);
        }
        if (name == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(13);
        }
        if (shortName == null) {
            String string = JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.element", (Object[])new Object[]{type.object(), name});
            if (string == null) {
                AddAnnotationPsiFix.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.element.as", (Object[])new Object[]{type.object(), name, shortName});
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset) {
        return AddAnnotationPsiFix.getContainer(file, offset, false);
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file, int offset, boolean availableOnReference) {
        PsiElement id;
        PsiElement target;
        PsiReference reference;
        PsiReference psiReference = reference = availableOnReference ? file.findReferenceAt(offset) : null;
        if (reference != null && (target = reference.resolve()) instanceof PsiMember) {
            return (PsiMember)target;
        }
        PsiElement element = file.findElementAt(offset);
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
        if (listOwner instanceof PsiParameter) {
            return listOwner;
        }
        if (listOwner instanceof PsiNameIdentifierOwner && (id = ((PsiNameIdentifierOwner)listOwner).getNameIdentifier()) != null && id.getTextRange().containsOffset(offset)) {
            return listOwner;
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(17);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(18);
        }
        if (psiFile == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(19);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(20);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(21);
        }
        return AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)startElement, this.myAnnotation);
    }

    public static boolean isAvailable(@NotNull PsiModifierListOwner modifierListOwner, @NotNull String annotationFQN) {
        PsiParameter parameter;
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(22);
        }
        if (annotationFQN == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(23);
        }
        if (!modifierListOwner.isValid()) {
            return false;
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.ANNOTATIONS, (PsiElement)modifierListOwner)) {
            return false;
        }
        if (modifierListOwner instanceof PsiParameter && (parameter = (PsiParameter)modifierListOwner).getTypeElement() == null) {
            PsiParameterList list;
            PsiElement psiElement = modifierListOwner.getParent();
            if (psiElement instanceof PsiParameterList && (psiElement = (list = (PsiParameterList)psiElement).getParent()) instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)psiElement;
                if (PsiUtil.isAvailable((JavaFeature)JavaFeature.VAR_LAMBDA_PARAMETER, (PsiElement)modifierListOwner)) {
                    return true;
                }
                return LambdaUtil.createLambdaParameterListWithFormalTypes((PsiType)lambda.getFunctionalInterfaceType(), (PsiLambdaExpression)lambda, (boolean)false) != null;
            }
            return false;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null || modifierList instanceof LightElement || modifierListOwner instanceof LightElement) {
            return false;
        }
        PsiClass annotationClass = JavaPsiFacade.getInstance((Project)modifierListOwner.getProject()).findClass(annotationFQN, modifierListOwner.getResolveScope());
        boolean hasTypeUse = annotationClass != null && AnnotationTargetUtil.findAnnotationTarget((PsiClass)annotationClass, (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) != null;
        PsiAnnotationOwner target = AnnotationTargetUtil.getTarget((PsiModifierListOwner)modifierListOwner, (boolean)hasTypeUse);
        if (target == modifierList) {
            return !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)annotationFQN, (int)(2 | (hasTypeUse ? 8 : 0)));
        }
        return target != null && !target.hasAnnotation(annotationFQN);
    }

    public boolean startInWriteAction() {
        return this.myAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
    }

    public boolean availableInBatchMode() {
        return this.myAvailableInBatchMode;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        ActionContext context;
        PsiModifierListOwner modifierListOwner;
        AddAnnotationModCommandAction delegate;
        if (project == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(24);
        }
        if (psiFile == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(25);
        }
        if (startElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(26);
        }
        if (endElement == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(27);
        }
        if ((delegate = new AddAnnotationModCommandAction(this.myAnnotation, modifierListOwner = (PsiModifierListOwner)startElement, this.myPairs, this.myAnnotationPlace, this.myAnnotationsToRemove)).getPresentation(context = ActionContext.from(null, (PsiFile)psiFile)) == null) {
            return;
        }
        ModCommandExecutor.executeInteractively((ActionContext)context, (String)this.getFamilyName(), null, () -> delegate.perform(context));
    }

    @NotNull
    public static ExternalAnnotationsManager.AnnotationPlace choosePlace(@NotNull String annotation, @NotNull PsiModifierListOwner modifierListOwner) {
        PsiClass aClass;
        if (annotation == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(28);
        }
        if (modifierListOwner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(29);
        }
        Project project = modifierListOwner.getProject();
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project);
        if (BaseIntentionAction.canModify((PsiElement)modifierListOwner) && (aClass = JavaPsiFacade.getInstance((Project)project).findClass(annotation, modifierListOwner.getResolveScope())) != null) {
            PsiClass resolvedBySimpleName;
            if (JavaPsiAnnotationUtil.getRetentionPolicy((PsiClass)aClass) == RetentionPolicy.RUNTIME) {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
                if (annotationPlace == null) {
                    AddAnnotationPsiFix.$$$reportNull$$$0(30);
                }
                return annotationPlace;
            }
            if (!"java.lang".equals(StringUtil.getPackageName((String)annotation)) && (resolvedBySimpleName = JavaPsiFacade.getInstance((Project)project).getResolveHelper().resolveReferencedClass(StringUtil.getShortName((String)annotation), (PsiElement)modifierListOwner)) != null && resolvedBySimpleName.getManager().areElementsEquivalent((PsiElement)resolvedBySimpleName, (PsiElement)aClass)) {
                ExternalAnnotationsManager.AnnotationPlace annotationPlace = ExternalAnnotationsManager.AnnotationPlace.IN_CODE;
                if (annotationPlace == null) {
                    AddAnnotationPsiFix.$$$reportNull$$$0(31);
                }
                return annotationPlace;
            }
        }
        ExternalAnnotationsManager.AnnotationPlace annotationPlace = annotationsManager.chooseAnnotationsPlaceNoUi((PsiElement)modifierListOwner);
        if (annotationPlace == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(32);
        }
        return annotationPlace;
    }

    @Nullable
    public static PsiAnnotation addPhysicalAnnotationIfAbsent(@NotNull String fqn, @NotNull @NotNull PsiNameValuePair @NotNull [] pairs, @NotNull PsiAnnotationOwner owner) {
        PsiElement modListOwner;
        if (fqn == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(33);
        }
        if (owner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(34);
        }
        if (pairs == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(35);
        }
        if (owner.hasAnnotation(fqn)) {
            return null;
        }
        if (owner instanceof PsiModifierList && (modListOwner = ((PsiModifierList)owner).getParent()) instanceof PsiModifierListOwner) {
            PsiTypeElement typeElement;
            if (ExternalAnnotationsManager.getInstance((Project)modListOwner.getProject()).findExternalAnnotation((PsiModifierListOwner)modListOwner, fqn) != null) {
                return null;
            }
            Object object = modListOwner instanceof PsiMethod ? ((PsiMethod)modListOwner).getReturnTypeElement() : (typeElement = modListOwner instanceof PsiVariable ? ((PsiVariable)modListOwner).getTypeElement() : null);
            while (typeElement != null && typeElement.getType() instanceof PsiArrayType) {
                typeElement = (PsiTypeElement)PsiTreeUtil.getChildOfType((PsiElement)typeElement, PsiTypeElement.class);
            }
            if (typeElement != null && typeElement.getType().hasAnnotation(fqn)) {
                return null;
            }
        }
        return AddAnnotationPsiFix.addPhysicalAnnotationTo(AddAnnotationPsiFix.expandParameterAndAddAnnotation(owner, fqn), pairs);
    }

    public static PsiAnnotation addPhysicalAnnotationTo(String fqn, PsiNameValuePair[] pairs, PsiAnnotationOwner owner) {
        return AddAnnotationPsiFix.addPhysicalAnnotationTo(AddAnnotationPsiFix.expandParameterAndAddAnnotation(owner, fqn), pairs);
    }

    public static PsiAnnotation addPhysicalAnnotationTo(PsiAnnotation inserted, PsiNameValuePair[] pairs) {
        for (PsiNameValuePair pair : pairs) {
            inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
        }
        return inserted;
    }

    @Nullable
    protected PsiAnnotation addAnnotation(PsiAnnotationOwner annotationOwner, String fqn) {
        return AddAnnotationPsiFix.expandParameterAndAddAnnotation(annotationOwner, fqn);
    }

    @NotNull
    public static PsiAnnotation expandParameterAndAddAnnotation(PsiAnnotationOwner annotationOwner, String fqn) {
        if (annotationOwner instanceof PsiModifierList) {
            annotationOwner = AddAnnotationPsiFix.expandParameterIfNecessary((PsiModifierList)annotationOwner);
        }
        PsiAnnotation psiAnnotation = annotationOwner.addAnnotation(fqn);
        if (psiAnnotation == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(36);
        }
        return psiAnnotation;
    }

    @NotNull
    public static PsiModifierList expandParameterIfNecessary(PsiModifierList owner) {
        PsiParameterList list;
        PsiParameter parameter = (PsiParameter)ObjectUtils.tryCast((Object)owner.getParent(), PsiParameter.class);
        if (parameter != null && parameter.getTypeElement() == null && (list = (PsiParameterList)ObjectUtils.tryCast((Object)parameter.getParent(), PsiParameterList.class)) != null && list.getParent() instanceof PsiLambdaExpression) {
            PsiParameterList newList;
            Object[] parameters = list.getParameters();
            int index = ArrayUtil.indexOf((Object[])parameters, (Object)parameter);
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.VAR_LAMBDA_PARAMETER, (PsiElement)list)) {
                String newListText = StreamEx.of((Object[])parameters).map(p -> "var " + p.getName()).joining((CharSequence)",", (CharSequence)"(", (CharSequence)")");
                newList = ((PsiLambdaExpression)JavaPsiFacade.getElementFactory((Project)list.getProject()).createExpressionFromText(newListText + " -> {}", null)).getParameterList();
                newList = (PsiParameterList)new CommentTracker().replaceAndRestoreComments((PsiElement)list, (PsiElement)newList);
            } else {
                newList = LambdaUtil.specifyLambdaParameterTypes((PsiLambdaExpression)((PsiLambdaExpression)list.getParent()));
            }
            if (newList != null) {
                list = newList;
                parameter = list.getParameter(index);
                LOG.assertTrue(parameter != null);
                owner = parameter.getModifierList();
                LOG.assertTrue(owner != null);
            }
        }
        PsiModifierList psiModifierList = owner;
        if (psiModifierList == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(37);
        }
        return psiModifierList;
    }

    public static void removePhysicalAnnotations(@NotNull PsiModifierListOwner owner, String ... fqns) {
        if (owner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(38);
        }
        if (fqns == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(39);
        }
        if (fqns.length == 0) {
            return;
        }
        Set<String> toRemove = Set.of(fqns);
        for (PsiAnnotation annotation : owner.getAnnotations()) {
            if (!toRemove.contains(annotation.getQualifiedName())) continue;
            new CommentTracker().deleteAndRestoreComments((PsiElement)annotation);
        }
        PsiFile psiFile = owner.getContainingFile();
        if (psiFile instanceof PsiJavaFile) {
            PsiJavaFile file = (PsiJavaFile)psiFile;
            JavaCodeStyleManager.getInstance((Project)file.getProject()).removeRedundantImports(file);
        }
    }

    protected String @NotNull [] getAnnotationsToRemove() {
        if (this.myAnnotationsToRemove == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(40);
        }
        return this.myAnnotationsToRemove;
    }

    public static boolean isNullabilityAnnotationApplicable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            AddAnnotationPsiFix.$$$reportNull$$$0(41);
        }
        if (owner instanceof PsiMethod) {
            PsiType returnType = ((PsiMethod)owner).getReturnType();
            return returnType != null && !(returnType instanceof PsiPrimitiveType);
        }
        return !(owner instanceof PsiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 16, 17, 30, 31, 32, 36, 37, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 34: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pairs";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/AddAnnotationPsiFix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "choosePlace";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "expandParameterAndAddAnnotation";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "expandParameterIfNecessary";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationsToRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcText";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 40: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "choosePlace";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addPhysicalAnnotationIfAbsent";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "removePhysicalAnnotations";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityAnnotationApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 16, 17, 30, 31, 32, 36, 37, 40 -> new IllegalStateException(string);
        };
    }
}

