/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.options;

import com.intellij.codeInspection.ui.StringValidatorWithSwingSelector;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.PsiNameHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassValidator
implements StringValidatorWithSwingSelector {
    private final List<String> mySuperClasses;
    private final boolean myAnnotationOnly;
    @NlsContexts.DialogTitle
    private final String myTitle;

    public JavaClassValidator() {
        this(List.of(), false, null);
    }

    private JavaClassValidator(@NotNull List<String> superClasses, boolean annotationOnly, @NlsContexts.DialogTitle @Nullable String title) {
        if (superClasses == null) {
            JavaClassValidator.$$$reportNull$$$0(0);
        }
        this.mySuperClasses = superClasses;
        this.myAnnotationOnly = annotationOnly;
        this.myTitle = title;
    }

    @NotNull
    public JavaClassValidator withSuperClass(String ... superClasses) {
        if (superClasses == null) {
            JavaClassValidator.$$$reportNull$$$0(1);
        }
        return new JavaClassValidator(List.of(superClasses), this.myAnnotationOnly, this.myTitle);
    }

    @NotNull
    public JavaClassValidator withTitle(@NlsContexts.DialogTitle @NotNull String title) {
        if (title == null) {
            JavaClassValidator.$$$reportNull$$$0(2);
        }
        return new JavaClassValidator(this.mySuperClasses, this.myAnnotationOnly, title);
    }

    @NotNull
    public JavaClassValidator annotationsOnly() {
        return new JavaClassValidator(this.mySuperClasses, true, this.myTitle);
    }

    @NotNull
    public String validatorId() {
        return "jvm.class";
    }

    @Nullable
    public String getErrorMessage(@Nullable Project project, @NotNull String className) {
        if (className == null) {
            JavaClassValidator.$$$reportNull$$$0(3);
        }
        if (!PsiNameHelperImpl.getInstance().isQualifiedName(className)) {
            return JavaBundle.message((String)"validator.text.not.valid.class.name", (Object[])new Object[0]);
        }
        if (project == null) {
            return null;
        }
        if (project.isDefault() || DumbService.isDumb((Project)project)) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
        if (psiClass == null) {
            return JavaBundle.message((String)"validator.text.class.not.found", (Object[])new Object[0]);
        }
        return this.checkClass(psiClass);
    }

    @Nullable
    @Nls
    private String checkClass(PsiClass psiClass) {
        if (this.myAnnotationOnly && !psiClass.isAnnotationType()) {
            return JavaBundle.message((String)"validator.text.no.annotation", (Object[])new Object[0]);
        }
        if (!this.mySuperClasses.isEmpty() && !ContainerUtil.exists(this.mySuperClasses, superClass -> InheritanceUtil.isInheritor((PsiClass)psiClass, (String)superClass))) {
            return JavaBundle.message((String)"validator.text.wrong.superclass", (Object[])new Object[0]);
        }
        return null;
    }

    @Nullable
    public String select(@NotNull Project project) {
        if (project == null) {
            JavaClassValidator.$$$reportNull$$$0(4);
        }
        if (project.isDefault() || DumbService.isDumb((Project)project)) {
            return null;
        }
        String title = this.myTitle != null ? this.myTitle : (this.myAnnotationOnly ? JavaBundle.message((String)"special.annotations.list.annotation.class", (Object[])new Object[0]) : JavaBundle.message((String)"dialog.title.choose.class", (Object[])new Object[0]));
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createWithInnerClassesScopeChooser(title, GlobalSearchScope.allScope((Project)project), aClass -> this.checkClass(aClass) == null, null);
        chooser.showDialog();
        PsiClass selected = chooser.getSelected();
        return selected == null ? null : selected.getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/options/JavaClassValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withSuperClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

