/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.RemoveSuppressWarningAction;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaInspectionSuppressor
implements InspectionSuppressor,
RedundantSuppressionDetector {
    private static final Logger LOG = Logger.getInstance(JavaInspectionSuppressor.class);

    JavaInspectionSuppressor() {
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(1);
        }
        return JavaSuppressionUtil.getElementToolSuppressedIn(element, toolId) != null;
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        HighlightDisplayKey displayKey;
        if (toolId == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((displayKey = HighlightDisplayKey.findById((String)toolId)) != null, (Object)("Display key is null for `" + toolId + "` tool"));
        SuppressQuickFix[] suppressQuickFixArray = SuppressManager.getInstance().createBatchSuppressActions(displayKey);
        if (suppressQuickFixArray == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    public String getSuppressionIds(@NotNull PsiElement element) {
        if (element == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(4);
        }
        return JavaSuppressionUtil.getSuppressedInspectionIdsIn(element);
    }

    public boolean isSuppressionFor(@NotNull PsiElement elementWithSuppression, @NotNull PsiElement place, @NotNull String toolId) {
        PsiElement suppressionScope;
        if (elementWithSuppression == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(5);
        }
        if (place == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(6);
        }
        if (toolId == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(7);
        }
        return (suppressionScope = JavaSuppressionUtil.getElementToolSuppressedIn(place, toolId)) != null && PsiTreeUtil.isAncestor((PsiElement)elementWithSuppression, (PsiElement)suppressionScope, (boolean)false);
    }

    @Nullable
    public TextRange getHighlightingRange(@NotNull PsiElement elementWithSuppression, @NotNull String toolId) {
        PsiElement annotationOrTagElement;
        if (elementWithSuppression == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(8);
        }
        if (toolId == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(9);
        }
        PsiElement psiElement = annotationOrTagElement = elementWithSuppression instanceof PsiComment ? null : SuppressManager.getInstance().getElementToolSuppressedIn(elementWithSuppression, toolId);
        if (annotationOrTagElement != null) {
            int shiftInParent = annotationOrTagElement.getTextRange().getStartOffset() - elementWithSuppression.getTextRange().getStartOffset();
            if (shiftInParent < 0) {
                return this.getRangeFallback(elementWithSuppression, toolId);
            }
            return Objects.requireNonNull(super.getHighlightingRange(annotationOrTagElement, toolId)).shiftRight(shiftInParent);
        }
        return this.getRangeFallback(elementWithSuppression, toolId);
    }

    @Nullable
    private TextRange getRangeFallback(@NotNull PsiElement elementWithSuppression, @NotNull String toolId) {
        PsiNameIdentifierOwner owner;
        PsiElement identifier;
        if (elementWithSuppression == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(10);
        }
        if (toolId == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(11);
        }
        if (elementWithSuppression instanceof PsiNameIdentifierOwner && (identifier = (owner = (PsiNameIdentifierOwner)elementWithSuppression).getNameIdentifier()) != null) {
            return identifier.getTextRange().shiftLeft(elementWithSuppression.getTextRange().getStartOffset());
        }
        return super.getHighlightingRange(elementWithSuppression, toolId);
    }

    @NotNull
    public LocalQuickFix createRemoveRedundantSuppressionFix(@NotNull String toolId) {
        if (toolId == null) {
            JavaInspectionSuppressor.$$$reportNull$$$0(12);
        }
        return new RemoveSuppressWarningAction(toolId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/JavaInspectionSuppressor";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementWithSuppression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/JavaInspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionIds";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressionFor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRangeFallback";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveRedundantSuppressionFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

