/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SafeVarargsOnNonReifiableTypeInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public @NotNull Set<@NotNull JavaFeature> requiredFeatures() {
        Set<JavaFeature> set = Set.of(JavaFeature.ANNOTATIONS);
        if (set == null) {
            SafeVarargsOnNonReifiableTypeInspection.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SafeVarargsOnNonReifiableTypeInspection.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(this){

            public void visitParameter(@NotNull PsiParameter parameter) {
                if (parameter == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitParameter(parameter);
                if (!parameter.isVarArgs()) {
                    return;
                }
                PsiElement psiElement = parameter.getDeclarationScope();
                if (!(psiElement instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)psiElement;
                if (!method.getModifierList().hasAnnotation("java.lang.SafeVarargs")) {
                    return;
                }
                if (!method.isVarArgs() || !GenericsUtil.isSafeVarargsNoOverridingCondition((PsiMethod)method)) {
                    return;
                }
                PsiEllipsisType ellipsisType = (PsiEllipsisType)parameter.getType();
                PsiType componentType = ellipsisType.getComponentType();
                if (JavaGenericsUtil.isReifiableType((PsiType)componentType)) {
                    PsiTypeElement element = Objects.requireNonNull(parameter.getTypeElement());
                    holder.registerProblem((PsiElement)element, JavaAnalysisBundle.message((String)"safe.varargs.on.reifiable.type", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/SafeVarargsOnNonReifiableTypeInspection$1", "visitParameter"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SafeVarargsOnNonReifiableTypeInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredFeatures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SafeVarargsOnNonReifiableTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

