/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

abstract class DataValue
implements Value {
    public static final DataValue[] EMPTY = new DataValue[0];
    private final int myHash;
    static final DataValue ThisDataValue = new DataValue(-1){

        public int getSize() {
            return 1;
        }

        @Override
        public ContractReturnValue asContractReturnValue() {
            return ContractReturnValue.returnThis();
        }

        public String toString() {
            return "DataValue: this";
        }
    };
    static final DataValue LocalDataValue = new DataValue(-2){

        public int getSize() {
            return 1;
        }

        @Override
        public ContractReturnValue asContractReturnValue() {
            return ContractReturnValue.returnNew();
        }

        public String toString() {
            return "DataValue: local";
        }
    };
    static final DataValue OwnedDataValue = new DataValue(-3){

        public int getSize() {
            return 1;
        }

        public String toString() {
            return "DataValue: owned";
        }
    };
    static final DataValue UnknownDataValue1 = new DataValue(-4){

        public int getSize() {
            return 1;
        }

        public String toString() {
            return "DataValue: unknown (1-slot)";
        }
    };
    static final DataValue UnknownDataValue2 = new DataValue(-5){

        public int getSize() {
            return 2;
        }

        public String toString() {
            return "DataValue: unknown (2-slot)";
        }
    };

    DataValue(int hash) {
        this.myHash = hash;
    }

    public final int hashCode() {
        return this.myHash;
    }

    Stream<EKey> dependencies() {
        return Stream.empty();
    }

    void processDependencies(Consumer<EKey> consumer) {
    }

    public ContractReturnValue asContractReturnValue() {
        return ContractReturnValue.returnAny();
    }

    static class ReturnDataValue
    extends DataValue {
        final EKey key;

        ReturnDataValue(EKey key) {
            super(key.hashCode());
            this.key = key;
        }

        public int getSize() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReturnDataValue that = (ReturnDataValue)o;
            return this.key.equals(that.key);
        }

        @Override
        Stream<EKey> dependencies() {
            return Stream.of(this.key);
        }

        @Override
        void processDependencies(Consumer<EKey> consumer) {
            consumer.accept(this.key);
        }

        public String toString() {
            return "Return of: " + String.valueOf(this.key);
        }
    }

    static final class ParameterDataValue
    extends DataValue {
        static final ParameterDataValue PARAM0 = new ParameterDataValue(0);
        static final ParameterDataValue PARAM1 = new ParameterDataValue(1);
        static final ParameterDataValue PARAM2 = new ParameterDataValue(2);
        final int n;

        private ParameterDataValue(int n) {
            super(n);
            this.n = n;
        }

        @Override
        public ContractReturnValue asContractReturnValue() {
            return ContractReturnValue.returnParameter(this.n);
        }

        static ParameterDataValue create(int n) {
            return switch (n) {
                case 0 -> PARAM0;
                case 1 -> PARAM1;
                case 2 -> PARAM2;
                default -> new ParameterDataValue(n);
            };
        }

        public int getSize() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterDataValue that = (ParameterDataValue)o;
            return this.n == that.n;
        }

        public String toString() {
            return "DataValue: arg#" + this.n;
        }
    }
}

