/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.DataInterpreter;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LiteAnalyzer;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

public final class PurityAnalysis {
    static final int UN_ANALYZABLE_FLAG = 1792;

    @Nullable
    static Equation analyze(Member method, MethodNode methodNode, boolean stable, boolean jsr) {
        EKey key = new EKey(method, Direction.Pure, stable);
        Effects hardCodedSolution = HardCodedPurity.getInstance().getHardCodedSolution(method);
        if (hardCodedSolution != null) {
            return new Equation(key, hardCodedSolution);
        }
        if ((methodNode.access & 0x700) != 0) {
            return null;
        }
        if (methodNode.instructions.size() > 1000) {
            return null;
        }
        DataInterpreter dataInterpreter = new DataInterpreter(methodNode);
        try {
            if (jsr) {
                new Analyzer((Interpreter)dataInterpreter).analyze("this", methodNode);
            } else {
                new LiteAnalyzer<DataValue>(dataInterpreter).analyze("this", methodNode);
            }
        }
        catch (AnalyzerException e) {
            return null;
        }
        EffectQuantum[] quanta = dataInterpreter.effects;
        DataValue returnValue = dataInterpreter.returnValue == null ? DataValue.UnknownDataValue1 : dataInterpreter.returnValue;
        ArrayList<EffectQuantum> effects = new ArrayList<EffectQuantum>();
        for (EffectQuantum effectQuantum : quanta) {
            if (effectQuantum == null) continue;
            if (effectQuantum == EffectQuantum.TopEffectQuantum) {
                return returnValue == DataValue.UnknownDataValue1 ? null : new Equation(key, new Effects(returnValue, Effects.TOP_EFFECTS));
            }
            effects.add(effectQuantum);
        }
        return new Equation(key, new Effects(returnValue, Set.copyOf(effects)));
    }
}

