/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;

public final class RichControlFlow {
    public final ControlFlowGraph controlFlow;
    public final DFSTree dfsTree;

    public RichControlFlow(ControlFlowGraph controlFlow, DFSTree dfsTree) {
        this.controlFlow = controlFlow;
        this.dfsTree = dfsTree;
    }

    public boolean reducible() {
        if (this.dfsTree.isBackEmpty()) {
            return true;
        }
        int size = this.controlFlow.transitions.length;
        boolean[] loopEnters = this.dfsTree.loopEnters;
        IntOpenHashSet[] cycleIncoming = new IntOpenHashSet[size];
        IntArrayList[] nonCycleIncoming = new IntArrayList[size];
        int[] collapsedTo = new int[size];
        int[] queue = new int[size];
        for (int i = 0; i < size; ++i) {
            if (loopEnters[i]) {
                cycleIncoming[i] = new IntOpenHashSet();
            }
            nonCycleIncoming[i] = new IntArrayList();
            collapsedTo[i] = i;
        }
        this.dfsTree.iterateBack((from, to) -> cycleIncoming[to].add(from));
        this.dfsTree.iterateNonBack((from, to) -> nonCycleIncoming[to].add(from));
        for (int w = size - 1; w >= 0; --w) {
            int top = 0;
            IntOpenHashSet p = cycleIncoming[w];
            if (p == null) continue;
            IntIterator it = p.iterator();
            while (it.hasNext()) {
                queue[top++] = it.nextInt();
            }
            while (top > 0) {
                int x = queue[--top];
                IntArrayList incoming = nonCycleIncoming[x];
                for (int i = 0; i < incoming.size(); ++i) {
                    int y1 = collapsedTo[incoming.getInt(i)];
                    if (!this.dfsTree.isDescendant(y1, w)) {
                        return false;
                    }
                    if (y1 == w || !p.add(y1)) continue;
                    queue[top++] = y1;
                }
            }
            it = p.iterator();
            while (it.hasNext()) {
                collapsedTo[it.next().intValue()] = w;
            }
        }
        return true;
    }
}

