/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnknownGuardInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.concurrency.annotation.issues", (Object[])new Object[0]);
        if (string == null) {
            UnknownGuardInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "UnknownGuard";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnknownGuardInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (Visitor.isValidGuardText(guardValue, (PsiElement)annotation)) {
                return;
            }
            PsiAnnotationMemberValue member = annotation.findAttributeValue("value");
            if (member == null) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)member, JavaAnalysisBundle.message((String)"unknown.guardedby.reference.ref.loc", (Object[])new Object[0]), new LocalQuickFix[0]);
        }

        private static boolean isValidGuardText(@Nullable String guardText, @NotNull PsiElement context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (guardText == null || "itself".equals(guardText)) {
                return false;
            }
            try {
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
                PsiExpression expression = facade.getElementFactory().createExpressionFromText(guardText, context);
                return Visitor.isValidGuard(expression, context);
            }
            catch (IncorrectOperationException ignore) {
                return false;
            }
        }

        private static boolean isValidGuard(PsiExpression expression, PsiElement context) {
            if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                JavaResolveResult result = referenceExpression.advancedResolve(false);
                if (!result.isAccessible() || !result.isValidResult()) {
                    return false;
                }
                PsiElement target = result.getElement();
                PsiElement parent = expression.getParent();
                if (!(parent instanceof DummyHolder)) {
                    return target != null;
                }
                if (!(target instanceof PsiField)) {
                    return false;
                }
                PsiField field = (PsiField)target;
                PsiType type = field.getType();
                if (type instanceof PsiPrimitiveType) {
                    return false;
                }
                PsiExpression qualifier = referenceExpression.getQualifierExpression();
                return qualifier == null || Visitor.isValidGuard(qualifier, context);
            }
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                if (!argumentList.isEmpty()) {
                    return false;
                }
                JavaResolveResult result = methodCallExpression.resolveMethodGenerics();
                if (!result.isAccessible() || !result.isValidResult()) {
                    return false;
                }
                PsiElement element = result.getElement();
                if (!(element instanceof PsiMethod)) {
                    return false;
                }
                PsiMethod method = (PsiMethod)element;
                PsiType type = method.getReturnType();
                if (type instanceof PsiPrimitiveType) {
                    return false;
                }
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                return qualifierExpression == null || Visitor.isValidGuard(qualifierExpression, context);
            }
            if (expression instanceof PsiThisExpression) {
                PsiThisExpression thisExpression = (PsiThisExpression)expression;
                PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
                if (qualifier == null) {
                    return true;
                }
                JavaResolveResult result = qualifier.advancedResolve(false);
                if (!result.isValidResult() || !result.isAccessible()) {
                    return false;
                }
                PsiElement target = result.getElement();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)target;
                return InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)aClass, (PsiElement)context, (boolean)false, (boolean)false);
            }
            if (expression instanceof PsiClassObjectAccessExpression) {
                PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)expression;
                PsiTypeElement operand = classObjectAccessExpression.getOperand();
                PsiType type = operand.getType();
                if (!(type instanceof PsiClassType)) {
                    return false;
                }
                PsiClassType classType = (PsiClassType)type;
                PsiClass target = classType.resolve();
                return target != null;
            }
            return false;
        }

        public void visitDocTag(@NotNull PsiDocTag psiDocTag) {
            if (psiDocTag == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if (Visitor.isValidGuardText(guardValue, (PsiElement)psiDocTag)) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, JavaAnalysisBundle.message((String)"unknown.guardedby.reference.0.loc", (Object[])new Object[]{guardValue}), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiDocTag";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/UnknownGuardInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValidGuardText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDocTag";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

