/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaCallState;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContractReturnValue {
    private static final int PARAMETER_ORDINAL_BASE = 10;
    private static final int MAX_SUPPORTED_PARAMETER = 100;
    private static final Validator NOT_CONSTRUCTOR = method -> method.isConstructor() ? JavaAnalysisBundle.message((String)"contract.return.validator.not.applicable.for.constructor", (Object[])new Object[0]) : null;
    private static final Validator NOT_STATIC = method -> method.hasModifierProperty("static") ? JavaAnalysisBundle.message((String)"contract.return.validator.not.applicable.static", (Object[])new Object[0]) : null;
    private static final Validator NOT_PRIMITIVE_RETURN = method -> {
        PsiType returnType = method.getReturnType();
        return returnType instanceof PsiPrimitiveType ? JavaAnalysisBundle.message((String)"contract.return.validator.not.applicable.primitive", (Object[])new Object[]{returnType.getPresentableText()}) : null;
    };
    private static final Validator BOOLEAN_RETURN = method -> PsiTypes.booleanType().equals((Object)method.getReturnType()) ? null : JavaAnalysisBundle.message((String)"contract.return.validator.return.type.must.be.boolean", (Object[])new Object[0]);
    @NotNull
    private final String myName;
    private final int myOrdinal;
    private static final ContractReturnValue ANY_VALUE = new ContractReturnValue("_", 0){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            return callState.myReturnValue;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            return true;
        }
    };
    private static final ContractReturnValue FAIL_VALUE = new ContractReturnValue("fail", 5){

        @Override
        Stream<Validator> validators() {
            return Stream.empty();
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            return factory.fromDfType(DfType.FAIL);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            return false;
        }
    };
    private static final ContractReturnValue NULL_VALUE = new ContractReturnValue("null", 1){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            return factory.fromDfType((DfType)DfTypes.NULL);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            return state.getDfType(value).isSuperType((DfType)DfTypes.NULL);
        }
    };
    private static final ContractReturnValue NOT_NULL_VALUE = new ContractReturnValue("!null", 2){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            return 4.merge(callState.myReturnValue, (DfaValue)factory.fromDfType((DfType)DfTypes.NOT_NULL_OBJECT), callState.myMemoryState);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            return state.getDfType(value) != DfTypes.NULL;
        }
    };
    private static final ContractReturnValue NEW_VALUE = new ContractReturnValue("new", 6){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_PRIMITIVE_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            DfType dfType = callState.myMemoryState.getDfType(callState.myReturnValue);
            dfType = dfType.meet((DfType)DfTypes.NOT_NULL_OBJECT);
            if (callState.myCallArguments.myMutation.isPure()) {
                boolean unmodifiableView;
                boolean bl = unmodifiableView = Mutability.fromDfType(dfType) == Mutability.UNMODIFIABLE_VIEW;
                if (!unmodifiableView) {
                    dfType = dfType.meet((DfType)DfTypes.LOCAL_OBJECT);
                }
            }
            return 5.merge(callState.myReturnValue, (DfaValue)factory.fromDfType(dfType), callState.myMemoryState);
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            return state.getDfType(value) != DfTypes.NULL;
        }
    };
    private static final ContractReturnValue THIS_VALUE = new ContractReturnValue("this", 7){

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, NOT_STATIC, NOT_PRIMITIVE_RETURN, method -> {
                PsiClass aClass;
                PsiType returnType = method.getReturnType();
                if (returnType instanceof PsiClassType && (aClass = method.getContainingClass()) != null && JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(aClass).isConvertibleFrom(returnType)) {
                    return null;
                }
                return JavaAnalysisBundle.message((String)"contract.return.validator.method.return.incompatible.with.method.containing.class", (Object[])new Object[0]);
            });
        }

        @Override
        @Nullable
        public PsiExpression findPlace(@NotNull PsiCallExpression call) {
            if (call == null) {
                6.$$$reportNull$$$0(0);
            }
            if (call instanceof PsiMethodCallExpression) {
                return ExpressionUtils.getEffectiveQualifier(((PsiMethodCallExpression)call).getMethodExpression());
            }
            return null;
        }

        @Override
        public boolean isNotNull() {
            return true;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            DfaValue qualifier = callState.myCallArguments.myQualifier;
            if (qualifier != null && !DfaTypeValue.isUnknown((DfaValue)qualifier)) {
                return 6.merge(callState.myReturnValue, qualifier, callState.myMemoryState);
            }
            return 6.merge(callState.myReturnValue, (DfaValue)factory.fromDfType((DfType)DfTypes.NOT_NULL_OBJECT), callState.myMemoryState);
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            return state.getDfType(value) != DfTypes.NULL;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/ContractReturnValue$6", "findPlace"));
        }
    };

    @Nullable
    public PsiExpression findPlace(@NotNull PsiCallExpression call) {
        if (call == null) {
            ContractReturnValue.$$$reportNull$$$0(0);
        }
        return null;
    }

    private ContractReturnValue(@NotNull String name, int ordinal) {
        if (name == null) {
            ContractReturnValue.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myOrdinal = ordinal;
    }

    public int hashCode() {
        return this.myOrdinal;
    }

    public String toString() {
        return this.myName;
    }

    @InspectionMessage
    public final String getMethodCompatibilityProblem(PsiMethod method) {
        return this.validators().map(fn -> (String)fn.apply(method)).filter(Objects::nonNull).findFirst().map((JavaAnalysisBundle.message((String)"contract.return.value.validation.prefix", (Object[])new Object[]{this}) + " ")::concat).orElse(null);
    }

    public final boolean isMethodCompatible(PsiMethod method) {
        return this.validators().map(fn -> (String)fn.apply(method)).allMatch(Objects::isNull);
    }

    abstract Stream<Validator> validators();

    public ContractReturnValue intersect(ContractReturnValue other) {
        if (this.equals(other) || other == ANY_VALUE) {
            return this;
        }
        if (this == ANY_VALUE) {
            return other;
        }
        if (this.isNotNull() && other.isNotNull()) {
            return NOT_NULL_VALUE;
        }
        return FAIL_VALUE;
    }

    public boolean isSuperValueOf(ContractReturnValue value) {
        return this == value || this == ANY_VALUE || this == NOT_NULL_VALUE && value.isNotNull();
    }

    static DfaValue merge(DfaValue defaultValue, DfaValue newValue, DfaMemoryState memState) {
        DfType newType;
        if (defaultValue == null || DfaTypeValue.isUnknown((DfaValue)defaultValue)) {
            return newValue;
        }
        if (newValue == null || DfaTypeValue.isUnknown((DfaValue)newValue)) {
            return defaultValue;
        }
        newValue = DfaUtil.boxUnbox(newValue, defaultValue.getDfType());
        DfType defaultType = memState.getDfType(defaultValue);
        DfType result = defaultType.meet(newType = memState.getDfType(newValue));
        if (result == DfType.BOTTOM) {
            return newValue;
        }
        if (newValue instanceof DfaVariableValue) {
            memState.meetDfType(newValue, result);
            return newValue;
        }
        if (defaultValue instanceof DfaWrappedValue) {
            if (newType.isSuperType(defaultValue.getDfType())) {
                return defaultValue;
            }
            DerivedVariableDescriptor field = ((DfaWrappedValue)defaultValue).getSpecialField();
            return defaultValue.getFactory().getWrapperFactory().createWrapper(result.getBasicType(), field, (DfaValue)((DfaWrappedValue)defaultValue).getWrappedValue());
        }
        if (defaultValue instanceof DfaVariableValue) {
            memState.meetDfType(defaultValue, result);
            return defaultValue;
        }
        return defaultValue.getFactory().fromDfType(result);
    }

    public abstract DfaValue getDfaValue(DfaValueFactory var1, DfaCallState var2);

    public abstract boolean isValueCompatible(DfaMemoryState var1, DfaValue var2);

    public int ordinal() {
        return this.myOrdinal;
    }

    public boolean isNotNull() {
        return false;
    }

    public boolean isNull() {
        return this == NULL_VALUE;
    }

    public boolean isFail() {
        return this == FAIL_VALUE;
    }

    public boolean isBoolean() {
        return this instanceof BooleanReturnValue;
    }

    @NotNull
    public static ContractReturnValue valueOf(int ordinal) {
        ContractReturnValue contractReturnValue = switch (ordinal) {
            case 0, 1 -> ContractReturnValue.returnNull();
            case 2 -> ContractReturnValue.returnNotNull();
            case 3 -> ContractReturnValue.returnTrue();
            case 4 -> ContractReturnValue.returnFalse();
            case 5 -> ContractReturnValue.fail();
            case 6 -> ContractReturnValue.returnNew();
            case 7 -> ContractReturnValue.returnThis();
            default -> ordinal >= 10 && ordinal <= 110 ? ContractReturnValue.returnParameter(ordinal - 10) : ContractReturnValue.returnAny();
        };
        if (contractReturnValue == null) {
            ContractReturnValue.$$$reportNull$$$0(2);
        }
        return contractReturnValue;
    }

    @Nullable
    public static ContractReturnValue valueOf(@NotNull String value) {
        if (value == null) {
            ContractReturnValue.$$$reportNull$$$0(3);
        }
        return switch (value) {
            case "_" -> {
                ContractReturnValue var3_3;
                yield var3_3 = ContractReturnValue.returnAny();
            }
            case "fail" -> {
                ContractReturnValue var3_4;
                yield var3_4 = ContractReturnValue.fail();
            }
            case "true" -> {
                BooleanReturnValue var3_5 = ContractReturnValue.returnTrue();
                yield var3_5;
            }
            case "false" -> {
                BooleanReturnValue var3_6 = ContractReturnValue.returnFalse();
                yield var3_6;
            }
            case "null" -> {
                ContractReturnValue var3_7;
                yield var3_7 = ContractReturnValue.returnNull();
            }
            case "!null" -> {
                ContractReturnValue var3_8;
                yield var3_8 = ContractReturnValue.returnNotNull();
            }
            case "new" -> {
                ContractReturnValue var3_9;
                yield var3_9 = ContractReturnValue.returnNew();
            }
            case "this" -> {
                ContractReturnValue var3_10;
                yield var3_10 = ContractReturnValue.returnThis();
            }
            default -> {
                if (value.startsWith("param")) {
                    String suffix = value.substring("param".length());
                    try {
                        int paramNumber = Integer.parseInt(suffix) - 1;
                        if (paramNumber >= 0 && paramNumber <= 100) {
                            ParameterReturnValue var3_11 = new ParameterReturnValue(paramNumber);
                            yield var3_11;
                        }
                    }
                    catch (NumberFormatException var5_15) {
                        // empty catch block
                    }
                }
                Object var3_12 = null;
                yield var3_12;
            }
        };
    }

    public static ContractReturnValue returnAny() {
        return ANY_VALUE;
    }

    public static ContractReturnValue fail() {
        return FAIL_VALUE;
    }

    public static BooleanReturnValue returnBoolean(boolean value) {
        return value ? ContractReturnValue.returnTrue() : ContractReturnValue.returnFalse();
    }

    public static BooleanReturnValue returnTrue() {
        return BooleanReturnValue.TRUE_VALUE;
    }

    public static BooleanReturnValue returnFalse() {
        return BooleanReturnValue.FALSE_VALUE;
    }

    public static ContractReturnValue returnNull() {
        return NULL_VALUE;
    }

    public static ContractReturnValue returnNotNull() {
        return NOT_NULL_VALUE;
    }

    public static ContractReturnValue returnNew() {
        return NEW_VALUE;
    }

    public static ContractReturnValue returnThis() {
        return THIS_VALUE;
    }

    public static ContractReturnValue returnParameter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative parameter: " + n);
        }
        if (n > 100) {
            return ANY_VALUE;
        }
        return new ParameterReturnValue(n);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractReturnValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractReturnValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "valueOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPlace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "valueOf";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static final class BooleanReturnValue
    extends ContractReturnValue {
        static final BooleanReturnValue TRUE_VALUE = new BooleanReturnValue(true, 3);
        static final BooleanReturnValue FALSE_VALUE = new BooleanReturnValue(false, 4);
        private final boolean myValue;

        private BooleanReturnValue(boolean value, int ordinal) {
            super(String.valueOf(value), ordinal);
            this.myValue = value;
        }

        public boolean getValue() {
            return this.myValue;
        }

        public BooleanReturnValue negate() {
            return this.myValue ? FALSE_VALUE : TRUE_VALUE;
        }

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, BOOLEAN_RETURN);
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            return DfaUtil.boxUnbox((DfaValue)factory.fromDfType((DfType)DfTypes.booleanValue(this.myValue)), callState.myReturnValue.getDfType());
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            DfType type = DfaUtil.getUnboxedDfType(state, value);
            return type.isSuperType((DfType)DfTypes.booleanValue(this.myValue));
        }
    }

    public static final class ParameterReturnValue
    extends ContractReturnValue {
        private final int myParamNumber;

        public ParameterReturnValue(int n) {
            super("param" + (n + 1), n + 10);
            this.myParamNumber = n;
        }

        public int getParameterNumber() {
            return this.myParamNumber;
        }

        @Override
        @Nullable
        public PsiExpression findPlace(@NotNull PsiCallExpression call) {
            if (call == null) {
                ParameterReturnValue.$$$reportNull$$$0(0);
            }
            int number = this.getParameterNumber();
            PsiExpressionList argumentList = call.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length <= number) {
                return null;
            }
            if (args.length == number + 1 && MethodCallUtils.isVarArgCall((PsiCall)call)) {
                return null;
            }
            return args[number];
        }

        @Override
        Stream<Validator> validators() {
            return Stream.of(NOT_CONSTRUCTOR, method -> {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length <= this.myParamNumber) {
                    return JavaAnalysisBundle.message((String)"contract.return.validator.too.few.parameters", (Object[])new Object[]{parameters.length});
                }
                PsiType parameterType = parameters[this.myParamNumber].getType();
                PsiType returnType = method.getReturnType();
                if (returnType != null && !returnType.isConvertibleFrom(parameterType)) {
                    return JavaAnalysisBundle.message((String)"contract.return.validator.incompatible.return.parameter.type", (Object[])new Object[]{returnType.getPresentableText(), parameterType.getPresentableText()});
                }
                return null;
            });
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ParameterReturnValue && ((ParameterReturnValue)obj).myParamNumber == this.myParamNumber;
        }

        @Override
        public DfaValue getDfaValue(DfaValueFactory factory, DfaCallState callState) {
            if (callState.myCallArguments.myArguments != null && callState.myCallArguments.myArguments.length > this.myParamNumber) {
                DfaValue argument = callState.myCallArguments.myArguments[this.myParamNumber];
                return ParameterReturnValue.merge(callState.myReturnValue, argument, callState.myMemoryState);
            }
            return callState.myReturnValue;
        }

        @Override
        public boolean isValueCompatible(DfaMemoryState state, DfaValue value) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/ContractReturnValue$ParameterReturnValue", "findPlace"));
        }
    }

    private static interface Validator
    extends Function<PsiMethod, String> {
    }
}

