/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.ClassData;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceInterpreter;
import com.intellij.codeInspection.dataFlow.inference.JavaSourceInference;
import com.intellij.codeInspection.dataFlow.inference.MethodData;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceVisitor;
import com.intellij.codeInspection.dataFlow.inference.ParameterNullityInferenceKt;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceVisitor;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.RecursiveLighterASTNodeWalkingVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J$\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00102\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020&0%H\u0002J<\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010(\u001a\u00020\u00102\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR-\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R-\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00160\u000fj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0016`\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014\u00a8\u00062"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/InferenceVisitor;", "Lcom/intellij/psi/impl/source/tree/RecursiveLighterASTNodeWalkingVisitor;", "tree", "Lcom/intellij/lang/LighterAST;", "<init>", "(Lcom/intellij/lang/LighterAST;)V", "getTree", "()Lcom/intellij/lang/LighterAST;", "methodIndex", "", "getMethodIndex", "()I", "setMethodIndex", "(I)V", "classData", "Ljava/util/HashMap;", "Lcom/intellij/lang/LighterASTNode;", "Lcom/intellij/codeInspection/dataFlow/inference/ClassData;", "Lkotlin/collections/HashMap;", "getClassData", "()Ljava/util/HashMap;", "result", "Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "getResult", "visitNode", "", "element", "calcClassData", "aClass", "getInferenceMode", "Lcom/intellij/codeInspection/dataFlow/inference/JavaSourceInference$InferenceMode;", "method", "clsData", "calcData", "walkMethodBody", "root", "processor", "Lkotlin/Function1;", "", "createData", "body", "contracts", "", "Lcom/intellij/codeInspection/dataFlow/inference/PreContract;", "methodReturn", "Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "purity", "Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "notNullParams", "Ljava/util/BitSet;", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nContractInferenceIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContractInferenceIndex.kt\ncom/intellij/codeInspection/dataFlow/inference/InferenceVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n1#2:267\n*E\n"})
final class InferenceVisitor
extends RecursiveLighterASTNodeWalkingVisitor {
    @NotNull
    private final LighterAST tree;
    private int methodIndex;
    @NotNull
    private final HashMap<LighterASTNode, ClassData> classData;
    @NotNull
    private final HashMap<Integer, MethodData> result;

    public InferenceVisitor(@NotNull LighterAST tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        super(tree);
        this.tree = tree;
        this.classData = new HashMap();
        this.result = new HashMap();
    }

    @NotNull
    public final LighterAST getTree() {
        return this.tree;
    }

    public final int getMethodIndex() {
        return this.methodIndex;
    }

    public final void setMethodIndex(int n) {
        this.methodIndex = n;
    }

    @NotNull
    public final HashMap<LighterASTNode, ClassData> getClassData() {
        return this.classData;
    }

    @NotNull
    public final HashMap<Integer, MethodData> getResult() {
        return this.result;
    }

    public void visitNode(@NotNull LighterASTNode element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IElementType iElementType = element.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.CLASS) || Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.ANONYMOUS_CLASS)) {
            ((Map)this.classData).put(element, this.calcClassData(element));
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)JavaElementType.METHOD)) {
            MethodData methodData = this.calcData(element);
            if (methodData != null) {
                MethodData data = methodData;
                boolean bl = false;
                ((Map)this.result).put(this.methodIndex, data);
            }
            int n = this.methodIndex;
            this.methodIndex = n + 1;
        }
        if (JavaLightStubBuilder.isCodeBlockWithoutStubs((LighterASTNode)element)) {
            return;
        }
        super.visitNode(element);
    }

    private final ClassData calcClassData(LighterASTNode aClass) {
        Object object;
        boolean hasSuper = Intrinsics.areEqual((Object)aClass.getTokenType(), (Object)JavaElementType.ANONYMOUS_CLASS);
        boolean isFinal = Intrinsics.areEqual((Object)aClass.getTokenType(), (Object)JavaElementType.ANONYMOUS_CLASS);
        LighterASTNode parent = this.tree.getParent(aClass);
        boolean onlyLocalInheritors = parent != null && Intrinsics.areEqual((Object)parent.getTokenType(), (Object)JavaElementType.DECLARATION_STATEMENT);
        HashMap fieldModifiers = new HashMap();
        ArrayList<LighterASTNode> initializers = new ArrayList<LighterASTNode>();
        for (LighterASTNode child : this.tree.getChildren(aClass)) {
            LighterASTNode body;
            LighterASTNode modifiers;
            boolean isStatic;
            object = child.getTokenType();
            if (Intrinsics.areEqual((Object)object, (Object)JavaTokenType.RECORD_KEYWORD) || Intrinsics.areEqual((Object)object, (Object)JavaTokenType.ENUM_KEYWORD)) {
                isFinal = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)JavaElementType.MODIFIER_LIST)) {
                boolean bl = isFinal = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaTokenType.FINAL_KEYWORD) != null;
                if (onlyLocalInheritors) continue;
                onlyLocalInheritors = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaTokenType.PRIVATE_KEYWORD) != null;
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)JavaElementType.ENUM_CONSTANT)) {
                isFinal = isFinal && LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.ENUM_CONSTANT_INITIALIZER) == null;
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)JavaElementType.EXTENDS_LIST)) {
                if (LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.JAVA_CODE_REFERENCE) == null) continue;
                hasSuper = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)JavaElementType.FIELD)) {
                LighterASTNode initializer;
                String fieldName = JavaLightTreeUtil.getNameIdentifierText((LighterAST)this.tree, (LighterASTNode)child);
                if (fieldName == null) continue;
                LighterASTNode modifiers2 = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.MODIFIER_LIST);
                ((Map)fieldModifiers).put(fieldName, modifiers2);
                boolean isStatic2 = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers2, (IElementType)JavaTokenType.STATIC_KEYWORD) != null;
                if (isStatic2 || (initializer = JavaLightTreeUtil.findExpressionChild((LighterAST)this.tree, (LighterASTNode)child)) == null) continue;
                initializers.add(initializer);
                continue;
            }
            if (!Intrinsics.areEqual((Object)object, (Object)JavaElementType.CLASS_INITIALIZER) || (isStatic = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)(modifiers = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)JavaElementType.MODIFIER_LIST)), (IElementType)JavaTokenType.STATIC_KEYWORD) != null) || (body = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)child, (IElementType)((IElementType)JavaElementType.CODE_BLOCK))) == null) continue;
            initializers.add(body);
        }
        boolean pureInitializer = true;
        if (!((Collection)initializers).isEmpty()) {
            PurityInferenceVisitor visitor2 = new PurityInferenceVisitor(this.tree, aClass, fieldModifiers, true);
            Iterator iterator = initializers.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            object = iterator;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                LighterASTNode initializer = (LighterASTNode)e;
                this.walkMethodBody(initializer, (Function1<? super LighterASTNode, Boolean>)((Function1)new Function1<LighterASTNode, Boolean>((Object)visitor2){

                    public final Boolean invoke(LighterASTNode p0) {
                        return ((PurityInferenceVisitor)this.receiver).visitNode(p0);
                    }
                }));
                PurityInferenceResult result = visitor2.getResult();
                pureInitializer = result != null && result.getSingleCall$intellij_java_analysis_impl() == null && result.getMutatedRefs$intellij_java_analysis_impl().isEmpty();
                if (pureInitializer) continue;
            }
        }
        return new ClassData(hasSuper, pureInitializer, isFinal, onlyLocalInheritors, fieldModifiers);
    }

    private final JavaSourceInference.InferenceMode getInferenceMode(LighterASTNode method, ClassData clsData) {
        boolean isPrivate;
        boolean ctor;
        block6: {
            block5: {
                ClassData classData = clsData;
                if (classData != null ? classData.isFinal() : false) break block5;
                ClassData classData2 = clsData;
                boolean bl = classData2 != null ? classData2.getOnlyLocalInheritors() : false;
                if (!bl) break block6;
            }
            return JavaSourceInference.InferenceMode.ENABLED;
        }
        boolean bl = ctor = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)JavaElementType.TYPE) == null;
        if (ctor) {
            return JavaSourceInference.InferenceMode.ENABLED;
        }
        LighterASTNode modifiers = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)JavaElementType.MODIFIER_LIST);
        boolean isStatic = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.STATIC_KEYWORD) != null;
        boolean isFinal = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.FINAL_KEYWORD) != null;
        boolean bl2 = isPrivate = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)modifiers, (IElementType)JavaTokenType.PRIVATE_KEYWORD) != null;
        if (isStatic || isFinal || isPrivate) {
            return JavaSourceInference.InferenceMode.ENABLED;
        }
        return JavaSourceInference.InferenceMode.PARAMETERS;
    }

    private final MethodData calcData(LighterASTNode method) {
        LighterASTNode lighterASTNode = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)((IElementType)JavaElementType.CODE_BLOCK));
        if (lighterASTNode == null) {
            return null;
        }
        LighterASTNode body = lighterASTNode;
        List<String> parameterNames = ParameterNullityInferenceKt.getParameterNames(this.tree, method);
        ClassData clsData = (ClassData)((Map)this.classData).get(this.tree.getParent(method));
        JavaSourceInference.InferenceMode inferenceMode = this.getInferenceMode(method, clsData);
        if (inferenceMode == JavaSourceInference.InferenceMode.PARAMETERS && parameterNames.isEmpty()) {
            return null;
        }
        List<LighterASTNode> list = ContractInferenceInterpreter.getStatements(body, this.tree);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
        List<LighterASTNode> statements = list;
        BitSet notNullParams = ParameterNullityInferenceKt.inferNotNullParameters(this.tree, parameterNames, statements);
        if (inferenceMode == JavaSourceInference.InferenceMode.PARAMETERS) {
            return this.createData(body, CollectionsKt.emptyList(), null, null, notNullParams);
        }
        Object object = clsData;
        if (object == null || (object = ((ClassData)object).getFieldModifiers()) == null) {
            object = MapsKt.emptyMap();
        }
        Object fieldMap = object;
        boolean ctor = LightTreeUtil.firstChildOfType((LighterAST)this.tree, (LighterASTNode)method, (IElementType)JavaElementType.TYPE) == null;
        boolean maybeImpureCtor = ctor && (clsData == null || clsData.getHasSuper() || !clsData.getHasPureInitializer());
        ContractInferenceInterpreter contractInference = new ContractInferenceInterpreter(this.tree, method, body);
        List<PreContract> list2 = contractInference.inferContracts(statements);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"inferContracts(...)");
        List<PreContract> contracts = list2;
        MethodReturnInferenceVisitor nullityVisitor = new MethodReturnInferenceVisitor(this.tree, contractInference.getParameters(), body);
        PurityInferenceVisitor purityVisitor = new PurityInferenceVisitor(this.tree, body, (Map<String, LighterASTNode>)fieldMap, ctor);
        Ref.BooleanRef stopPurityAnalysis = new Ref.BooleanRef();
        stopPurityAnalysis.element = maybeImpureCtor;
        for (LighterASTNode statement : statements) {
            Intrinsics.checkNotNull((Object)statement);
            this.walkMethodBody(statement, (Function1<? super LighterASTNode, Boolean>)((Function1)arg_0 -> InferenceVisitor.calcData$lambda$0(nullityVisitor, stopPurityAnalysis, purityVisitor, arg_0)));
        }
        return this.createData(body, contracts, nullityVisitor.getResult(), maybeImpureCtor ? null : purityVisitor.getResult(), notNullParams);
    }

    private final void walkMethodBody(LighterASTNode root, Function1<? super LighterASTNode, Boolean> processor) {
        LighterAST lighterAST = this.tree;
        new RecursiveLighterASTNodeWalkingVisitor(processor, lighterAST){
            final /* synthetic */ Function1<LighterASTNode, Boolean> $processor;
            {
                this.$processor = $processor;
                super($super_call_param$1);
            }

            public void visitNode(LighterASTNode element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IElementType type = element.getTokenType();
                if (type == JavaElementType.CLASS || type == JavaElementType.FIELD || type == JavaElementType.METHOD || type == JavaElementType.ANNOTATION_METHOD || type == JavaElementType.LAMBDA_EXPRESSION) {
                    return;
                }
                if (!((Boolean)this.$processor.invoke((Object)element)).booleanValue()) {
                    this.stopWalking();
                }
                super.visitNode(element);
            }
        }.visitNode(root);
    }

    private final MethodData createData(LighterASTNode body, List<? extends PreContract> contracts, MethodReturnInferenceResult methodReturn, PurityInferenceResult purity, BitSet notNullParams) {
        if (methodReturn == null && purity == null && contracts.isEmpty() && notNullParams.isEmpty()) {
            return null;
        }
        return new MethodData(methodReturn, purity, contracts, notNullParams, body.getStartOffset(), body.getEndOffset());
    }

    private static final boolean calcData$lambda$0(MethodReturnInferenceVisitor $nullityVisitor, Ref.BooleanRef $stopPurityAnalysis, PurityInferenceVisitor $purityVisitor, LighterASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $nullityVisitor.visitNode(it);
        if (!$stopPurityAnalysis.element) {
            $stopPurityAnalysis.element = !$purityVisitor.visitNode(it);
        }
        return true;
    }
}

