/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.inference.CannotRestoreExpressionException;
import com.intellij.codeInspection.dataFlow.inference.ExpressionRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0002\u000b\fJ\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "", "getNullability", "Lcom/intellij/codeInsight/Nullability;", "method", "Lcom/intellij/psi/PsiMethod;", "body", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiCodeBlock;", "getMutability", "Lcom/intellij/codeInspection/dataFlow/Mutability;", "Predefined", "FromDelegate", "intellij.java.analysis.impl"})
public interface MethodReturnInferenceResult {
    @NotNull
    public Nullability getNullability(@NotNull PsiMethod var1, @NotNull Function0<? extends PsiCodeBlock> var2);

    @NotNull
    default public Mutability getMutability(@NotNull PsiMethod method, @NotNull Function0<? extends PsiCodeBlock> body) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return Mutability.UNKNOWN;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0012H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0012H\u0002J\u000e\u0010\u001a\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001dJ#\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0014\u0010\u001f\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0083\u0004J\n\u0010\"\u001a\u00020#H\u00d6\u0081\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult$FromDelegate;", "Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "value", "Lcom/intellij/codeInsight/Nullability;", "delegateCalls", "", "Lcom/intellij/codeInspection/dataFlow/inference/ExpressionRange;", "<init>", "(Lcom/intellij/codeInsight/Nullability;Ljava/util/List;)V", "getValue$intellij_java_analysis_impl", "()Lcom/intellij/codeInsight/Nullability;", "getDelegateCalls$intellij_java_analysis_impl", "()Ljava/util/List;", "getNullability", "method", "Lcom/intellij/psi/PsiMethod;", "body", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiCodeBlock;", "getMutability", "Lcom/intellij/codeInspection/dataFlow/Mutability;", "getDelegateMutability", "caller", "delegate", "isNotNullCall", "", "component1", "component1$intellij_java_analysis_impl", "component2", "component2$intellij_java_analysis_impl", "copy", "equals", "other", "", "hashCode", "", "toString", "", "intellij.java.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\ninferenceResults.kt\nKotlin\n*S Kotlin\n*F\n+ 1 inferenceResults.kt\ncom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult$FromDelegate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 inferenceResults.kt\ncom/intellij/codeInspection/dataFlow/inference/ExpressionRange\n*L\n1#1,203:1\n1786#2,3:204\n42#3,8:207\n42#3,8:215\n*S KotlinDebug\n*F\n+ 1 inferenceResults.kt\ncom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult$FromDelegate\n*L\n132#1:204,3\n147#1:207,8\n157#1:215,8\n*E\n"})
    public static final class FromDelegate
    implements MethodReturnInferenceResult {
        @NotNull
        private final Nullability value;
        @NotNull
        private final List<ExpressionRange> delegateCalls;

        public FromDelegate(@NotNull Nullability value, @NotNull List<ExpressionRange> delegateCalls) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(delegateCalls, (String)"delegateCalls");
            this.value = value;
            this.delegateCalls = delegateCalls;
        }

        @NotNull
        public final Nullability getValue$intellij_java_analysis_impl() {
            return this.value;
        }

        @NotNull
        public final List<ExpressionRange> getDelegateCalls$intellij_java_analysis_impl() {
            return this.delegateCalls;
        }

        @Override
        @NotNull
        public Nullability getNullability(@NotNull PsiMethod method, @NotNull Function0<? extends PsiCodeBlock> body) {
            Nullability nullability;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(body, (String)"body");
            if (this.value == Nullability.NULLABLE) {
                nullability = Nullability.NULLABLE;
            } else {
                boolean bl;
                block5: {
                    Iterable $this$all$iv = this.delegateCalls;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ExpressionRange range = (ExpressionRange)element$iv;
                            boolean bl2 = false;
                            if (this.isNotNullCall(method, range, (PsiCodeBlock)body.invoke())) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                nullability = bl ? Nullability.NOT_NULL : Nullability.UNKNOWN;
            }
            return nullability;
        }

        @Override
        @NotNull
        public Mutability getMutability(@NotNull PsiMethod method, @NotNull Function0<? extends PsiCodeBlock> body) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(body, (String)"body");
            if (this.value == Nullability.NOT_NULL) {
                return Mutability.UNKNOWN;
            }
            Mutability mutability = this.delegateCalls.stream().map(arg_0 -> FromDelegate.getMutability$lambda$1(arg_0 -> FromDelegate.getMutability$lambda$0(this, method, body, arg_0), arg_0)).reduce(Mutability::join).orElse(Mutability.UNKNOWN);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)mutability), (String)"orElse(...)");
            return mutability;
        }

        /*
         * WARNING - void declaration
         */
        private final Mutability getDelegateMutability(PsiMethod caller, ExpressionRange delegate, PsiCodeBlock body) {
            Mutability mutability;
            void this_$iv;
            ExpressionRange expressionRange = delegate;
            PsiCodeBlock scope$iv = body;
            boolean $i$f$restoreExpression = false;
            int scopeStart$iv = scope$iv.getTextRange().getStartOffset();
            PsiExpression element$iv = (PsiExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)scope$iv.getContainingFile(), (int)(this_$iv.getStartOffset() + scopeStart$iv), (int)(this_$iv.getEndOffset() + scopeStart$iv), PsiMethodCallExpression.class);
            if (element$iv == null) {
                throw new CannotRestoreExpressionException("No expression of type " + Reflection.getOrCreateKotlinClass(PsiMethodCallExpression.class) + " found");
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)element$iv;
            PsiMethod target = call.resolveMethod();
            if (target == null || Intrinsics.areEqual((Object)target, (Object)caller)) {
                mutability = Mutability.UNKNOWN;
            } else if (ClassUtils.isImmutable(target.getReturnType(), false)) {
                mutability = Mutability.UNMODIFIABLE;
            } else {
                Mutability mutability2 = Mutability.getMutability((PsiModifierListOwner)target);
                mutability = mutability2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)mutability2), (String)"getMutability(...)");
            }
            return mutability;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isNotNullCall(PsiMethod caller, ExpressionRange delegate, PsiCodeBlock body) {
            void this_$iv;
            ExpressionRange expressionRange = delegate;
            PsiCodeBlock scope$iv = body;
            boolean $i$f$restoreExpression = false;
            int scopeStart$iv = scope$iv.getTextRange().getStartOffset();
            PsiExpression element$iv = (PsiExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)scope$iv.getContainingFile(), (int)(this_$iv.getStartOffset() + scopeStart$iv), (int)(this_$iv.getEndOffset() + scopeStart$iv), PsiMethodCallExpression.class);
            if (element$iv == null) {
                throw new CannotRestoreExpressionException("No expression of type " + Reflection.getOrCreateKotlinClass(PsiMethodCallExpression.class) + " found");
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)element$iv;
            if (call.getType() instanceof PsiPrimitiveType) {
                return true;
            }
            PsiMethod target = call.resolveMethod();
            return Intrinsics.areEqual((Object)target, (Object)caller) || target != null && NullableNotNullManager.isNotNull((PsiModifierListOwner)((PsiModifierListOwner)target));
        }

        @NotNull
        public final Nullability component1$intellij_java_analysis_impl() {
            return this.value;
        }

        @NotNull
        public final List<ExpressionRange> component2$intellij_java_analysis_impl() {
            return this.delegateCalls;
        }

        @NotNull
        public final FromDelegate copy(@NotNull Nullability value, @NotNull List<ExpressionRange> delegateCalls) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter(delegateCalls, (String)"delegateCalls");
            return new FromDelegate(value, delegateCalls);
        }

        public static /* synthetic */ FromDelegate copy$default(FromDelegate fromDelegate, Nullability nullability, List list, int n, Object object) {
            if ((n & 1) != 0) {
                nullability = fromDelegate.value;
            }
            if ((n & 2) != 0) {
                list = fromDelegate.delegateCalls;
            }
            return fromDelegate.copy(nullability, list);
        }

        @NotNull
        public String toString() {
            return "FromDelegate(value=" + this.value + ", delegateCalls=" + this.delegateCalls + ")";
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + ((Object)this.delegateCalls).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FromDelegate)) {
                return false;
            }
            FromDelegate fromDelegate = (FromDelegate)other;
            if (this.value != fromDelegate.value) {
                return false;
            }
            return Intrinsics.areEqual(this.delegateCalls, fromDelegate.delegateCalls);
        }

        private static final Mutability getMutability$lambda$0(FromDelegate this$0, PsiMethod $method, Function0 $body, ExpressionRange range) {
            Intrinsics.checkNotNull((Object)range);
            return this$0.getDelegateMutability($method, range, (PsiCodeBlock)$body.invoke());
        }

        private static final Mutability getMutability$lambda$1(Function1 $tmp0, Object p0) {
            return (Mutability)((Object)$tmp0.invoke(p0));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\b\u001a\u00020\tH\u0096\u0080\u0004J\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u0010\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0011J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult$Predefined;", "Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "value", "Lcom/intellij/codeInsight/Nullability;", "<init>", "(Lcom/intellij/codeInsight/Nullability;)V", "getValue$intellij_java_analysis_impl", "()Lcom/intellij/codeInsight/Nullability;", "hashCode", "", "getNullability", "method", "Lcom/intellij/psi/PsiMethod;", "body", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiCodeBlock;", "component1", "component1$intellij_java_analysis_impl", "copy", "equals", "", "other", "", "toString", "", "intellij.java.analysis.impl"})
    public static final class Predefined
    implements MethodReturnInferenceResult {
        @NotNull
        private final Nullability value;

        public Predefined(@NotNull Nullability value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final Nullability getValue$intellij_java_analysis_impl() {
            return this.value;
        }

        public int hashCode() {
            return this.value.ordinal();
        }

        @Override
        @NotNull
        public Nullability getNullability(@NotNull PsiMethod method, @NotNull Function0<? extends PsiCodeBlock> body) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(body, (String)"body");
            return this.value;
        }

        @NotNull
        public final Nullability component1$intellij_java_analysis_impl() {
            return this.value;
        }

        @NotNull
        public final Predefined copy(@NotNull Nullability value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Predefined(value);
        }

        public static /* synthetic */ Predefined copy$default(Predefined predefined, Nullability nullability, int n, Object object) {
            if ((n & 1) != 0) {
                nullability = predefined.value;
            }
            return predefined.copy(nullability);
        }

        @NotNull
        public String toString() {
            return "Predefined(value=" + this.value + ")";
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Predefined)) {
                return false;
            }
            Predefined predefined = (Predefined)other;
            return this.value == predefined.value;
        }
    }
}

