/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BooleanBinaryInstruction
extends ExpressionPushingInstruction {
    @NotNull
    private final RelationType myRelation;
    private final boolean myForceEqualityByContent;

    public BooleanBinaryInstruction(@NotNull RelationType relation, boolean forceEqualityByContent, @Nullable DfaAnchor anchor) {
        if (relation == null) {
            BooleanBinaryInstruction.$$$reportNull$$$0(0);
        }
        super(anchor);
        this.myRelation = relation;
        this.myForceEqualityByContent = forceEqualityByContent;
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        if (interpreter == null) {
            BooleanBinaryInstruction.$$$reportNull$$$0(1);
        }
        if (stateBefore == null) {
            BooleanBinaryInstruction.$$$reportNull$$$0(2);
        }
        DfaValue dfaRight = stateBefore.pop();
        DfaValue dfaLeft = stateBefore.pop();
        if ((this.myRelation == RelationType.EQ || this.myRelation == RelationType.NE) && !this.myForceEqualityByContent && BooleanBinaryInstruction.shouldCompareByEquals(stateBefore, dfaLeft, dfaRight)) {
            DfaCondition condition;
            ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
            DfaMemoryState equality = stateBefore.createCopy();
            if (equality.applyCondition(condition = dfaLeft.eq(dfaRight))) {
                this.pushResult(interpreter, equality, DfTypes.BOOLEAN, new DfaValue[0]);
                states.add(this.nextState(interpreter, equality));
            }
            if (stateBefore.applyCondition(condition.negate())) {
                this.pushResult(interpreter, stateBefore, DfTypes.booleanValue(this.myRelation == RelationType.NE), new DfaValue[0]);
                states.add(this.nextState(interpreter, stateBefore));
            }
            return states.toArray(DfaInstructionState.EMPTY_ARRAY);
        }
        RelationType[] relations = BooleanBinaryInstruction.splitRelation(this.myRelation);
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(relations.length);
        for (int i = 0; i < relations.length; ++i) {
            DfaMemoryState copy;
            RelationType relation = relations[i];
            boolean result = this.myRelation.isSubRelation(relation);
            DfaCondition condition = dfaLeft.cond(relation, dfaRight).correctForRelationResult(result);
            if (condition == DfaCondition.getFalse()) continue;
            if (condition == DfaCondition.getTrue()) {
                this.pushResult(interpreter, stateBefore, DfTypes.booleanValue(result), new DfaValue[0]);
                return this.nextStates(interpreter, stateBefore);
            }
            DfaMemoryState dfaMemoryState = copy = i == relations.length - 1 && !states.isEmpty() ? stateBefore : stateBefore.createCopy();
            if (!copy.applyCondition(condition) || !copy.meetDfType(dfaLeft, copy.getDfType(dfaLeft).correctForRelationResult(this.myRelation, result)) || !copy.meetDfType(dfaRight, copy.getDfType(dfaRight).correctForRelationResult(this.myRelation, result))) continue;
            this.pushResult(interpreter, copy, DfTypes.booleanValue(result), new DfaValue[0]);
            states.add(this.nextState(interpreter, copy));
        }
        if (states.isEmpty()) {
            this.pushResult(interpreter, stateBefore, DfTypes.FALSE, new DfaValue[0]);
            return this.nextStates(interpreter, stateBefore);
        }
        return states.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private static RelationType @NotNull [] splitRelation(RelationType relationType) {
        RelationType[] relationTypeArray;
        switch (relationType) {
            case LT: 
            case LE: 
            case GT: 
            case GE: {
                RelationType[] relationTypeArray2 = new RelationType[3];
                relationTypeArray2[0] = RelationType.LT;
                relationTypeArray2[1] = RelationType.GT;
                relationTypeArray = relationTypeArray2;
                relationTypeArray2[2] = RelationType.EQ;
                break;
            }
            default: {
                RelationType[] relationTypeArray3 = new RelationType[2];
                relationTypeArray3[0] = relationType;
                relationTypeArray = relationTypeArray3;
                relationTypeArray3[1] = relationType.getNegated();
            }
        }
        if (relationTypeArray == null) {
            BooleanBinaryInstruction.$$$reportNull$$$0(3);
        }
        return relationTypeArray;
    }

    private static boolean shouldCompareByEquals(@NotNull DfaMemoryState memState, @NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight) {
        if (memState == null) {
            BooleanBinaryInstruction.$$$reportNull$$$0(4);
        }
        if (dfaLeft == null) {
            BooleanBinaryInstruction.$$$reportNull$$$0(5);
        }
        if (dfaRight == null) {
            BooleanBinaryInstruction.$$$reportNull$$$0(6);
        }
        if (dfaLeft == dfaRight && !(dfaLeft instanceof DfaWrappedValue) && !(dfaLeft.getDfType() instanceof DfConstantType)) {
            return false;
        }
        return TypeConstraint.fromDfType(memState.getDfType(dfaLeft)).isComparedByEquals() && TypeConstraint.fromDfType(memState.getDfType(dfaRight)).isComparedByEquals();
    }

    public String toString() {
        return "BOOLEAN_OP " + String.valueOf(this.myRelation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/BooleanBinaryInstruction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/BooleanBinaryInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "splitRelation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldCompareByEquals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

