/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm.descriptors;

import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PsiVarDescriptor;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GetterDescriptor
extends PsiVarDescriptor {
    private static final CallMatcher STABLE_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0), CallMatcher.instanceCall("java.lang.String", "trim", "stripLeading", "stripTrailing", "strip").parameterCount(0), CallMatcher.instanceCall("java.lang.Enum", "name").parameterCount(0), CallMatcher.instanceCall("java.lang.reflect.Member", "getName", "getModifiers", "getDeclaringClass", "isSynthetic"), CallMatcher.instanceCall("java.lang.reflect.Executable", "getParameterCount", "isVarArgs"), CallMatcher.instanceCall("java.lang.reflect.Field", "getType"), CallMatcher.instanceCall("java.lang.reflect.Method", "getReturnType"), CallMatcher.instanceCall("java.lang.Class", "getName", "isInterface", "isArray", "isPrimitive", "isSynthetic", "isAnonymousClass", "isLocalClass", "isMemberClass", "getDeclaringClass", "getEnclosingClass", "getSimpleName", "getCanonicalName"), CallMatcher.instanceCall("java.io.File", "getName", "getParent", "getPath", "getAbsolutePath", "getParentFile", "getAbsoluteFile", "toPath"));
    @NotNull
    private final PsiMethod myGetter;
    private final boolean myStable;

    public GetterDescriptor(@NotNull PsiMethod getter) {
        if (getter == null) {
            GetterDescriptor.$$$reportNull$$$0(0);
        }
        this.myGetter = getter;
        if (GetterDescriptor.isKnownStableMethod(getter) || getter instanceof LightRecordMethod) {
            this.myStable = true;
        } else {
            PsiField field = PsiUtil.canBeOverridden((PsiMethod)getter) ? null : PropertyUtil.getFieldOfGetter(getter);
            this.myStable = field != null && field.hasModifierProperty("final");
        }
    }

    public static boolean isKnownStableMethod(@NotNull PsiMethod getter) {
        if (getter == null) {
            GetterDescriptor.$$$reportNull$$$0(1);
        }
        return STABLE_METHODS.methodMatches(getter);
    }

    @NotNull
    public String toString() {
        String string = this.myGetter.getName();
        if (string == null) {
            GetterDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    PsiType getType(@Nullable DfaVariableValue qualifier) {
        return GetterDescriptor.getSubstitutor((PsiElement)this.myGetter, qualifier).substitute(this.myGetter.getReturnType());
    }

    @NotNull
    public PsiMethod getPsiElement() {
        PsiMethod psiMethod = this.myGetter;
        if (psiMethod == null) {
            GetterDescriptor.$$$reportNull$$$0(3);
        }
        return psiMethod;
    }

    public boolean isStable() {
        return this.myStable;
    }

    public boolean isCall() {
        return true;
    }

    @Override
    @NotNull
    public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier) {
        if (factory == null) {
            GetterDescriptor.$$$reportNull$$$0(4);
        }
        if (this.myGetter.hasModifierProperty("static")) {
            DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue((VariableDescriptor)this);
            if (dfaVariableValue == null) {
                GetterDescriptor.$$$reportNull$$$0(5);
            }
            return dfaVariableValue;
        }
        DfaValue dfaValue = super.createValue(factory, qualifier);
        if (dfaValue == null) {
            GetterDescriptor.$$$reportNull$$$0(6);
        }
        return dfaValue;
    }

    @NotNull
    public DfType restrictFromState(@NotNull DfaVariableValue qualifier, @NotNull DfaMemoryState state) {
        DfaValue value;
        CustomMethodHandlers.CustomMethodHandler handler;
        if (qualifier == null) {
            GetterDescriptor.$$$reportNull$$$0(7);
        }
        if (state == null) {
            GetterDescriptor.$$$reportNull$$$0(8);
        }
        if ((handler = CustomMethodHandlers.find(this.myGetter)) != null && (value = handler.getMethodResultValue(new DfaCallArguments((DfaValue)qualifier, DfaValue.EMPTY_ARRAY, MutationSignature.pure()), state, qualifier.getFactory(), this.myGetter)) != null) {
            DfType dfType = state.getDfType(value);
            if (dfType == null) {
                GetterDescriptor.$$$reportNull$$$0(9);
            }
            return dfType;
        }
        DfType dfType = super.restrictFromState(qualifier, state);
        if (dfType == null) {
            GetterDescriptor.$$$reportNull$$$0(10);
        }
        return dfType;
    }

    public int hashCode() {
        return Objects.hashCode(this.myGetter.getName());
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GetterDescriptor && ((GetterDescriptor)obj).myGetter == this.myGetter;
    }

    @Override
    @NotNull
    DfaNullability calcCanBeNull(@NotNull DfaVariableValue value, @Nullable PsiElement context) {
        if (value == null) {
            GetterDescriptor.$$$reportNull$$$0(11);
        }
        PsiType type = this.getType(value.getQualifier());
        DfaNullability dfaNullability = DfaNullability.fromNullability(DfaPsiUtil.getElementNullabilityForRead(type, (PsiModifierListOwner)this.myGetter));
        if (dfaNullability == null) {
            GetterDescriptor.$$$reportNull$$$0(12);
        }
        return dfaNullability;
    }

    @Override
    public boolean alwaysEqualsToItself(@NotNull DfType type) {
        if (type == null) {
            GetterDescriptor.$$$reportNull$$$0(13);
        }
        if (!super.alwaysEqualsToItself(type)) {
            return false;
        }
        if (type instanceof DfPrimitiveType || type instanceof DfConstantType) {
            return true;
        }
        return PropertyUtilBase.isSimplePropertyGetter((PsiMethod)this.myGetter) || this.myGetter instanceof LightRecordMethod;
    }

    @NotNull
    public DfType getQualifierConstraintFromValue(@NotNull DfaMemoryState state, @NotNull DfaValue value) {
        DfaVariableValue qualifier;
        if (state == null) {
            GetterDescriptor.$$$reportNull$$$0(14);
        }
        if (value == null) {
            GetterDescriptor.$$$reportNull$$$0(15);
        }
        if (!PsiTypesUtil.isGetClass((PsiMethod)this.myGetter)) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                GetterDescriptor.$$$reportNull$$$0(16);
            }
            return dfType;
        }
        DfType type = state.getDfType(value);
        DfType constraint = DfType.TOP;
        PsiType cls = (PsiType)type.getConstantOfType(PsiType.class);
        if (cls != null) {
            constraint = TypeConstraints.exact(cls).asDfType();
        } else if (type instanceof DfAntiConstantType) {
            constraint = StreamEx.of((Collection)((DfAntiConstantType)type).getNotValues()).select(PsiType.class).map(t -> TypeConstraints.exact(t).tryNegate()).nonNull().reduce(TypeConstraint::meet).orElse(TypeConstraints.TOP).asDfType();
        }
        if (value instanceof DfaVariableValue && ((DfaVariableValue)value).getDescriptor().equals((Object)this) && (qualifier = ((DfaVariableValue)value).getQualifier()) != null) {
            constraint = constraint.meet(TypeConstraint.fromDfType(state.getDfType((DfaValue)qualifier)).asDfType());
        }
        DfType dfType = constraint;
        if (dfType == null) {
            GetterDescriptor.$$$reportNull$$$0(17);
        }
        return dfType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 9, 10, 12, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/GetterDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/GetterDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictFromState";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCanBeNull";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierConstraintFromValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isKnownStableMethod";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restrictFromState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcCanBeNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "alwaysEqualsToItself";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierConstraintFromValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 9, 10, 12, 16, 17 -> new IllegalStateException(string);
        };
    }
}

