/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfEphemeralReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfGenericObjectType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfReferenceConstantType
extends DfConstantType<Object>
implements DfReferenceType {
    @NotNull
    private final TypeConstraint myConstraint;
    @NotNull
    private final Mutability myMutability;
    @Nullable
    private final SpecialField myJvmSpecialField;
    @NotNull
    private final DfType mySpecialFieldType;
    private final boolean myDropConstantOnWiden;

    DfReferenceConstantType(@NotNull Object constant, @NotNull TypeConstraint type, boolean dropConstantOnWiden) {
        if (constant == null) {
            DfReferenceConstantType.$$$reportNull$$$0(0);
        }
        if (type == null) {
            DfReferenceConstantType.$$$reportNull$$$0(1);
        }
        super(constant);
        this.myConstraint = type;
        this.myMutability = constant instanceof PsiModifierListOwner ? Mutability.getMutability((PsiModifierListOwner)constant) : Mutability.UNKNOWN;
        this.myJvmSpecialField = SpecialField.fromQualifierType(this);
        this.mySpecialFieldType = this.myJvmSpecialField == null ? BOTTOM : this.myJvmSpecialField.fromConstant(constant);
        this.myDropConstantOnWiden = dropConstantOnWiden;
    }

    public DfType widen() {
        if (this.myDropConstantOnWiden) {
            return new DfGenericObjectType(Set.of(), this.myConstraint, DfaNullability.NOT_NULL, this.myMutability, this.myJvmSpecialField, this.mySpecialFieldType.widen(), false);
        }
        return this;
    }

    @NotNull
    public DfType meet(@NotNull DfType other) {
        if (other == null) {
            DfReferenceConstantType.$$$reportNull$$$0(2);
        }
        if (other.isSuperType((DfType)this)) {
            DfReferenceConstantType dfReferenceConstantType = this;
            if (dfReferenceConstantType == null) {
                DfReferenceConstantType.$$$reportNull$$$0(3);
            }
            return dfReferenceConstantType;
        }
        if (other instanceof DfEphemeralReferenceType) {
            DfType dfType = BOTTOM;
            if (dfType == null) {
                DfReferenceConstantType.$$$reportNull$$$0(4);
            }
            return dfType;
        }
        if (other instanceof DfGenericObjectType) {
            DfReferenceConstantType subConstant;
            DfReferenceType type = ((DfReferenceType)other).dropMutability();
            if (type.isSuperType(this)) {
                DfReferenceConstantType dfReferenceConstantType = this;
                if (dfReferenceConstantType == null) {
                    DfReferenceConstantType.$$$reportNull$$$0(5);
                }
                return dfReferenceConstantType;
            }
            TypeConstraint constraint = type.getConstraint().meet(this.myConstraint);
            if (constraint != TypeConstraints.BOTTOM && type.isSuperType(subConstant = new DfReferenceConstantType(this.getValue(), constraint, this.myDropConstantOnWiden))) {
                DfReferenceConstantType dfReferenceConstantType = subConstant;
                if (dfReferenceConstantType == null) {
                    DfReferenceConstantType.$$$reportNull$$$0(6);
                }
                return dfReferenceConstantType;
            }
        }
        DfType dfType = BOTTOM;
        if (dfType == null) {
            DfReferenceConstantType.$$$reportNull$$$0(7);
        }
        return dfType;
    }

    @Override
    @NotNull
    public DfaNullability getNullability() {
        DfaNullability dfaNullability = DfaNullability.NOT_NULL;
        if (dfaNullability == null) {
            DfReferenceConstantType.$$$reportNull$$$0(8);
        }
        return dfaNullability;
    }

    @Override
    @NotNull
    public TypeConstraint getConstraint() {
        TypeConstraint typeConstraint = this.myConstraint;
        if (typeConstraint == null) {
            DfReferenceConstantType.$$$reportNull$$$0(9);
        }
        return typeConstraint;
    }

    @Override
    @NotNull
    public Mutability getMutability() {
        Mutability mutability = this.myMutability;
        if (mutability == null) {
            DfReferenceConstantType.$$$reportNull$$$0(10);
        }
        return mutability;
    }

    @Override
    @Nullable
    public SpecialField getSpecialField() {
        return this.myJvmSpecialField;
    }

    @Override
    @NotNull
    public DfType getSpecialFieldType() {
        DfType dfType = this.mySpecialFieldType;
        if (dfType == null) {
            DfReferenceConstantType.$$$reportNull$$$0(11);
        }
        return dfType;
    }

    public DfType tryNegate() {
        return new DfGenericObjectType(Set.of(this.getValue()), TypeConstraints.TOP, DfaNullability.UNKNOWN, Mutability.UNKNOWN, null, BOTTOM, false);
    }

    @Override
    @NotNull
    public DfReferenceType dropNullability() {
        return new DfGenericObjectType(Set.of(), this.myConstraint, DfaNullability.UNKNOWN, this.myMutability, this.myJvmSpecialField, this.mySpecialFieldType, false);
    }

    @Override
    @NotNull
    public DfReferenceType convert(@NotNull TypeConstraints.TypeConstraintFactory factory) {
        if (factory == null) {
            DfReferenceConstantType.$$$reportNull$$$0(12);
        }
        return new DfReferenceConstantType(this.getValue(), this.myConstraint.convert(factory), this.myDropConstantOnWiden);
    }

    @NotNull
    public DfType join(@NotNull DfType other) {
        DfType sfType;
        if (other == null) {
            DfReferenceConstantType.$$$reportNull$$$0(13);
        }
        if (other instanceof DfGenericObjectType || other instanceof DfEphemeralReferenceType) {
            DfType dfType = other.join((DfType)this);
            if (dfType == null) {
                DfReferenceConstantType.$$$reportNull$$$0(14);
            }
            return dfType;
        }
        if (this.isSuperType(other)) {
            DfReferenceConstantType dfReferenceConstantType = this;
            if (dfReferenceConstantType == null) {
                DfReferenceConstantType.$$$reportNull$$$0(15);
            }
            return dfReferenceConstantType;
        }
        if (other.isSuperType((DfType)this)) {
            DfType dfType = other;
            if (dfType == null) {
                DfReferenceConstantType.$$$reportNull$$$0(16);
            }
            return dfType;
        }
        if (!(other instanceof DfReferenceType)) {
            DfType dfType = TOP;
            if (dfType == null) {
                DfReferenceConstantType.$$$reportNull$$$0(17);
            }
            return dfType;
        }
        DfReferenceType type = (DfReferenceType)other;
        TypeConstraint constraint = this.getConstraint().join(type.getConstraint());
        DfaNullability nullability = this.getNullability().unite(type.getNullability());
        Mutability mutability = this.getMutability().join(type.getMutability());
        boolean locality = this.isLocal() && type.isLocal();
        SpecialField sf = Objects.equals((Object)this.getSpecialField(), (Object)type.getSpecialField()) ? this.getSpecialField() : null;
        DfType dfType = sfType = sf == null ? BOTTOM : this.getSpecialFieldType().join(type.getSpecialFieldType());
        if (constraint.isSingleton() && nullability == DfaNullability.NOT_NULL) {
            return new DfReferenceConstantType(constraint, constraint, false);
        }
        return new DfGenericObjectType(Set.of(), constraint, nullability, mutability, sf, sfType, locality);
    }

    @Nullable
    public DfType tryJoinExactly(@NotNull DfType other) {
        if (other == null) {
            DfReferenceConstantType.$$$reportNull$$$0(18);
        }
        if (this.isMergeable(other)) {
            return this;
        }
        if (other.isMergeable((DfType)this)) {
            return other;
        }
        if (other instanceof DfGenericObjectType) {
            other.tryJoinExactly((DfType)this);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!super.equals(obj)) return false;
        if (!(obj instanceof DfReferenceConstantType)) return false;
        DfReferenceConstantType refConstant = (DfReferenceConstantType)obj;
        if (!this.myConstraint.equals(refConstant.myConstraint)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myConstraint);
    }

    @Override
    @NotNull
    public String toString() {
        String string = DfaPsiUtil.renderValue(this.getValue());
        if (string == null) {
            DfReferenceConstantType.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfReferenceConstantType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfReferenceConstantType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraint";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutability";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialFieldType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 15, 16, 17, 19 -> new IllegalStateException(string);
        };
    }
}

