/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddUsesDirectiveFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixBackedByIntentionAction;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JavaModuleDefinitionInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JavaModuleDefinitionInspection.$$$reportNull$$$0(0);
        }
        return !PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? PsiElementVisitor.EMPTY_VISITOR : new JavaElementVisitor(this){

            public void visitModule(@NotNull PsiJavaModule module) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.checkUnusedServices(module);
            }

            public void visitRequiresStatement(@NotNull PsiRequiresStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.checkModuleReference(statement.getReferenceElement());
            }

            public void visitModuleReferenceElement(@NotNull PsiJavaModuleReferenceElement refElement) {
                if (refElement == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitModuleReferenceElement(refElement);
                PsiJavaModuleReference ref = refElement.getReference();
                if (refElement.getParent() instanceof PsiPackageAccessibilityStatement && ref != null && ref.multiResolve(true).length == 0) {
                    String message = JavaErrorKinds.MODULE_NOT_FOUND.create((PsiElement)refElement).description();
                    holder.registerProblem((PsiElement)refElement, message, new LocalQuickFix[0]);
                }
            }

            public void visitImportModuleStatement(@NotNull PsiImportModuleStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.checkModuleReference(statement.getModuleReference());
            }

            public void visitPackageAccessibilityStatement(@NotNull PsiPackageAccessibilityStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (statement.getRole() != PsiPackageAccessibilityStatement.Role.OPENS) {
                    return;
                }
                PsiJavaCodeReferenceElement refElement = statement.getPackageReference();
                if (refElement == null) {
                    return;
                }
                JavaPsiModuleUtil.PackageReferenceState state = JavaPsiModuleUtil.checkPackageReference((PsiPackageAccessibilityStatement)statement);
                if (state == JavaPsiModuleUtil.PackageReferenceState.VALID) {
                    return;
                }
                JavaErrorKind.Simple kind = state == JavaPsiModuleUtil.PackageReferenceState.PACKAGE_NOT_FOUND ? JavaErrorKinds.MODULE_REFERENCE_PACKAGE_NOT_FOUND : JavaErrorKinds.MODULE_REFERENCE_PACKAGE_EMPTY;
                String message = kind.create((PsiElement)statement).description();
                String packageName = statement.getPackageName();
                Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
                IntentionAction action = module == null ? null : QuickFixFactory.getInstance().createCreateClassInPackageInModuleFix(module, packageName);
                holder.problem((PsiElement)refElement, message).maybeFix((LocalQuickFix)(action == null ? null : new LocalQuickFixBackedByIntentionAction(action))).register();
            }

            private void checkModuleReference(PsiJavaModuleReferenceElement refElement) {
                ResolveResult[] results;
                PsiJavaModuleReference ref;
                if (refElement != null && (ref = refElement.getReference()) != null && (results = ref.multiResolve(true)).length > 1 && ref.resolve() == null) {
                    holder.registerProblem((PsiElement)refElement, JavaAnalysisBundle.message((String)"module.ambiguous", (Object[])new Object[]{refElement.getReferenceText()}), new LocalQuickFix[0]);
                }
            }

            private void checkUnusedServices(@NotNull PsiJavaModule module) {
                Module host;
                if (module == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((host = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile())) == null) {
                    return;
                }
                List provides = JBIterable.from((Iterable)module.getProvides()).toList();
                if (!provides.isEmpty()) {
                    Set exports = JBIterable.from((Iterable)module.getExports()).map(PsiPackageAccessibilityStatement::getPackageName).filter(Objects::nonNull).toSet();
                    Set uses = JBIterable.from((Iterable)module.getUses()).map(st -> JavaModuleDefinitionInspection.qName(st.getClassReference())).filter(Objects::nonNull).toSet();
                    for (PsiProvidesStatement statement : provides) {
                        String className;
                        String packageName;
                        PsiElement target;
                        PsiJavaCodeReferenceElement ref = statement.getInterfaceReference();
                        if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleUtilCore.findModuleForFile((PsiFile)target.getContainingFile()) != host || exports.contains(packageName = StringUtil.getPackageName((String)(className = JavaModuleDefinitionInspection.qName(ref)))) || uses.contains(className)) continue;
                        holder.problem((PsiElement)Objects.requireNonNullElse(ref.getReferenceNameElement(), ref), JavaAnalysisBundle.message((String)"module.service.unused", (Object[])new Object[0])).fix((ModCommandAction)new AddExportsDirectiveFix(module, packageName, "")).fix((ModCommandAction)new AddUsesDirectiveFix(module, className)).register();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refElement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/java19modules/JavaModuleDefinitionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitModule";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRequiresStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitModuleReferenceElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitImportModuleStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPackageAccessibilityStatement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkUnusedServices";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static String qName(PsiJavaCodeReferenceElement ref) {
        return ref != null ? ref.getQualifiedName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/JavaModuleDefinitionInspection", "buildVisitor"));
    }
}

