/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveAnnotationToBoundFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"intention.family.name.move.annotation.to.upper.bound", (Object[])new Object[0]);
        if (string == null) {
            MoveAnnotationToBoundFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiAnnotation annotation;
        if (project == null) {
            MoveAnnotationToBoundFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            MoveAnnotationToBoundFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            MoveAnnotationToBoundFix.$$$reportNull$$$0(3);
        }
        if ((annotation = (PsiAnnotation)ObjectUtils.tryCast((Object)element, PsiAnnotation.class)) == null) {
            return;
        }
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        PsiWildcardType owner = (PsiWildcardType)ObjectUtils.tryCast((Object)annotation.getOwner(), PsiWildcardType.class);
        if (owner == null) {
            return;
        }
        PsiTypeElement typeElement = (PsiTypeElement)ObjectUtils.tryCast((Object)annotation.getParent(), PsiTypeElement.class);
        if (typeElement == null) {
            return;
        }
        StringBuilder newText = new StringBuilder();
        boolean added = false;
        for (PsiElement child : typeElement.getChildren()) {
            if (child == annotation) continue;
            newText.append(child.getText());
            if (!PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.EXTENDS_KEYWORD) && !PsiUtil.isJavaToken((PsiElement)child, (IElementType)JavaTokenType.SUPER_KEYWORD)) continue;
            newText.append(" ").append(annotation.getText());
            added = true;
        }
        if (!added) {
            newText.append(" extends ").append(annotation.getText()).append(" ").append("java.lang.Object");
        }
        PsiTypeElement newTypeElement = JavaPsiFacade.getElementFactory((Project)project).createTypeElementFromText(newText.toString().trim(), (PsiElement)typeElement);
        typeElement.replace((PsiElement)newTypeElement);
    }

    @Nullable
    static MoveAnnotationToBoundFix create(@NotNull PsiAnnotation annotation) {
        PsiWildcardType owner;
        if (annotation == null) {
            MoveAnnotationToBoundFix.$$$reportNull$$$0(4);
        }
        if ((owner = (PsiWildcardType)ObjectUtils.tryCast((Object)annotation.getOwner(), PsiWildcardType.class)) == null) {
            return null;
        }
        PsiType bound = owner.getBound();
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        if (bound != null && bound.hasAnnotation(qualifiedName)) {
            return null;
        }
        return new MoveAnnotationToBoundFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/nullable/MoveAnnotationToBoundFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/nullable/MoveAnnotationToBoundFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

