/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.restriction;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.restriction.AnnotationContext;
import com.intellij.codeInspection.restriction.RestrictionInfo;
import com.intellij.codeInspection.restriction.RestrictionInfoFactory;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.util.UastExpressionUtils;

public final class StringFlowUtil {
    @Nullable
    public static UExpression getReturnValue(@NotNull UCallExpression call) {
        PsiMethod psiMethod;
        UExpression returnValue;
        if (call == null) {
            StringFlowUtil.$$$reportNull$$$0(0);
        }
        if ((returnValue = (UExpression)UastContextKt.toUElement((PsiElement)PropertyUtilBase.getGetterReturnExpression((PsiMethod)(psiMethod = call.resolve())), UExpression.class)) instanceof UQualifiedReferenceExpression) {
            returnValue = ((UQualifiedReferenceExpression)returnValue).getSelector();
        }
        return returnValue;
    }

    @NotNull
    public static UExpression goUp(@NotNull UExpression expression, boolean allowStringTransformation, @NotNull RestrictionInfoFactory<?> factory) {
        if (expression == null) {
            StringFlowUtil.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            StringFlowUtil.$$$reportNull$$$0(2);
        }
        UExpression parent = expression;
        while (true) {
            UExpression condExpression;
            UExpression next;
            UExpression lastExpression;
            UExpressionList elvis;
            UElement parentElement;
            if ((parentElement = parent.getUastParent()) instanceof ULocalVariable && parentElement.getUastParent() instanceof UDeclarationsExpression && (elvis = (UExpressionList)ObjectUtils.tryCast((Object)parentElement.getUastParent().getUastParent(), UExpressionList.class)) != null) {
                parentElement = elvis;
            }
            if (parentElement instanceof UExpressionList && (lastExpression = (UExpression)ContainerUtil.getLastItem((List)((UExpressionList)parentElement).getExpressions())) != null && AnnotationContext.expressionsAreEquivalent(parent, lastExpression)) {
                parentElement = parentElement.getUastParent();
            }
            if ((next = (UExpression)ObjectUtils.tryCast((Object)parentElement, UExpression.class)) == null || next instanceof UNamedExpression) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    StringFlowUtil.$$$reportNull$$$0(3);
                }
                return uExpression;
            }
            if (next instanceof USwitchClauseExpression) {
                USwitchClauseExpression switchClause = (USwitchClauseExpression)next;
                List caseValues = ContainerUtil.map((Collection)switchClause.getCaseValues(), caseValue -> AnnotationContext.normalize(caseValue));
                if (caseValues.contains(AnnotationContext.normalize(parent))) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        StringFlowUtil.$$$reportNull$$$0(4);
                    }
                    return uExpression;
                }
                UExpressionList switchBody = (UExpressionList)ObjectUtils.tryCast((Object)next.getUastParent(), UExpressionList.class);
                if (switchBody == null) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        StringFlowUtil.$$$reportNull$$$0(5);
                    }
                    return uExpression;
                }
                USwitchExpression switchExpression = (USwitchExpression)ObjectUtils.tryCast((Object)switchBody.getUastParent(), USwitchExpression.class);
                if (switchExpression == null) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        StringFlowUtil.$$$reportNull$$$0(6);
                    }
                    return uExpression;
                }
                next = switchExpression;
            }
            ULambdaExpression lambda = (ULambdaExpression)ObjectUtils.tryCast((Object)next, ULambdaExpression.class);
            if (next instanceof UReturnExpression && (lambda = (ULambdaExpression)ObjectUtils.tryCast((Object)((UReturnExpression)next).getJumpTarget(), ULambdaExpression.class)) == null) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    StringFlowUtil.$$$reportNull$$$0(7);
                }
                return uExpression;
            }
            if (lambda != null) {
                UCallExpression uastParent = (UCallExpression)ObjectUtils.tryCast((Object)lambda.getUastParent(), UCallExpression.class);
                if (uastParent == null) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        StringFlowUtil.$$$reportNull$$$0(8);
                    }
                    return uExpression;
                }
                PsiMethod method = uastParent.resolve();
                if (method == null || !StringFlowUtil.isPassthroughMethod(method, uastParent, (UExpression)lambda, factory)) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        StringFlowUtil.$$$reportNull$$$0(9);
                    }
                    return uExpression;
                }
                next = uastParent;
            }
            if (next instanceof UQualifiedReferenceExpression && !TypeUtils.isJavaLangString(next.getExpressionType()) && !TypeUtils.typeEquals("java.lang.CharSequence", next.getExpressionType())) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    StringFlowUtil.$$$reportNull$$$0(10);
                }
                return uExpression;
            }
            if (next instanceof UPolyadicExpression && (!allowStringTransformation || ((UPolyadicExpression)next).getOperator() != UastBinaryOperator.PLUS)) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    StringFlowUtil.$$$reportNull$$$0(11);
                }
                return uExpression;
            }
            if (next instanceof UCallExpression && !UastExpressionUtils.isArrayInitializer((UElement)next) && !UastExpressionUtils.isNewArrayWithInitializer((UElement)next)) {
                boolean shouldGoThroughCall;
                PsiMethod method = ((UCallExpression)next).resolve();
                boolean bl = shouldGoThroughCall = TypeUtils.isJavaLangString(next.getExpressionType()) && (allowStringTransformation && StringFlowUtil.isStringProcessingMethod(method, factory) || StringFlowUtil.isPassthroughMethod(method, (UCallExpression)next, parent, factory));
                if (!shouldGoThroughCall) {
                    UExpression uExpression = parent;
                    if (uExpression == null) {
                        StringFlowUtil.$$$reportNull$$$0(12);
                    }
                    return uExpression;
                }
            }
            if (next instanceof UIfExpression && AnnotationContext.expressionsAreEquivalent(parent, ((UIfExpression)next).getCondition())) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    StringFlowUtil.$$$reportNull$$$0(13);
                }
                return uExpression;
            }
            if (next instanceof USwitchExpression && (condExpression = ((USwitchExpression)next).getExpression()) != null && AnnotationContext.expressionsAreEquivalent(parent, condExpression)) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    StringFlowUtil.$$$reportNull$$$0(14);
                }
                return uExpression;
            }
            if (next instanceof UArrayAccessExpression) {
                UExpression uExpression = parent;
                if (uExpression == null) {
                    StringFlowUtil.$$$reportNull$$$0(15);
                }
                return uExpression;
            }
            parent = next;
        }
    }

    public static boolean isStringProcessingMethod(@Nullable PsiMethod method, @NotNull RestrictionInfoFactory<?> factory) {
        if (factory == null) {
            StringFlowUtil.$$$reportNull$$$0(16);
        }
        if (method == null) {
            return false;
        }
        if (factory.fromModifierListOwner((PsiModifierListOwner)method).getKind() == RestrictionInfo.RestrictionInfoKind.KNOWN) {
            return false;
        }
        if (!JavaMethodContractUtil.isPure(method)) {
            return false;
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0) {
            return false;
        }
        for (PsiParameter parameter : parameters) {
            if (factory.fromModifierListOwner((PsiModifierListOwner)parameter).getKind() != RestrictionInfo.RestrictionInfoKind.KNOWN) continue;
            return false;
        }
        return true;
    }

    public static boolean isPassthroughMethod(@Nullable PsiMethod method, @Nullable UCallExpression call, @Nullable UExpression arg, @NotNull RestrictionInfoFactory<?> factory) {
        if (factory == null) {
            StringFlowUtil.$$$reportNull$$$0(17);
        }
        if (method == null) {
            return false;
        }
        PsiType type = method.getReturnType();
        PsiTypeParameter typeParameter = (PsiTypeParameter)ObjectUtils.tryCast((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)type), PsiTypeParameter.class);
        if (typeParameter != null && typeParameter.getExtendsList().getReferencedTypes().length == 0) {
            PsiParameter[] parameters;
            if (arg == null || call == null) {
                parameters = method.getParameterList().getParameters();
            } else {
                Object info;
                PsiParameter parameter = AnnotationContext.getParameter(call, arg);
                if (parameter == null) {
                    return false;
                }
                PsiType parameterType = parameter.getType();
                PsiElement psi = call.getSourcePsi();
                if (psi instanceof PsiMethodCallExpression) {
                    PsiSubstitutor substitutor = ((PsiMethodCallExpression)psi).getMethodExpression().advancedResolve(false).getSubstitutor();
                    parameterType = substitutor.substitute(parameterType);
                }
                if ((info = factory.fromAnnotationOwner((PsiAnnotationOwner)parameterType)).getKind() != RestrictionInfo.RestrictionInfoKind.UNKNOWN) {
                    return false;
                }
                parameters = new PsiParameter[]{parameter};
            }
            for (PsiParameter parameter : parameters) {
                PsiType parameterType = parameter.getType();
                if (type.equals(GenericsUtil.getVariableTypeByExpressionType((PsiType)parameterType))) {
                    return true;
                }
                PsiType returnType = GenericsUtil.getVariableTypeByExpressionType((PsiType)LambdaUtil.getFunctionalInterfaceReturnType((PsiType)parameterType));
                if (!type.equals(returnType)) continue;
                return true;
            }
        }
        return StringFlowUtil.isKotlinPassthroughMethod(method);
    }

    private static boolean isKotlinPassthroughMethod(PsiMethod method) {
        PsiParameter parameter;
        PsiParameter[] parameters;
        if ((method.getName().equals("let") || method.getName().equals("run")) && method.getModifierList().textMatches((CharSequence)"public inline") && (parameters = method.getParameterList().getParameters()).length == 2 && StringFlowUtil.isReceiver(method, parameters[0]) && parameters[1].getName().equals("block")) {
            return true;
        }
        if (method.getName().equals("joinToString")) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "kotlin.collections.CollectionsKt___CollectionsKt".equals(aClass.getQualifiedName());
        }
        if (method.hasModifierProperty("static") && (parameter = method.getParameterList().getParameter(0)) != null && StringFlowUtil.isReceiver(method, parameter)) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && aClass.getQualifiedName() != null && aClass.getQualifiedName().startsWith("kotlin.text.StringsKt__Strings");
        }
        return false;
    }

    private static boolean isReceiver(PsiMethod method, PsiParameter param) {
        return param.getName().equals("$receiver") || param.getName().equals("$this$" + method.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/restriction/StringFlowUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/restriction/StringFlowUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "goUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReturnValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "goUp";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isStringProcessingMethod";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPassthroughMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
        };
    }
}

