/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionalUtil {
    public static final String OPTIONAL_INT = "java.util.OptionalInt";
    public static final String OPTIONAL_LONG = "java.util.OptionalLong";
    public static final String OPTIONAL_DOUBLE = "java.util.OptionalDouble";
    public static final String GUAVA_OPTIONAL = "com.google.common.base.Optional";
    public static final CallMatcher GUAVA_OPTIONAL_FROM_NULLABLE = CallMatcher.staticCall("com.google.common.base.Optional", "fromNullable").parameterCount(1);
    public static final CallMatcher JDK_OPTIONAL_OF_NULLABLE = CallMatcher.staticCall("java.util.Optional", "ofNullable").parameterCount(1);
    public static final CallMatcher OPTIONAL_OF_NULLABLE = CallMatcher.anyOf(JDK_OPTIONAL_OF_NULLABLE, GUAVA_OPTIONAL_FROM_NULLABLE);
    public static final CallMatcher JDK_OPTIONAL_GET = CallMatcher.exactInstanceCall("java.util.Optional", "get").parameterCount(0);
    public static final CallMatcher JDK_OPTIONAL_INT_GET = CallMatcher.exactInstanceCall("java.util.OptionalInt", "getAsInt").parameterCount(0);
    public static final CallMatcher JDK_OPTIONAL_LONG_GET = CallMatcher.exactInstanceCall("java.util.OptionalLong", "getAsLong").parameterCount(0);
    public static final CallMatcher JDK_OPTIONAL_DOUBLE_GET = CallMatcher.exactInstanceCall("java.util.OptionalDouble", "getAsDouble").parameterCount(0);
    public static final CallMatcher GUAVA_OPTIONAL_GET = CallMatcher.instanceCall("com.google.common.base.Optional", "get").parameterCount(0);
    public static final CallMatcher OPTIONAL_GET = CallMatcher.anyOf(JDK_OPTIONAL_GET, JDK_OPTIONAL_INT_GET, JDK_OPTIONAL_LONG_GET, JDK_OPTIONAL_DOUBLE_GET, GUAVA_OPTIONAL_GET);
    public static final CallMatcher JDK_OPTIONAL_WRAP_METHOD = CallMatcher.staticCall("java.util.Optional", "of", "ofNullable").parameterCount(1);

    @Contract(pure=true)
    @NotNull
    public static String getOptionalClass(String type) {
        return switch (type) {
            case "int" -> OPTIONAL_INT;
            case "long" -> OPTIONAL_LONG;
            case "double" -> OPTIONAL_DOUBLE;
            default -> "java.util.Optional";
        };
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isJdkOptionalClassName(@Nullable String className) {
        return "java.util.Optional".equals(className) || OPTIONAL_INT.equals(className) || OPTIONAL_LONG.equals(className) || OPTIONAL_DOUBLE.equals(className);
    }

    @Contract(value="null -> null")
    public static PsiType getOptionalElementType(PsiType type) {
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        if (aClass == null) {
            return null;
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return null;
        }
        return switch (className) {
            case OPTIONAL_INT -> PsiTypes.intType();
            case OPTIONAL_LONG -> PsiTypes.longType();
            case OPTIONAL_DOUBLE -> PsiTypes.doubleType();
            case "java.util.Optional", GUAVA_OPTIONAL -> {
                PsiType[] parameters = ((PsiClassType)type).getParameters();
                if (parameters.length != 1) {
                    yield null;
                }
                PsiType streamType = parameters[0];
                if (streamType instanceof PsiCapturedWildcardType) {
                    streamType = ((PsiCapturedWildcardType)streamType).getUpperBound();
                }
                yield streamType;
            }
            default -> null;
        };
    }

    @Contract(value="null -> false")
    public static boolean isOptionalEmptyCall(PsiExpression expression) {
        return expression instanceof PsiMethodCallExpression && MethodCallUtils.isCallToStaticMethod((PsiMethodCallExpression)expression, "java.util.Optional", "empty", 0);
    }
}

