/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.analysis.impl.bytecode;

import com.intellij.java.analysis.impl.bytecode.ClassAncestorResolver;
import com.intellij.java.analysis.impl.bytecode.ClassAncestorResolverKt;
import com.intellij.java.analysis.impl.bytecode.ClassFileAnalyzerImplKt;
import com.intellij.java.analysis.impl.bytecode.ClassFileEntry;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.signature.SignatureReader;
import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0012\u001a\u00020\tJ\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0012\u001a\u00020\tH\u0002J(\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\b2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR6\u0010\u000e\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\u000fj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0003`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/java/analysis/impl/bytecode/ClassAncestorResolver;", "", "classpath", "", "Ljava/nio/file/Path;", "<init>", "(Ljava/util/List;)V", "packageToClasspathRoots", "", "", "getPackageToClasspathRoots", "()Ljava/util/Map;", "packageToClasspathRoots$delegate", "Lkotlin/Lazy;", "ancestorsCache", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAllAncestors", "binaryClassName", "collectAllAncestors", "collectPackagesInClasspath", "collectSuperclasses", "loadSuperclasses", "path", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nClassAncestorResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassAncestorResolver.kt\ncom/intellij/java/analysis/impl/bytecode/ClassAncestorResolver\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,99:1\n67#2,4:100\n1026#3:104\n1062#3,3:105\n1065#3,3:115\n383#4,7:108\n*S KotlinDebug\n*F\n+ 1 ClassAncestorResolver.kt\ncom/intellij/java/analysis/impl/bytecode/ClassAncestorResolver\n*L\n35#1:100,4\n58#1:104\n58#1:105,3\n58#1:115,3\n58#1:108,7\n*E\n"})
public final class ClassAncestorResolver {
    @NotNull
    private final List<Path> classpath;
    @NotNull
    private final Lazy packageToClasspathRoots$delegate;
    @NotNull
    private final HashMap<String, List<String>> ancestorsCache;

    public ClassAncestorResolver(@NotNull List<? extends Path> classpath) {
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        this.classpath = classpath;
        this.packageToClasspathRoots$delegate = LazyKt.lazy(() -> ClassAncestorResolver.packageToClasspathRoots_delegate$lambda$0(this));
        this.ancestorsCache = new HashMap();
    }

    private final Map<String, List<Path>> getPackageToClasspathRoots() {
        Lazy lazy = this.packageToClasspathRoots$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final List<String> getAllAncestors(@NotNull String binaryClassName) {
        Intrinsics.checkNotNullParameter((Object)binaryClassName, (String)"binaryClassName");
        List<String> cached = this.ancestorsCache.get(binaryClassName);
        if (cached != null) {
            return cached;
        }
        ((Map)this.ancestorsCache).put(binaryClassName, CollectionsKt.emptyList());
        List<String> ancestors = this.collectAllAncestors(binaryClassName);
        ((Map)this.ancestorsCache).put(binaryClassName, ancestors);
        return ancestors;
    }

    private final List<String> collectAllAncestors(String binaryClassName) {
        Logger $this$trace$iv = ClassAncestorResolverKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Collecting ancestors for " + binaryClassName);
        }
        List<String> superclasses = this.collectSuperclasses(binaryClassName);
        HashSet<String> result = new HashSet<String>();
        for (String superclass : superclasses) {
            result.add(superclass);
            result.addAll((Collection)this.getAllAncestors(superclass));
        }
        return CollectionsKt.toList((Iterable)result);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, List<Path>> collectPackagesInClasspath(List<? extends Path> classpath) {
        void $this$groupByTo$iv$iv;
        Sequence $this$groupBy$iv = SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)classpath), ClassAncestorResolver::collectPackagesInClasspath$lambda$0);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            void $this$getOrPut$iv$iv$iv;
            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000)\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\"\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"com/intellij/java/analysis/impl/bytecode/ClassAncestorResolver$collectPackagesInClasspath$PackageToClasspathRoot", "", "packageName", "", "classpathRoot", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getPackageName", "()Ljava/lang/String;", "getClasspathRoot", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/nio/file/Path;)Lcom/intellij/java/analysis/impl/bytecode/ClassAncestorResolver$collectPackagesInClasspath$PackageToClasspathRoot;", "equals", "", "other", "hashCode", "", "toString", "intellij.java.analysis.impl"})
            public final class PackageToClasspathRoot {
                private final String packageName;
                private final Path classpathRoot;

                public PackageToClasspathRoot(String packageName, Path classpathRoot) {
                    Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                    Intrinsics.checkNotNullParameter((Object)classpathRoot, (String)"classpathRoot");
                    this.packageName = packageName;
                    this.classpathRoot = classpathRoot;
                }

                public final String getPackageName() {
                    return this.packageName;
                }

                public final Path getClasspathRoot() {
                    return this.classpathRoot;
                }

                public final String component1() {
                    return this.packageName;
                }

                public final Path component2() {
                    return this.classpathRoot;
                }

                public final PackageToClasspathRoot copy(String packageName, Path classpathRoot) {
                    Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                    Intrinsics.checkNotNullParameter((Object)classpathRoot, (String)"classpathRoot");
                    return new PackageToClasspathRoot(packageName, classpathRoot);
                }

                public static /* synthetic */ PackageToClasspathRoot copy$default(PackageToClasspathRoot packageToClasspathRoot, String string, Path path, int n, Object object) {
                    if ((n & 1) != 0) {
                        string = packageToClasspathRoot.packageName;
                    }
                    if ((n & 2) != 0) {
                        path = packageToClasspathRoot.classpathRoot;
                    }
                    return packageToClasspathRoot.copy(string, path);
                }

                public String toString() {
                    return "PackageToClasspathRoot(packageName=" + this.packageName + ", classpathRoot=" + this.classpathRoot + ")";
                }

                public int hashCode() {
                    int result = this.packageName.hashCode();
                    result = result * 31 + ((Object)this.classpathRoot).hashCode();
                    return result;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof PackageToClasspathRoot)) {
                        return false;
                    }
                    PackageToClasspathRoot packageToClasspathRoot = (PackageToClasspathRoot)other;
                    if (!Intrinsics.areEqual((Object)this.packageName, (Object)packageToClasspathRoot.packageName)) {
                        return false;
                    }
                    return Intrinsics.areEqual((Object)this.classpathRoot, (Object)packageToClasspathRoot.classpathRoot);
                }
            }
            PackageToClasspathRoot it2 = (PackageToClasspathRoot)element$iv$iv;
            boolean $i$a$-groupBy-ClassAncestorResolver$collectPackagesInClasspath$42 = false;
            String key$iv$iv = it2.getPackageName();
            Map map = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            PackageToClasspathRoot $i$a$-groupBy-ClassAncestorResolver$collectPackagesInClasspath$42 = (PackageToClasspathRoot)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add(it.getClasspathRoot());
        }
        return destination$iv$iv;
    }

    private final List<String> collectSuperclasses(String binaryClassName) {
        List list;
        List list2;
        block3: {
            String packageName = StringsKt.substringBeforeLast((String)binaryClassName, (char)'/', (String)"");
            String relativePath = binaryClassName + ".class";
            List<Path> list3 = this.getPackageToClasspathRoots().get(packageName);
            if (list3 == null) {
                return CollectionsKt.emptyList();
            }
            List<Path> paths = list3;
            for (Path root : (Iterable)paths) {
                boolean bl = false;
                List list4 = (List)ClassFileAnalyzerImplKt.withClassRoot(root, arg_0 -> ClassAncestorResolver.collectSuperclasses$lambda$0$0(relativePath, this, arg_0));
                if (list4 == null) continue;
                list2 = list4;
                break block3;
            }
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<String> loadSuperclasses(Path path) {
        ArrayList<String> result = new ArrayList<String>();
        ClassVisitor visitor2 = new ClassVisitor(result){
            final /* synthetic */ ArrayList<String> $result;
            {
                this.$result = $result;
                super(589824);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (superName != null) {
                    this.$result.add(superName);
                }
                if (interfaces != null) {
                    String[] stringArray = interfaces;
                    Collections.addAll((Collection)this.$result, Arrays.copyOf(stringArray, stringArray.length));
                }
                if (signature != null) {
                    new SignatureReader(signature).accept(new SignatureVisitor(this.$result){
                        final /* synthetic */ ArrayList<String> $result;
                        {
                            this.$result = $result;
                            super(589824);
                        }

                        public void visitClassType(String name) {
                            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                            this.$result.add(name);
                        }
                    });
                }
            }
        };
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        new ClassReader(byArray).accept(visitor2, 7);
        return result;
    }

    private static final Map packageToClasspathRoots_delegate$lambda$0(ClassAncestorResolver this$0) {
        return this$0.collectPackagesInClasspath(this$0.classpath);
    }

    private static final collectPackagesInClasspath.PackageToClasspathRoot collectPackagesInClasspath$lambda$0$0$0(Path $classpathRoot, ClassFileEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String packageName = StringsKt.substringBeforeLast((String)entry.getEntryName(), (char)'/', (String)"");
        return new PackageToClasspathRoot(packageName, $classpathRoot);
    }

    private static final Set collectPackagesInClasspath$lambda$0$0(Path $classpathRoot, Sequence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)it, arg_0 -> ClassAncestorResolver.collectPackagesInClasspath$lambda$0$0$0($classpathRoot, arg_0)));
    }

    private static final Iterable collectPackagesInClasspath$lambda$0(Path classpathRoot) {
        Intrinsics.checkNotNullParameter((Object)classpathRoot, (String)"classpathRoot");
        return (Iterable)ClassFileAnalyzerImplKt.withClassRootEntries(classpathRoot, arg_0 -> ClassAncestorResolver.collectPackagesInClasspath$lambda$0$0(classpathRoot, arg_0));
    }

    private static final List collectSuperclasses$lambda$0$0(String $relativePath, ClassAncestorResolver this$0, Path classRoot) {
        Intrinsics.checkNotNullParameter((Object)classRoot, (String)"classRoot");
        Path classFilePath = classRoot.resolve($relativePath);
        Intrinsics.checkNotNull((Object)classFilePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(classFilePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? this$0.loadSuperclasses(classFilePath) : null;
    }
}

