/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.analysis.impl.bytecode;

import com.intellij.java.analysis.bytecode.ClassFileAnalyzer;
import com.intellij.java.analysis.bytecode.JvmBytecodeDeclarationProcessor;
import com.intellij.java.analysis.bytecode.JvmBytecodeReferenceProcessor;
import com.intellij.java.analysis.impl.bytecode.ClassAncestorResolver;
import com.intellij.java.analysis.impl.bytecode.ClassFileAnalysisVisitor;
import com.intellij.java.analysis.impl.bytecode.ClassFileAnalyzerImplKt;
import com.intellij.java.analysis.impl.bytecode.ClassFileEntry;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J$\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u000f2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/java/analysis/impl/bytecode/ClassFileAnalyzerImpl;", "Lcom/intellij/java/analysis/bytecode/ClassFileAnalyzer;", "declarationProcessor", "Lcom/intellij/java/analysis/bytecode/JvmBytecodeDeclarationProcessor;", "referenceProcessor", "Lcom/intellij/java/analysis/bytecode/JvmBytecodeReferenceProcessor;", "implicitAncestorReferencesResolver", "Lcom/intellij/java/analysis/impl/bytecode/ClassAncestorResolver;", "<init>", "(Lcom/intellij/java/analysis/bytecode/JvmBytecodeDeclarationProcessor;Lcom/intellij/java/analysis/bytecode/JvmBytecodeReferenceProcessor;Lcom/intellij/java/analysis/impl/bytecode/ClassAncestorResolver;)V", "visitor", "Lcom/intellij/java/analysis/impl/bytecode/ClassFileAnalysisVisitor;", "processFile", "", "path", "Ljava/nio/file/Path;", "processData", "data", "", "processFileContent", "classFileContent", "processInputStream", "inputStream", "Ljava/io/InputStream;", "processClassFiles", "root", "relativePathFilter", "Lkotlin/Function1;", "", "", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nClassFileAnalyzerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassFileAnalyzerImpl.kt\ncom/intellij/java/analysis/impl/bytecode/ClassFileAnalyzerImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,79:1\n1342#2,2:80\n*S KotlinDebug\n*F\n+ 1 ClassFileAnalyzerImpl.kt\ncom/intellij/java/analysis/impl/bytecode/ClassFileAnalyzerImpl\n*L\n48#1:80,2\n*E\n"})
public final class ClassFileAnalyzerImpl
implements ClassFileAnalyzer {
    @NotNull
    private final ClassFileAnalysisVisitor visitor;

    public ClassFileAnalyzerImpl(@Nullable JvmBytecodeDeclarationProcessor declarationProcessor, @Nullable JvmBytecodeReferenceProcessor referenceProcessor, @Nullable ClassAncestorResolver implicitAncestorReferencesResolver) {
        this.visitor = new ClassFileAnalysisVisitor(declarationProcessor, referenceProcessor, implicitAncestorReferencesResolver);
    }

    public /* synthetic */ ClassFileAnalyzerImpl(JvmBytecodeDeclarationProcessor jvmBytecodeDeclarationProcessor, JvmBytecodeReferenceProcessor jvmBytecodeReferenceProcessor, ClassAncestorResolver classAncestorResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            classAncestorResolver = null;
        }
        this(jvmBytecodeDeclarationProcessor, jvmBytecodeReferenceProcessor, classAncestorResolver);
    }

    public void processFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = Files.readAllBytes(path);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        this.processFileContent(byArray);
    }

    @Deprecated(message="Use processFileContent instead", replaceWith=@ReplaceWith(expression="processFileContent(classFileContent)", imports={}))
    public void processData(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.processFileContent(data);
    }

    public void processFileContent(@NotNull byte[] classFileContent) {
        Intrinsics.checkNotNullParameter((Object)classFileContent, (String)"classFileContent");
        this.visitor.processFileContent(classFileContent);
    }

    public void processInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte[] byArray = inputStream.readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        this.processFileContent(byArray);
    }

    public void processClassFiles(@NotNull Path root, @NotNull Function1<? super String, Boolean> relativePathFilter) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(relativePathFilter, (String)"relativePathFilter");
        ClassFileAnalyzerImplKt.withClassRootEntries(root, arg_0 -> ClassFileAnalyzerImpl.processClassFiles$lambda$0(relativePathFilter, this, arg_0));
    }

    private static final boolean processClassFiles$lambda$0$0(Function1 $relativePathFilter, ClassFileEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$relativePathFilter.invoke((Object)it.getEntryName());
    }

    private static final Unit processClassFiles$lambda$0(Function1 $relativePathFilter, ClassFileAnalyzerImpl this$0, Sequence entries) {
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)entries, arg_0 -> ClassFileAnalyzerImpl.processClassFiles$lambda$0$0($relativePathFilter, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassFileEntry entry = (ClassFileEntry)element$iv;
            boolean bl = false;
            this$0.processFile(entry.getPath());
        }
        return Unit.INSTANCE;
    }
}

