/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.url;

import com.intellij.microservices.url.references.UrlSegmentReferenceTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/microservices/jvm/url/UastUrlPathReferenceProvider;", "Lcom/intellij/psi/UastReferenceProvider;", "provider", "Lkotlin/Function2;", "Lorg/jetbrains/uast/UExpression;", "Lcom/intellij/psi/PsiElement;", "", "Lcom/intellij/psi/PsiReference;", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "getProvider", "()Lkotlin/jvm/functions/Function2;", "getReferencesByElement", "element", "Lorg/jetbrains/uast/UElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lorg/jetbrains/uast/UElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "acceptsTarget", "", "target", "toString", "", "intellij.java.analysis.impl"})
public final class UastUrlPathReferenceProvider
extends UastReferenceProvider {
    @NotNull
    private final Function2<UExpression, PsiElement, PsiReference[]> provider;

    public UastUrlPathReferenceProvider(@NotNull Function2<? super UExpression, ? super PsiElement, PsiReference[]> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        super(UExpression.class);
        this.provider = provider;
    }

    @NotNull
    public final Function2<UExpression, PsiElement, PsiReference[]> getProvider() {
        return this.provider;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull UElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object t = UExpression.class.cast(element);
        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
        return (PsiReference[])this.provider.invoke(t, (Object)UastReferenceRegistrar.getRequestedPsiElement((ProcessingContext)context));
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return target instanceof UrlSegmentReferenceTarget;
    }

    @NotNull
    public String toString() {
        return "UastUrlPathReferenceProvider(" + this.provider + ")";
    }
}

