/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class AssignmentUsedAsConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.used.as.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            AssignmentUsedAsConditionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public LocalQuickFix buildFix(Object ... infos) {
        return new AssignmentUsedAsConditionFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentUsedAsConditionVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection", "buildErrorString"));
    }

    private static class AssignmentUsedAsConditionFix
    extends PsiUpdateModCommandQuickFix {
        private AssignmentUsedAsConditionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"=", "=="});
            if (string == null) {
                AssignmentUsedAsConditionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                AssignmentUsedAsConditionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                AssignmentUsedAsConditionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                AssignmentUsedAsConditionFix.$$$reportNull$$$0(3);
            }
            PsiAssignmentExpression expression = (PsiAssignmentExpression)element;
            PsiExpression leftExpression = expression.getLExpression();
            PsiExpression rightExpression = expression.getRExpression();
            assert (rightExpression != null);
            CommentTracker commentTracker = new CommentTracker();
            String newExpression = commentTracker.text((PsiElement)leftExpression) + "==" + commentTracker.text((PsiElement)rightExpression);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AssignmentUsedAsConditionVisitor
    extends BaseInspectionVisitor {
        private AssignmentUsedAsConditionVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                AssignmentUsedAsConditionVisitor.$$$reportNull$$$0(0);
            }
            super.visitAssignmentExpression(expression);
            if (expression.getRExpression() == null || expression.getOperationTokenType() != JavaTokenType.EQ || !PsiTypes.booleanType().equals((Object)expression.getType())) {
                return;
            }
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getLExpression());
            if (!(lhs instanceof PsiReferenceExpression) && !(lhs instanceof PsiArrayAccessExpression)) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
            if (!PsiUtil.isCondition((PsiElement)expression, (PsiElement)parent)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/assignment/AssignmentUsedAsConditionInspection$AssignmentUsedAsConditionVisitor", "visitAssignmentExpression"));
        }
    }
}

