/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public final class ShiftOutOfRangeInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        LongRangeSet range = (LongRangeSet)infos[0];
        Long val = range.getConstantValue();
        if (val == null) {
            String string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.out.of.bounds", range.toString());
            if (string == null) {
                ShiftOutOfRangeInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (val > 0L) {
            String string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.too.large", val);
            if (string == null) {
                ShiftOutOfRangeInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.negative", val);
        if (string == null) {
            ShiftOutOfRangeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        Long val = ((LongRangeSet)infos[0]).getConstantValue();
        if (val == null) {
            return null;
        }
        return new ShiftOutOfRangeFix(val, (Boolean)infos[1]);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new ShiftOutOfRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bitwise/ShiftOutOfRangeInspection", "buildErrorString"));
    }

    private static class ShiftOutOfRangeFix
    extends PsiUpdateModCommandQuickFix {
        private final long myValue;
        private final boolean myLong;

        ShiftOutOfRangeFix(long value, boolean isLong) {
            this.myValue = value;
            this.myLong = isLong;
        }

        @NotNull
        public String getName() {
            int newValue = (int)(this.myValue & (long)(this.myLong ? 63 : 31));
            String string = CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myValue, newValue});
            if (string == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("shift.out.of.range.fix.family.name", new Object[0]);
            if (string == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiBinaryExpression binaryExpression;
            if (project == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ShiftOutOfRangeFix.$$$reportNull$$$0(4);
            }
            if ((binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiBinaryExpression.class)) == null) {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            int mask = PsiTypes.longType().equals((Object)lhs.getType()) ? 63 : 31;
            String text = String.valueOf(this.myValue & (long)mask);
            new CommentTracker().replaceAndRestoreComments((PsiElement)rhs, text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bitwise/ShiftOutOfRangeInspection$ShiftOutOfRangeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bitwise/ShiftOutOfRangeInspection$ShiftOutOfRangeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ShiftOutOfRange
    extends BaseInspectionVisitor {
        private ShiftOutOfRange() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            LongRangeSet allowedRange;
            if (expression == null) {
                ShiftOutOfRange.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!ElementType.SHIFT_OPS.contains(tokenType)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            if (expressionType.equals(PsiTypes.longType())) {
                allowedRange = LongRangeSet.range((long)0L, (long)63L);
            } else if (expressionType.equals(PsiTypes.intType())) {
                allowedRange = LongRangeSet.range((long)0L, (long)31L);
            } else {
                return;
            }
            LongRangeSet actualRange = CommonDataflow.getExpressionRange(rhs);
            if (actualRange != null && !actualRange.isEmpty() && !actualRange.intersects(allowedRange)) {
                this.registerError((PsiElement)sign, actualRange, expressionType.equals(PsiTypes.longType()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bitwise/ShiftOutOfRangeInspection$ShiftOutOfRange", "visitBinaryExpression"));
        }
    }
}

