/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.ThreeState;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.InheritanceUtil;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import org.jetbrains.annotations.NotNull;

public final class CastToIncompatibleInterfaceInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Boolean isInterface = (Boolean)infos[0];
        String className = (String)infos[1];
        String string = InspectionGadgetsBundle.message("casting.to.incompatible.interface.problem.descriptor", isInterface != false ? 1 : 2, className);
        if (string == null) {
            CastToIncompatibleInterfaceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new CastToIncompatibleInterfaceVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/CastToIncompatibleInterfaceInspection", "buildErrorString"));
    }

    private static class CastToIncompatibleInterfaceVisitor
    extends BaseInspectionVisitor {
        private CastToIncompatibleInterfaceVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            if (expression == null) {
                CastToIncompatibleInterfaceVisitor.$$$reportNull$$$0(0);
            }
            super.visitTypeCastExpression(expression);
            PsiTypeElement castTypeElement = expression.getCastType();
            if (castTypeElement == null) {
                return;
            }
            PsiType castType = castTypeElement.getType();
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiClassType castClassType = (PsiClassType)castType;
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            PsiClassType operandClassType = (PsiClassType)operandType;
            if (!castClassType.isConvertibleFrom((PsiType)operandClassType)) {
                return;
            }
            PsiClass castClass = castClassType.resolve();
            if (castClass == null) {
                return;
            }
            PsiClass operandClass = operandClassType.resolve();
            if (operandClass == null) {
                return;
            }
            String operandClassName = operandClass.getName();
            if (operandClassName == null) {
                return;
            }
            ThreeState hasMutualSubclass = InheritanceUtil.existsMutualSubclass(operandClass, castClass, this.isOnTheFly());
            if (hasMutualSubclass == ThreeState.YES) {
                return;
            }
            if (InstanceOfUtils.findCorrespondingInstanceOf(expression) != null) {
                return;
            }
            PsiType psiType = TypeConstraint.fromDfType(CommonDataflow.getDfType(operand)).getPsiType(operandClass.getProject());
            if (psiType != null && castClassType.isAssignableFrom(psiType)) {
                return;
            }
            if (hasMutualSubclass == ThreeState.UNSURE) {
                this.registerPossibleProblem((PsiElement)castTypeElement);
            } else {
                this.registerError((PsiElement)castTypeElement, castClass.isInterface(), operandClassName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/CastToIncompatibleInterfaceInspection$CastToIncompatibleInterfaceVisitor", "visitTypeCastExpression"));
        }
    }
}

