/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NumberEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("number.comparison.problem.descriptor", new Object[0]);
        if (string == null) {
            NumberEqualityInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new NumberEqualityVisitor();
    }

    @Override
    protected LocalQuickFix @NotNull [] buildFixes(Object ... infos) {
        LocalQuickFix[] localQuickFixArray = EqualityToEqualsFix.buildEqualityFixes((PsiBinaryExpression)infos[0]);
        if (localQuickFixArray == null) {
            NumberEqualityInspection.$$$reportNull$$$0(1);
        }
        return localQuickFixArray;
    }

    private static PsiElement getElementMustContainNumberEquality(PsiElement element, boolean isNegated, boolean areBothOperandsComparedWithNull) {
        PsiExpression result;
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)element;
            PsiExpression thenExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getThenExpression());
            PsiExpression elseExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getElseExpression());
            result = isNegated ^ areBothOperandsComparedWithNull ? thenExpression : elseExpression;
        } else if (element instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)element;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            PsiStatement elseBranch = ifStatement.getElseBranch();
            result = isNegated ^ areBothOperandsComparedWithNull ? thenBranch : elseBranch;
        } else {
            result = null;
        }
        return result;
    }

    private static PsiExpression getAnotherOperand(@NotNull PsiBinaryExpression expression, PsiExpression operand) {
        PsiExpression rOperand;
        if (expression == null) {
            NumberEqualityInspection.$$$reportNull$$$0(2);
        }
        return (rOperand = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression.getROperand())) != operand ? rOperand : expression.getLOperand();
    }

    private static boolean isOneOfVariablesDefinitelyNullAsPartOfBooleanExpression(PsiBinaryExpression expression, Filter filter) {
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent()), PsiBinaryExpression.class);
        if (binOp == null) {
            return false;
        }
        return filter.isOneOfVariablesDefinitelyNull((PsiElement)binOp, binOp.getLOperand()) || filter.isOneOfVariablesDefinitelyNull((PsiElement)binOp, binOp.getROperand());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/bugs/NumberEqualityInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFixes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/bugs/NumberEqualityInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAnotherOperand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class NumberEqualityVisitor
    extends BaseInspectionVisitor {
        private NumberEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            boolean isOneOfVariablesDefinitelyNull;
            DfaNullability rightNullability;
            if (expression == null) {
                NumberEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (!NumberEqualityVisitor.hasNumberType(rhs)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!NumberEqualityVisitor.hasNumberType(lhs)) {
                return;
            }
            if (NumberEqualityVisitor.isUniqueConstant(rhs) || NumberEqualityVisitor.isUniqueConstant(lhs)) {
                return;
            }
            DfNullConstantType leftConstant = (DfNullConstantType)ObjectUtils.tryCast((Object)CommonDataflow.getDfType(lhs), DfNullConstantType.class);
            DfNullConstantType rightConstant = (DfNullConstantType)ObjectUtils.tryCast((Object)CommonDataflow.getDfType(rhs), DfNullConstantType.class);
            DfaNullability leftNullability = leftConstant != null ? leftConstant.getNullability() : null;
            DfaNullability dfaNullability = rightNullability = rightConstant != null ? rightConstant.getNullability() : null;
            if (leftNullability == DfaNullability.NULL || rightNullability == DfaNullability.NULL) {
                return;
            }
            Filter filter = new Filter(lhs, rhs);
            if (NumberEqualityInspection.isOneOfVariablesDefinitelyNullAsPartOfBooleanExpression(expression, filter)) {
                return;
            }
            PsiElement element = PsiTreeUtil.findFirstParent((PsiElement)expression, (Condition)filter);
            boolean bl = isOneOfVariablesDefinitelyNull = element != null;
            if (isOneOfVariablesDefinitelyNull) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), expression);
        }

        private static boolean isUniqueConstant(PsiExpression expression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiReferenceExpression.class);
            if (ref == null) {
                return false;
            }
            PsiField target = (PsiField)ObjectUtils.tryCast((Object)ref.resolve(), PsiField.class);
            if (target == null) {
                return false;
            }
            if (target instanceof PsiEnumConstant) {
                return true;
            }
            if (!(target instanceof PsiFieldImpl)) {
                return false;
            }
            if (!target.hasModifierProperty("static") || !target.hasModifierProperty("final")) {
                return false;
            }
            PsiExpression initializer = PsiFieldImpl.getDetachedInitializer((PsiVariable)target);
            return ExpressionUtils.isNewObject(initializer);
        }

        private static boolean hasNumberType(PsiExpression expression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.Number");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/NumberEqualityInspection$NumberEqualityVisitor", "visitBinaryExpression"));
        }
    }

    private static final class Filter
    implements Condition<PsiElement> {
        private final PsiExpression lhs;
        private final PsiExpression rhs;

        private Filter(PsiExpression lhs, PsiExpression rhs) {
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public boolean value(PsiElement element) {
            PsiExpression condition;
            PsiConditionalExpression ternary = (PsiConditionalExpression)ObjectUtils.tryCast((Object)element, PsiConditionalExpression.class);
            if (ternary != null && this.isOneOfVariablesDefinitelyNull((PsiElement)ternary, condition = ternary.getCondition())) {
                return true;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)element, PsiIfStatement.class);
            if (ifStatement == null) {
                return false;
            }
            PsiExpression condition2 = ifStatement.getCondition();
            return this.isOneOfVariablesDefinitelyNull((PsiElement)ifStatement, condition2);
        }

        public boolean isOneOfVariablesDefinitelyNull(PsiElement element, PsiExpression condition) {
            boolean isEffectivelyFinal;
            List<IElementType> targetTokenTypes;
            boolean areBothOperandsComparedWithNotNull;
            if ((condition = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)) == null) {
                return false;
            }
            boolean isNegated = false;
            PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition, PsiBinaryExpression.class);
            if (binOp == null && BoolUtils.isNegation(condition)) {
                PsiExpression operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiPrefixExpression)condition).getOperand());
                binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)operand, PsiBinaryExpression.class);
                isNegated = true;
            }
            if (binOp == null) {
                return false;
            }
            IElementType tokenType = binOp.getOperationTokenType();
            PsiBinaryExpression lOperand = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand()), PsiBinaryExpression.class);
            PsiBinaryExpression rOperand = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand()), PsiBinaryExpression.class);
            if (lOperand == null || rOperand == null) {
                return false;
            }
            PsiExpression lValue = ExpressionUtils.getValueComparedWithNull(lOperand);
            PsiExpression rValue = ExpressionUtils.getValueComparedWithNull(rOperand);
            if (lValue == null || rValue == null) {
                return false;
            }
            IElementType lTokenType = lOperand.getOperationTokenType();
            IElementType rTokenType = rOperand.getOperationTokenType();
            boolean areBothOperandsComparedWithNull = lTokenType == JavaTokenType.EQEQ && rTokenType == JavaTokenType.EQEQ;
            boolean bl = areBothOperandsComparedWithNotNull = lTokenType == JavaTokenType.NE && rTokenType == JavaTokenType.NE;
            if (areBothOperandsComparedWithNull == areBothOperandsComparedWithNotNull) {
                return false;
            }
            List<IElementType> list = targetTokenTypes = areBothOperandsComparedWithNull ? Arrays.asList(JavaTokenType.OROR, JavaTokenType.OR) : Arrays.asList(JavaTokenType.ANDAND, JavaTokenType.AND);
            if (!targetTokenTypes.contains(tokenType)) {
                return false;
            }
            Object elementContainsNumberEquality = element instanceof PsiBinaryExpression ? NumberEqualityInspection.getAnotherOperand((PsiBinaryExpression)element, condition) : NumberEqualityInspection.getElementMustContainNumberEquality(element, isNegated, areBothOperandsComparedWithNull);
            if (!PsiTreeUtil.isAncestor((PsiElement)elementContainsNumberEquality, (PsiElement)this.lhs, (boolean)false)) {
                return false;
            }
            EquivalenceChecker checker = EquivalenceChecker.getCanonicalPsiEquivalence();
            PsiReferenceExpression lReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.lhs), PsiReferenceExpression.class);
            if (lReference == null) {
                return false;
            }
            PsiReferenceExpression rReference = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)this.rhs), PsiReferenceExpression.class);
            if (rReference == null) {
                return false;
            }
            PsiVariable lVariable = (PsiVariable)ObjectUtils.tryCast((Object)lReference.resolve(), PsiVariable.class);
            if (lVariable == null) {
                return false;
            }
            PsiVariable rVariable = (PsiVariable)ObjectUtils.tryCast((Object)rReference.resolve(), PsiVariable.class);
            if (rVariable == null) {
                return false;
            }
            boolean bl2 = isEffectivelyFinal = ControlFlowUtil.isEffectivelyFinal((PsiVariable)lVariable, (PsiElement)elementContainsNumberEquality) && ControlFlowUtil.isEffectivelyFinal((PsiVariable)rVariable, (PsiElement)elementContainsNumberEquality);
            if (!isEffectivelyFinal) {
                return false;
            }
            return checker.expressionsMatch(this.lhs, lValue).isExactMatch() && checker.expressionsMatch(this.rhs, rValue).isExactMatch() || checker.expressionsMatch(this.lhs, rValue).isExactMatch() && checker.expressionsMatch(this.rhs, lValue).isExactMatch();
        }
    }
}

