/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringConcatenationInMessageFormatCallInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.in.message.format.call.problem.descriptor", new Object[0]);
        if (string == null) {
            StringConcatenationInMessageFormatCallInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected LocalQuickFix buildFix(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        String referenceName = referenceExpression.getReferenceName();
        return new StringConcatenationInFormatCallFix(referenceName);
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationInMessageFormatCallVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StringConcatenationInMessageFormatCallInspection", "buildErrorString"));
    }

    private static class StringConcatenationInFormatCallFix
    extends PsiUpdateModCommandQuickFix {
        private final String variableName;

        StringConcatenationInFormatCallFix(String variableName) {
            this.variableName = variableName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.quickfix", this.variableName);
            if (string == null) {
                StringConcatenationInFormatCallFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.in.format.call.fix.family.name", new Object[0]);
            if (string == null) {
                StringConcatenationInFormatCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                StringConcatenationInFormatCallFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                StringConcatenationInFormatCallFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                StringConcatenationInFormatCallFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
            PsiElement parent = binaryExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiExpression[] expressions = expressionList.getExpressions();
            int parameter = expressions.length - 1;
            expressionList.add((PsiElement)rhs);
            Object constant = ExpressionUtils.computeConstantExpression(lhs);
            if (constant instanceof String) {
                PsiExpression newExpression = StringConcatenationInFormatCallFix.addParameter(lhs, parameter);
                if (newExpression == null) {
                    expressionList.addAfter((PsiElement)lhs, (PsiElement)binaryExpression);
                } else {
                    expressionList.addAfter((PsiElement)newExpression, (PsiElement)binaryExpression);
                }
            } else {
                expressionList.addAfter((PsiElement)lhs, (PsiElement)binaryExpression);
            }
            binaryExpression.delete();
        }

        @Nullable
        private static PsiExpression addParameter(PsiExpression expression, int parameterNumber) {
            if (expression instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return null;
                }
                PsiExpression newExpression = StringConcatenationInFormatCallFix.addParameter(rhs, parameterNumber);
                if (newExpression == null) {
                    return null;
                }
                rhs.replace((PsiElement)newExpression);
                return expression;
            }
            if (expression instanceof PsiLiteralExpression) {
                PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression;
                Object value = literalExpression.getValue();
                if (!(value instanceof String)) {
                    return null;
                }
                Project project = expression.getProject();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                return factory.createExpressionFromText("\"" + String.valueOf(value) + "{" + parameterNumber + "}\"", null);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/siyeh/ig/bugs/StringConcatenationInMessageFormatCallInspection$StringConcatenationInFormatCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/siyeh/ig/bugs/StringConcatenationInMessageFormatCallInspection$StringConcatenationInFormatCallFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class StringConcatenationInMessageFormatCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationInMessageFormatCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                StringConcatenationInMessageFormatCallVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!StringConcatenationInMessageFormatCallVisitor.isMessageFormatCall(expression)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression firstArgument = arguments[0];
            PsiType type = firstArgument.getType();
            if (type == null) {
                return;
            }
            int formatArgumentIndex = "java.util.Locale".equals(type.getCanonicalText()) && arguments.length > 1 ? 1 : 0;
            PsiExpression formatArgument = arguments[formatArgumentIndex];
            PsiType formatArgumentType = formatArgument.getType();
            if (formatArgumentType == null || !formatArgumentType.equalsToText("java.lang.String")) {
                return;
            }
            if (!(formatArgument instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)formatArgument;
            if (PsiUtil.isConstantExpression((PsiExpression)formatArgument)) {
                return;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (lhsType == null || !lhsType.equalsToText("java.lang.String")) {
                return;
            }
            PsiExpression rhs = binaryExpression.getROperand();
            if (!(rhs instanceof PsiReferenceExpression)) {
                return;
            }
            this.registerError((PsiElement)formatArgument, rhs);
        }

        private static boolean isMessageFormatCall(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            @NonNls String referenceName = methodExpression.getReferenceName();
            if (!"format".equals(referenceName)) {
                return false;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiClass aClass = (PsiClass)target;
            return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.text.MessageFormat");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/bugs/StringConcatenationInMessageFormatCallInspection$StringConcatenationInMessageFormatCallVisitor", "visitMethodCallExpression"));
        }
    }
}

